/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.stubs.impl;

import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.impl.JSObjectLiteralExpressionImpl;
import com.intellij.lang.javascript.psi.stubs.JSBaseTypesIndex;
import com.intellij.lang.javascript.psi.stubs.JSObjectLiteralExpressionStub;
import com.intellij.lang.javascript.psi.stubs.impl.JSStubBase;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.io.DataInputOutputUtil;
import gnu.trove.THashSet;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JSObjectLiteralExpressionStubImpl
extends JSStubBase<JSObjectLiteralExpression>
implements JSObjectLiteralExpressionStub {
    @NotNull
    private final Set<String> myExtendedTypes;

    public JSObjectLiteralExpressionStubImpl(JSObjectLiteralExpression clazz, StubElement parent) {
        super(clazz, parent, (IStubElementType)JSStubElementTypes.OBJECT_LITERAL_EXPRESSION);
        this.myExtendedTypes = clazz.getExtendedTypes();
    }

    public JSObjectLiteralExpressionStubImpl(StubInputStream dataStream, StubElement parentStub) throws IOException {
        super(dataStream, parentStub, (IStubElementType)JSStubElementTypes.OBJECT_LITERAL_EXPRESSION);
        int extendedTypesLength = DataInputOutputUtil.readINT((DataInput)dataStream);
        if (extendedTypesLength > 0) {
            this.myExtendedTypes = new THashSet();
            while (extendedTypesLength-- > 0) {
                this.myExtendedTypes.add(dataStream.readName().getString());
            }
        } else {
            this.myExtendedTypes = Collections.emptySet();
        }
    }

    @Override
    public void serialize(StubOutputStream dataStream) throws IOException {
        super.serialize(dataStream);
        DataInputOutputUtil.writeINT((DataOutput)dataStream, (int)this.myExtendedTypes.size());
        for (String type : this.myExtendedTypes) {
            dataStream.writeName(type);
        }
    }

    public JSObjectLiteralExpression createPsi() {
        return new JSObjectLiteralExpressionImpl(this);
    }

    public void index(IndexSink sink) {
        for (String extendedType : this.myExtendedTypes) {
            sink.occurrence(JSBaseTypesIndex.KEY, (Object)extendedType);
        }
    }

    @NotNull
    public Set<String> getExtendedTypes() {
        Set<String> set = this.myExtendedTypes;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/stubs/impl/JSObjectLiteralExpressionStubImpl", "getExtendedTypes"));
        }
        return set;
    }
}

