/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSTypeHelper;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSTypeBaseImpl
extends UserDataHolderBase
implements JSType {
    private JSTypeSource mySource;

    protected JSTypeBaseImpl(@NotNull JSTypeSource source) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/psi/types/JSTypeBaseImpl", "<init>"));
        }
        this.mySource = source;
    }

    @NotNull
    public String getTypeText() {
        String string = this.getTypeText(JSType.TypeTextFormat.SIMPLE);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTypeBaseImpl", "getTypeText"));
        }
        return string;
    }

    @NotNull
    public String getResolvedTypeText() {
        String string = this.getTypeText(JSType.TypeTextFormat.RESOLVED);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTypeBaseImpl", "getResolvedTypeText"));
        }
        return string;
    }

    @NotNull
    public JSTypeSource getSource() {
        JSTypeSource jSTypeSource = this.mySource;
        if (jSTypeSource == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTypeBaseImpl", "getSource"));
        }
        return jSTypeSource;
    }

    public void accept(JSRecursiveTypeVisitor visitor) {
        visitor.visitJSTypeBaseImpl((JSType)this);
    }

    public void acceptChildren(JSRecursiveTypeVisitor visitor) {
    }

    public void setSourceIfEmpty(final JSTypeSource source) {
        JSRecursiveTypeVisitor visitor = new JSRecursiveTypeVisitor(){

            public void visitJSTypeBaseImpl(JSType type) {
                if (((JSTypeBaseImpl)type).mySource == JSTypeSource.EMPTY) {
                    ((JSTypeBaseImpl)type).mySource = source;
                }
                super.visitJSTypeBaseImpl(type);
            }
        };
        this.accept(visitor);
    }

    @Nullable
    public PsiFile getScope() {
        return this.mySource == null ? null : this.mySource.getScope();
    }

    public boolean isEcma() {
        return this.mySource != null && this.mySource.isEcma();
    }

    public boolean isTypeScript() {
        return this.mySource != null && this.mySource.getLanguage() == JSTypeSource.SourceLanguage.TS;
    }

    public boolean isJavaScript() {
        return this.mySource == null || this.mySource.getLanguage() == JSTypeSource.SourceLanguage.JS;
    }

    public boolean isExplicitlyDeclared() {
        return this.mySource != null && this.mySource.isExplicitlyDeclared();
    }

    @NotNull
    protected JSTypeHelper getTypeHelper() {
        JSLanguageDialect language = null;
        switch (this.getSource().getLanguage()) {
            case TS: {
                language = JavaScriptSupportLoader.TYPESCRIPT;
                break;
            }
            case AS: {
                language = JavaScriptSupportLoader.ECMA_SCRIPT_L4;
                break;
            }
            case JS: {
                language = JavascriptLanguage.INSTANCE;
            }
        }
        JSTypeHelper jSTypeHelper = JSDialectSpecificHandlersFactory.forLanguage(language).getTypeHelper();
        if (jSTypeHelper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTypeBaseImpl", "getTypeHelper"));
        }
        return jSTypeHelper;
    }

    @Nullable
    public JSClass resolveClass() {
        return null;
    }

    @NotNull
    public final JSType transformTypeHierarchy(@NotNull Function<JSType, JSType> transformation, @Nullable JSTypeSource newSource) {
        if (transformation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "transformation", "com/intellij/lang/javascript/psi/types/JSTypeBaseImpl", "transformTypeHierarchy"));
        }
        JSType transformedType = (JSType)transformation.fun((Object)this);
        if (this != transformedType) {
            JSType jSType = transformedType;
            if (jSType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTypeBaseImpl", "transformTypeHierarchy"));
            }
            return jSType;
        }
        JSType jSType = this.copyTypeHierarchy(transformation, newSource);
        if (jSType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTypeBaseImpl", "transformTypeHierarchy"));
        }
        return jSType;
    }

    protected JSTypeSource getSourceForCopy(@Nullable JSTypeSource newSource) {
        return newSource == null ? this.getSource() : newSource;
    }

    protected abstract JSType copyTypeHierarchy(@NotNull Function<JSType, JSType> var1, @Nullable JSTypeSource var2);

    @NotNull
    public JSType substitute() {
        JSTypeBaseImpl jSTypeBaseImpl = this;
        if (jSTypeBaseImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTypeBaseImpl", "substitute"));
        }
        return jSTypeBaseImpl;
    }

    @NotNull
    public JSRecordType asRecordType() {
        JSTypeSource source = this.getSource();
        PsiElement element = source.getSourceElement();
        if (element != null) {
            JSRecordType jSRecordType = (JSRecordType)CachedValuesManager.getManager((Project)element.getProject()).getCachedValue((UserDataHolder)this, (CachedValueProvider)new CachedValueProvider<JSRecordType>(){

                @Nullable
                public CachedValueProvider.Result<JSRecordType> compute() {
                    return CachedValueProvider.Result.create((Object)JSTypeBaseImpl.this.asRecordTypeNoCache(), (Object[])new Object[]{JSTypeUtils.getTypeInvalidationDependency()});
                }
            });
            if (jSRecordType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTypeBaseImpl", "asRecordType"));
            }
            return jSRecordType;
        }
        JSRecordType jSRecordType = this.asRecordTypeNoCache();
        if (jSRecordType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTypeBaseImpl", "asRecordType"));
        }
        return jSRecordType;
    }

    @NotNull
    protected JSRecordType asRecordTypeNoCache() {
        JSType substitute = this.substitute();
        if (substitute != this) {
            JSRecordType jSRecordType = substitute.asRecordType();
            if (jSRecordType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTypeBaseImpl", "asRecordTypeNoCache"));
            }
            return jSRecordType;
        }
        JSRecordType jSRecordType = TypeScriptTypeParser.buildResolvedType(this);
        if (jSRecordType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTypeBaseImpl", "asRecordTypeNoCache"));
        }
        return jSRecordType;
    }
}

