/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSDecoratedTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSIntersectionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSIterableComponentTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSRequireCallExpressionType;
import com.intellij.lang.javascript.psi.types.JSSpecialNamedTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeofTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptGenericThisTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.psi.types.TypeScriptTypePredicateTypeImpl;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.lang.javascript.psi.types.primitives.JSNumberType;
import com.intellij.lang.javascript.psi.types.primitives.JSUndefinedType;
import com.intellij.openapi.util.Key;
import com.intellij.util.ProcessingContext;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSTypeCastUtil {
    private static final Key<Map<String, Set<String>>> OUR_ALREADY_COMPARED_TYPES_KEY = Key.create((String)"already.compared.types");

    public static boolean startRecursiveTypesComparison(@NotNull JSNamedType type1, @NotNull JSNamedType type2, @NotNull ProcessingContext processingContext) {
        if (type1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type1", "com/intellij/lang/javascript/psi/types/JSTypeCastUtil", "startRecursiveTypesComparison"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type2", "com/intellij/lang/javascript/psi/types/JSTypeCastUtil", "startRecursiveTypesComparison"));
        }
        if (processingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processingContext", "com/intellij/lang/javascript/psi/types/JSTypeCastUtil", "startRecursiveTypesComparison"));
        }
        String qName1 = JSTypeCastUtil.getTypeStringForComparison(type1);
        String qName2 = JSTypeCastUtil.getTypeStringForComparison(type2);
        return JSTypeCastUtil.startRecursiveTypesComparison(qName1, qName2, processingContext);
    }

    public static void endRecursiveTypesComparison(@NotNull JSNamedType type1, @NotNull JSNamedType type2, @NotNull ProcessingContext processingContext) {
        if (type1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type1", "com/intellij/lang/javascript/psi/types/JSTypeCastUtil", "endRecursiveTypesComparison"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type2", "com/intellij/lang/javascript/psi/types/JSTypeCastUtil", "endRecursiveTypesComparison"));
        }
        if (processingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processingContext", "com/intellij/lang/javascript/psi/types/JSTypeCastUtil", "endRecursiveTypesComparison"));
        }
        String qName1 = JSTypeCastUtil.getTypeStringForComparison(type1);
        String qName2 = JSTypeCastUtil.getTypeStringForComparison(type2);
        JSTypeCastUtil.endRecursiveTypesComparison(qName1, qName2, processingContext);
    }

    @NotNull
    private static String getTypeStringForComparison(JSNamedType type1) {
        String string = (JSTypeContext.STATIC == type1.getTypeContext() ? "static#" : "") + type1.getResolvedTypeText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTypeCastUtil", "getTypeStringForComparison"));
        }
        return string;
    }

    public static boolean startRecursiveTypesComparison(String thisQName, String elementQName, @NotNull ProcessingContext processingContext) {
        Set typesComparedToThis;
        if (processingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processingContext", "com/intellij/lang/javascript/psi/types/JSTypeCastUtil", "startRecursiveTypesComparison"));
        }
        Map alreadyComparedTypes = (Map)processingContext.get(OUR_ALREADY_COMPARED_TYPES_KEY);
        if (alreadyComparedTypes == null) {
            alreadyComparedTypes = new THashMap();
            processingContext.put(OUR_ALREADY_COMPARED_TYPES_KEY, (Object)alreadyComparedTypes);
        }
        if ((typesComparedToThis = (Set)alreadyComparedTypes.get(thisQName)) == null) {
            THashSet set = new THashSet();
            set.add((Object)elementQName);
            alreadyComparedTypes.put(thisQName, set);
            return true;
        }
        return typesComparedToThis.add(elementQName);
    }

    public static void endRecursiveTypesComparison(String thisQName, String elementQName, @NotNull ProcessingContext processingContext) {
        Set elementQNames;
        if (processingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processingContext", "com/intellij/lang/javascript/psi/types/JSTypeCastUtil", "endRecursiveTypesComparison"));
        }
        Map alreadyComparedTypes = (Map)processingContext.get(OUR_ALREADY_COMPARED_TYPES_KEY);
        if (alreadyComparedTypes != null && (elementQNames = (Set)alreadyComparedTypes.get(thisQName)) != null) {
            elementQNames.remove(elementQName);
        }
    }

    public static boolean isAlwaysAssignableType(@Nullable JSType type) {
        if (type == null || type instanceof JSAnyType) {
            return true;
        }
        if (type instanceof JSNullType && type.getSource().getLanguage() != JSTypeSource.SourceLanguage.JS) {
            return true;
        }
        return type instanceof JSUndefinedType;
    }

    @NotNull
    public static AssignableResult isDirectlyAssignableTypeCommon(@NotNull JSType thisOperand, @Nullable JSType rOperand, @Nullable ProcessingContext processingContext) {
        JSType type;
        if (thisOperand == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thisOperand", "com/intellij/lang/javascript/psi/types/JSTypeCastUtil", "isDirectlyAssignableTypeCommon"));
        }
        if (JSTypeCastUtil.isAlwaysAssignableType(rOperand)) {
            AssignableResult assignableResult = AssignableResult.STRICTLY_ASSIGNABLE;
            if (assignableResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTypeCastUtil", "isDirectlyAssignableTypeCommon"));
            }
            return assignableResult;
        }
        if (rOperand instanceof JSCompositeTypeImpl && (rOperand.getSource().getLanguage() != JSTypeSource.SourceLanguage.TS || !rOperand.getSource().isExplicitlyDeclared())) {
            for (JSType jsType2 : ((JSCompositeTypeImpl)rOperand).getTypes()) {
                if (!thisOperand.isDirectlyAssignableType(jsType2, processingContext)) continue;
                AssignableResult assignableResult = AssignableResult.STRICTLY_ASSIGNABLE;
                if (assignableResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTypeCastUtil", "isDirectlyAssignableTypeCommon"));
                }
                return assignableResult;
            }
            AssignableResult assignableResult = AssignableResult.STRICTLY_NOT_ASSIGNABLE;
            if (assignableResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTypeCastUtil", "isDirectlyAssignableTypeCommon"));
            }
            return assignableResult;
        }
        if (rOperand instanceof JSCompositeTypeImpl) {
            JSType jsType;
            boolean result = true;
            Iterator<JSType> jsType2 = ((JSCompositeTypeImpl)rOperand).getTypes().iterator();
            while (jsType2.hasNext() && (result = thisOperand.isDirectlyAssignableType(jsType = jsType2.next(), processingContext))) {
            }
            if (result) {
                AssignableResult assignableResult = JSTypeCastUtil.toStrictAssignable(true);
                if (assignableResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTypeCastUtil", "isDirectlyAssignableTypeCommon"));
                }
                return assignableResult;
            }
            AssignableResult assignableResult = JSTypeCastUtil.toStrictAssignable(thisOperand.isDirectlyAssignableType(rOperand.substitute(), processingContext));
            if (assignableResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTypeCastUtil", "isDirectlyAssignableTypeCommon"));
            }
            return assignableResult;
        }
        if (rOperand instanceof JSGenericParameterImpl) {
            JSType type2 = ((JSGenericParameterImpl)rOperand).getConstraintType();
            if (type2 != null) {
                AssignableResult assignableResult = JSTypeCastUtil.toStrictAssignable(thisOperand.isDirectlyAssignableType(type2, processingContext));
                if (assignableResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTypeCastUtil", "isDirectlyAssignableTypeCommon"));
                }
                return assignableResult;
            }
            AssignableResult assignableResult = JSTypeCastUtil.toStrictAssignable(rOperand.isDirectlyAssignableType(thisOperand, processingContext));
            if (assignableResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTypeCastUtil", "isDirectlyAssignableTypeCommon"));
            }
            return assignableResult;
        }
        if (rOperand instanceof JSTypeImpl) {
            JSType typedefValue;
            JSTypeImpl jsType = (JSTypeImpl)rOperand;
            if (processingContext == null) {
                processingContext = new ProcessingContext();
            }
            if ((typedefValue = jsType.getTypedef(null, processingContext)) != null) {
                if (!JSTypeCastUtil.startRecursiveTypesComparison(thisOperand.getResolvedTypeText(), jsType.getResolvedTypeText(), processingContext)) {
                    AssignableResult assignableResult = AssignableResult.STRICTLY_ASSIGNABLE;
                    if (assignableResult == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTypeCastUtil", "isDirectlyAssignableTypeCommon"));
                    }
                    return assignableResult;
                }
                AssignableResult assignableResult = JSTypeCastUtil.toStrictAssignable(thisOperand.isDirectlyAssignableType(typedefValue, processingContext));
                if (assignableResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTypeCastUtil", "isDirectlyAssignableTypeCommon"));
                }
                return assignableResult;
            }
            if (thisOperand instanceof JSSpecialNamedTypeImpl) {
                JSSpecialNamedTypeImpl specialNamedType = (JSSpecialNamedTypeImpl)thisOperand;
                if (jsType.isEnum()) {
                    AssignableResult assignableResult = JSTypeCastUtil.toStrictAssignable(thisOperand instanceof JSNumberType);
                    if (assignableResult == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTypeCastUtil", "isDirectlyAssignableTypeCommon"));
                    }
                    return assignableResult;
                }
                if (specialNamedType.getTypeHelper().areNamedTypesAssignable((JSNamedType)thisOperand, (JSNamedType)rOperand, processingContext)) {
                    AssignableResult assignableResult = AssignableResult.STRICTLY_ASSIGNABLE;
                    if (assignableResult == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTypeCastUtil", "isDirectlyAssignableTypeCommon"));
                    }
                    return assignableResult;
                }
            }
        } else {
            if (rOperand instanceof JSDecoratedTypeImpl && !((JSDecoratedTypeImpl)rOperand).getDecorations().isEmpty()) {
                AssignableResult assignableResult = JSTypeCastUtil.toStrictAssignable(thisOperand.isDirectlyAssignableType(((JSDecoratedTypeImpl)rOperand).getType(), processingContext));
                if (assignableResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTypeCastUtil", "isDirectlyAssignableTypeCommon"));
                }
                return assignableResult;
            }
            if (rOperand instanceof JSTypeofTypeImpl) {
                AssignableResult assignableResult = JSTypeCastUtil.toStrictAssignable(thisOperand.isDirectlyAssignableType(((JSTypeofTypeImpl)rOperand).evaluateType(), processingContext));
                if (assignableResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTypeCastUtil", "isDirectlyAssignableTypeCommon"));
                }
                return assignableResult;
            }
            if (rOperand instanceof JSRequireCallExpressionType) {
                AssignableResult assignableResult = AssignableResult.STRICTLY_ASSIGNABLE;
                if (assignableResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTypeCastUtil", "isDirectlyAssignableTypeCommon"));
                }
                return assignableResult;
            }
            if (rOperand instanceof JSNumberType && thisOperand instanceof JSTypeImpl) {
                JSTypeImpl thisImplType = (JSTypeImpl)thisOperand;
                if (thisImplType.isEnum()) {
                    AssignableResult assignableResult = AssignableResult.STRICTLY_ASSIGNABLE;
                    if (assignableResult == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTypeCastUtil", "isDirectlyAssignableTypeCommon"));
                    }
                    return assignableResult;
                }
            } else {
                if (rOperand instanceof TypeScriptTypePredicateTypeImpl) {
                    TypeScriptTypePredicateTypeImpl predicateType = (TypeScriptTypePredicateTypeImpl)rOperand;
                    AssignableResult assignableResult = JSTypeCastUtil.toStrictAssignable(thisOperand.isDirectlyAssignableType(predicateType.asBoolean(), processingContext));
                    if (assignableResult == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTypeCastUtil", "isDirectlyAssignableTypeCommon"));
                    }
                    return assignableResult;
                }
                if (rOperand instanceof JSGenericTypeImpl) {
                    JSType substitutedType;
                    type = ((JSGenericTypeImpl)rOperand).getType();
                    if (type instanceof JSTypeImpl && ((JSTypeImpl)type).getTypedef(null, processingContext) != null && (substitutedType = rOperand.substitute()) != rOperand) {
                        AssignableResult assignableResult = JSTypeCastUtil.toStrictAssignable(thisOperand.isDirectlyAssignableType(substitutedType, processingContext));
                        if (assignableResult == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTypeCastUtil", "isDirectlyAssignableTypeCommon"));
                        }
                        return assignableResult;
                    }
                } else if (rOperand instanceof JSIntersectionTypeImpl) {
                    JSIntersectionTypeImpl intersectionType = (JSIntersectionTypeImpl)rOperand;
                    for (JSType type3 : intersectionType.getTypes()) {
                        if (!thisOperand.isDirectlyAssignableType(type3, processingContext)) continue;
                        AssignableResult assignableResult = AssignableResult.STRICTLY_ASSIGNABLE;
                        if (assignableResult == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTypeCastUtil", "isDirectlyAssignableTypeCommon"));
                        }
                        return assignableResult;
                    }
                    if (thisOperand.isEquivalentTo(rOperand, processingContext)) {
                        AssignableResult assignableResult = AssignableResult.STRICTLY_ASSIGNABLE;
                        if (assignableResult == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTypeCastUtil", "isDirectlyAssignableTypeCommon"));
                        }
                        return assignableResult;
                    }
                    JSType substitute = intersectionType.substitute();
                    if (substitute != intersectionType) {
                        AssignableResult assignableResult = JSTypeCastUtil.toStrictAssignable(thisOperand.isDirectlyAssignableType(substitute, processingContext));
                        if (assignableResult == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTypeCastUtil", "isDirectlyAssignableTypeCommon"));
                        }
                        return assignableResult;
                    }
                }
            }
        }
        if ((rOperand instanceof JSIterableComponentTypeImpl || rOperand instanceof TypeScriptGenericThisTypeImpl) && (type = rOperand.substitute()) != rOperand) {
            AssignableResult assignableResult = JSTypeCastUtil.toStrictAssignable(thisOperand.isDirectlyAssignableType(type, processingContext));
            if (assignableResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTypeCastUtil", "isDirectlyAssignableTypeCommon"));
            }
            return assignableResult;
        }
        AssignableResult assignableResult = thisOperand.isEquivalentTo(rOperand, processingContext) ? AssignableResult.STRICTLY_ASSIGNABLE : AssignableResult.POSSIBLY_NOT_ASSIGNABLE;
        if (assignableResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTypeCastUtil", "isDirectlyAssignableTypeCommon"));
        }
        return assignableResult;
    }

    private static AssignableResult toStrictAssignable(boolean value) {
        return value ? AssignableResult.STRICTLY_ASSIGNABLE : AssignableResult.STRICTLY_NOT_ASSIGNABLE;
    }

    @Nullable
    public static JSRecordType buildWithAppliedGenericArguments(@NotNull JSClass jsClass, @NotNull JSGenericTypeImpl type) {
        TypeScriptTypeParameterListOwner owner;
        if (jsClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsClass", "com/intellij/lang/javascript/psi/types/JSTypeCastUtil", "buildWithAppliedGenericArguments"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/types/JSTypeCastUtil", "buildWithAppliedGenericArguments"));
        }
        if (jsClass instanceof TypeScriptTypeParameterListOwner && ((owner = (TypeScriptTypeParameterListOwner)jsClass).getTypeParameterList() != null || type.getOuterArguments() != null)) {
            Map<String, JSType> genericArgumentsMap = JSTypeCastUtil.collectGenericsFroApplying(type, owner);
            JSType baseType = type.getType();
            boolean isStatic = baseType instanceof JSNamedType && ((JSNamedType)baseType).isStaticOrInstance() == JSContext.STATIC;
            return (JSRecordType)JSTypeUtils.applyGenericArguments((JSType)TypeScriptTypeParser.buildTypeFromClass(jsClass, isStatic), genericArgumentsMap);
        }
        return null;
    }

    @NotNull
    public static Map<String, JSType> collectGenericsFroApplying(@NotNull JSGenericTypeImpl type, @NotNull TypeScriptTypeParameterListOwner listOwner) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/types/JSTypeCastUtil", "collectGenericsFroApplying"));
        }
        if (listOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listOwner", "com/intellij/lang/javascript/psi/types/JSTypeCastUtil", "collectGenericsFroApplying"));
        }
        TypeScriptTypeParameterList typeParameterList = listOwner.getTypeParameterList();
        THashMap genericArgumentsMap = new THashMap();
        if (typeParameterList != null) {
            TypeScriptTypeParameter[] typeParameters = typeParameterList.getTypeParameters();
            List<JSType> arguments = type.getArguments();
            for (int i = 0; i < typeParameters.length; ++i) {
                JSType argumentType;
                JSType jSType = argumentType = i < arguments.size() ? arguments.get(i) : null;
                if (argumentType == null) continue;
                genericArgumentsMap.put(typeParameters[i].getName(), argumentType);
            }
        }
        THashMap tHashMap = genericArgumentsMap;
        if (tHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTypeCastUtil", "collectGenericsFroApplying"));
        }
        return tHashMap;
    }

    public static boolean isEquivalentCommon(JSType thisOperand, JSType rOperand, @Nullable ProcessingContext processingContext) {
        if (rOperand == null || thisOperand == null) {
            return false;
        }
        if (rOperand instanceof JSGenericParameterImpl) {
            return rOperand.isEquivalentTo(thisOperand, processingContext);
        }
        if (rOperand instanceof JSTypeofTypeImpl) {
            return rOperand.isEquivalentTo(thisOperand, processingContext);
        }
        return false;
    }

    public static enum AssignableResult {
        STRICTLY_ASSIGNABLE(true, true),
        STRICTLY_NOT_ASSIGNABLE(true, false),
        POSSIBLY_ASSIGNABLE(false, true),
        POSSIBLY_NOT_ASSIGNABLE(false, false);

        private final boolean myStrict;
        private final boolean myAssignable;

        private AssignableResult(boolean strict, boolean assignable) {
            this.myStrict = strict;
            this.myAssignable = assignable;
        }

        public boolean isAssignable() {
            return this.myAssignable;
        }

        public boolean isStrict() {
            return this.myStrict;
        }
    }
}

