/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.util;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.psi.JSDestructuringContainer;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSDestructuringUtil {
    @Nullable
    public static PsiElement getParentSkippingDestructuring(@NotNull JSVariable var) {
        if (var == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "var", "com/intellij/lang/javascript/psi/util/JSDestructuringUtil", "getParentSkippingDestructuring"));
        }
        PsiElement parent = var.getParent();
        while (parent instanceof JSDestructuringContainer || parent instanceof JSDestructuringProperty) {
            parent = parent.getParent();
        }
        return parent;
    }

    @Nullable
    public static ASTNode getParentSkippingDestructuring(@NotNull ASTNode varNode) {
        if (varNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "varNode", "com/intellij/lang/javascript/psi/util/JSDestructuringUtil", "getParentSkippingDestructuring"));
        }
        ASTNode parent = varNode.getTreeParent();
        while (JSElementTypes.DESTRUCTURING_CONTAINERS.contains(parent.getElementType()) || parent.getElementType() == JSStubElementTypes.DESTRUCTURING_PROPERTY) {
            if ((parent = parent.getTreeParent()) != null) continue;
            return null;
        }
        return parent;
    }
}

