/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JSDefaultRenameProcessor
extends RenamePsiElementProcessor {
    public static final String SEARCH_IN_COMMENTS = "js.rename.search.in.comments";
    public static final String SEARCH_FOR_TEXT_OCCURRENCES = "js.rename.search.for.text.occurrences";

    public boolean canProcessElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/refactoring/JSDefaultRenameProcessor", "canProcessElement"));
        }
        return element instanceof JSNamedElement;
    }

    @NotNull
    public Collection<PsiReference> findReferences(PsiElement element, boolean searchInCommentsAndStrings) {
        Collection<PsiReference> collection = JSDefaultRenameProcessor.getReferences(element, searchInCommentsAndStrings, ReferencesType.ALL);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/refactoring/JSDefaultRenameProcessor", "findReferences"));
        }
        return collection;
    }

    @NotNull
    public static Collection<PsiReference> getReferences(PsiElement element, boolean searchInCommentsAndStrings, ReferencesType type) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Object defaultScope = GlobalSearchScope.allScope((Project)element.getProject());
        boolean useJS = true;
        switch (type) {
            case TS: {
                useJS = false;
            }
            case JS: {
                final boolean finalUseJS = useJS;
                defaultScope = new DelegatingGlobalSearchScope((GlobalSearchScope)defaultScope){

                    public boolean contains(@NotNull VirtualFile file) {
                        if (file == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/refactoring/JSDefaultRenameProcessor$1", "contains"));
                        }
                        if (!super.contains(file)) {
                            return false;
                        }
                        return finalUseJS == DialectDetector.JAVASCRIPT_FILE_TYPES.contains(file.getFileType());
                    }
                };
                break;
            }
        }
        Collection<PsiReference> collection = JSDefaultRenameProcessor.findReferencesForScope(element, searchInCommentsAndStrings, defaultScope);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/refactoring/JSDefaultRenameProcessor", "getReferences"));
        }
        return collection;
    }

    public static Collection<PsiReference> findReferencesForScope(final PsiElement element, final boolean searchInCommentsAndStrings, GlobalSearchScope useScope) {
        DialectOptionHolder holder = DialectDetector.dialectOfElement(element);
        final boolean hasES6Imports = holder != null && (holder.isTypeScript || holder.isECMA6);
        List<PsiReference> result = Collections.synchronizedList(new ArrayList());
        ReferencesSearch.search((PsiElement)element, (SearchScope)useScope).forEach((Processor)new CommonProcessors.CollectProcessor<PsiReference>(result){

            protected boolean accept(PsiReference psiReference) {
                return JSDefaultRenameProcessor.acceptReference(psiReference, searchInCommentsAndStrings, hasES6Imports, element);
            }
        });
        return result;
    }

    public static boolean acceptReference(PsiReference psiReference, boolean searchInCommentsAndStrings, boolean hasES6Imports, PsiElement element) {
        Object[] results;
        boolean accept;
        boolean bl = accept = searchInCommentsAndStrings || JSDefaultRenameProcessor.isStrictlyRenameableReference(psiReference);
        if (!accept) {
            return false;
        }
        if (!hasES6Imports) {
            return true;
        }
        PsiElement elementToRename = psiReference.getElement();
        if (elementToRename instanceof JSReferenceExpression && ((JSReferenceExpression)elementToRename).getQualifier() == null && (results = ((JSReferenceExpression)elementToRename).multiResolve(false)).length == 1) {
            PsiElement item = ((ResolveResult)ArrayUtil.getFirstElement((Object[])results)).getElement();
            if (element.isEquivalentTo(item)) {
                return true;
            }
            if (ES6PsiUtil.isImportElement(item)) {
                return false;
            }
        }
        return true;
    }

    public static boolean isStrictlyRenameableReference(PsiReference psiReference) {
        PsiElement element = psiReference.getElement();
        boolean reallyWeak = psiReference.isSoft() && element instanceof JSLiteralExpression && !(element.getParent() instanceof JSIndexedPropertyAccessExpression);
        return !reallyWeak;
    }

    public boolean isToSearchInComments(PsiElement element) {
        return PropertiesComponent.getInstance().getBoolean(SEARCH_IN_COMMENTS, true);
    }

    public void setToSearchInComments(PsiElement element, boolean enabled) {
        PropertiesComponent.getInstance().setValue(SEARCH_IN_COMMENTS, String.valueOf(enabled));
        super.setToSearchInComments(element, enabled);
    }

    public boolean isToSearchForTextOccurrences(PsiElement element) {
        return PropertiesComponent.getInstance().getBoolean(SEARCH_FOR_TEXT_OCCURRENCES);
    }

    public void setToSearchForTextOccurrences(PsiElement element, boolean enabled) {
        PropertiesComponent.getInstance().setValue(SEARCH_FOR_TEXT_OCCURRENCES, String.valueOf(enabled));
        super.setToSearchForTextOccurrences(element, enabled);
    }

    public static enum ReferencesType {
        ALL,
        TS,
        JS;

    }
}

