/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring;

import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.ImplicitJSVariableImpl;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.refactoring.JSDefaultRenameProcessor;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.ui.UIUtil;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSPropertyFunctionRenameProcessor
extends JSDefaultRenameProcessor {
    @Override
    public boolean canProcessElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/refactoring/JSPropertyFunctionRenameProcessor", "canProcessElement"));
        }
        return element instanceof JSVariable || element instanceof JSFunction && (((JSFunction)element).isGetProperty() || ((JSFunction)element).isSetProperty());
    }

    public void prepareRenaming(PsiElement element, final String newName, final Map<PsiElement, String> allRenames) {
        PsiElement parent;
        if (element instanceof JSFunction) {
            PsiElement parent2;
            JSFunction function = (JSFunction)element;
            JSFunction.FunctionKind toFind = null;
            if (function.isGetProperty()) {
                toFind = JSFunction.FunctionKind.SETTER;
            } else if (function.isSetProperty()) {
                toFind = JSFunction.FunctionKind.GETTER;
            }
            if (toFind != null && (parent2 = JSResolveUtil.findParent(element)) instanceof JSClass) {
                JSVariable variable;
                Project project;
                String expectedFieldName;
                String funName = function.getName();
                JSFunction oppositePropertyFunction = ((JSClass)parent2).findFunctionByNameAndKind(funName, toFind);
                if (oppositePropertyFunction != null) {
                    allRenames.put((PsiElement)oppositePropertyFunction, newName);
                }
                if (!(expectedFieldName = JSRefactoringUtil.transformAccessorNameToPropertyName(funName, project = element.getProject())).equals(funName) && (variable = ((JSClass)parent2).findFieldByName(expectedFieldName)) != null) {
                    allRenames.put((PsiElement)variable, JSRefactoringUtil.transformAccessorNameToPropertyName(newName, project));
                }
            }
        } else if (element instanceof JSVariable && (parent = JSResolveUtil.findParent(element)) instanceof JSClass) {
            Project project;
            final String name = ((JSVariable)element).getName();
            String expectedPropertyName = JSRefactoringUtil.transformVarNameToAccessorName(name, project = element.getProject());
            if (!expectedPropertyName.equals(name)) {
                JSFunction getter = ((JSClass)parent).findFunctionByNameAndKind(expectedPropertyName, JSFunction.FunctionKind.GETTER);
                JSFunction setter = ((JSClass)parent).findFunctionByNameAndKind(expectedPropertyName, JSFunction.FunctionKind.SETTER);
                String accessorNewName = JSRefactoringUtil.transformVarNameToAccessorName(newName, project);
                if (!(getter == null && setter == null || ApplicationManager.getApplication().isUnitTestMode() || Messages.showYesNoDialog((String)JSBundle.message((String)"rename.accessors.dialog.text", (Object[])new Object[]{accessorNewName}), (String)JSBundle.message((String)"rename.accessors.dialog.title", (Object[])new Object[0]), (Icon)UIUtil.getQuestionIcon()) == 0)) {
                    getter = null;
                    setter = null;
                }
                if (getter != null) {
                    allRenames.put((PsiElement)getter, accessorNewName);
                }
                if (setter != null) {
                    allRenames.put((PsiElement)setter, accessorNewName);
                }
            }
            JSResolveUtil.processHierarchy((JSClass)parent, new Processor<JSClass>(){

                public boolean process(JSClass aClass) {
                    JSFunction setter;
                    if (!aClass.isInterface()) {
                        return true;
                    }
                    JSFunction getter = aClass.findFunctionByNameAndKind(name, JSFunction.FunctionKind.GETTER);
                    if (getter != null) {
                        allRenames.put(getter, newName);
                    }
                    if ((setter = aClass.findFunctionByNameAndKind(name, JSFunction.FunctionKind.SETTER)) != null) {
                        allRenames.put(setter, newName);
                    }
                    return true;
                }
            }, true);
        }
    }

    public static boolean isFieldWithAccessors(PsiElement element) {
        if (!(element instanceof JSVariable)) {
            return false;
        }
        String name = ((JSVariable)element).getName();
        PsiElement parent = JSResolveUtil.findParent(element);
        if (!(parent instanceof JSClass)) {
            return false;
        }
        JSClass jsClass = (JSClass)parent;
        String accessorName = JSRefactoringUtil.transformVarNameToAccessorName(name, element.getProject());
        return jsClass.findFunctionByNameAndKind(accessorName, JSFunction.FunctionKind.GETTER) != null || jsClass.findFunctionByNameAndKind(accessorName, JSFunction.FunctionKind.SETTER) != null;
    }

    public PsiElement substituteElementToRename(PsiElement element, @Nullable Editor editor) {
        if (element instanceof ImplicitJSVariableImpl) {
            return null;
        }
        return super.substituteElementToRename(element, editor);
    }

    public void renameElement(PsiElement element, String newName, UsageInfo[] usages, @Nullable RefactoringElementListener listener) throws IncorrectOperationException {
        if (element instanceof ImplicitJSVariableImpl) {
            return;
        }
        super.renameElement(element, newName, usages, listener);
    }
}

