/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.memberPushDown;

import com.intellij.lang.javascript.flex.ImportUtils;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClassFactory;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.lang.javascript.refactoring.JSChangeVisibilityUtil;
import com.intellij.lang.javascript.refactoring.JSVisibilityUtil;
import com.intellij.lang.javascript.refactoring.memberPushDown.JSPushDownConflictsUtil;
import com.intellij.lang.javascript.refactoring.memberPushDown.JSPushDownHandler;
import com.intellij.lang.javascript.refactoring.memberPushDown.JSPushDownUsageViewDescriptor;
import com.intellij.lang.javascript.refactoring.util.JSMemberInfo;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;

public class JSPushDownProcessor
extends BaseRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance((String)JSPushDownProcessor.class.getName());
    private final JSMemberInfo[] myMemberInfos;
    private JSClass mySourceClass;
    private final int myDocCommentPolicy;

    public JSPushDownProcessor(Project project, JSMemberInfo[] memberInfos, JSClass aSourceClass, int docCommentPolicy) {
        super(project);
        this.myMemberInfos = memberInfos;
        this.mySourceClass = aSourceClass;
        this.myDocCommentPolicy = docCommentPolicy;
    }

    protected String getCommandName() {
        return JSPushDownHandler.REFACTORING_NAME;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/lang/javascript/refactoring/memberPushDown/JSPushDownProcessor", "createUsageViewDescriptor"));
        }
        JSPushDownUsageViewDescriptor jSPushDownUsageViewDescriptor = new JSPushDownUsageViewDescriptor(this.mySourceClass);
        if (jSPushDownUsageViewDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/refactoring/memberPushDown/JSPushDownProcessor", "createUsageViewDescriptor"));
        }
        return jSPushDownUsageViewDescriptor;
    }

    @NotNull
    protected UsageInfo[] findUsages() {
        Collection<JSClass> subclasses = JSInheritanceUtil.findDirectSubClasses(this.mySourceClass, false);
        JSClass[] inheritors = subclasses.toArray(new JSClass[subclasses.size()]);
        UsageInfo[] usages = new UsageInfo[inheritors.length];
        for (int i = 0; i < inheritors.length; ++i) {
            usages[i] = new UsageInfo((PsiElement)inheritors[i]){

                public PsiElement getElement() {
                    PsiElement element = super.getElement();
                    if (element instanceof XmlTag) {
                        element = XmlBackedJSClassFactory.getInstance().getXmlBackedClass((XmlTag)element);
                    }
                    return element;
                }
            };
        }
        if (usages == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/refactoring/memberPushDown/JSPushDownProcessor", "findUsages"));
        }
        return usages;
    }

    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        if (refUsages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refUsages", "com/intellij/lang/javascript/refactoring/memberPushDown/JSPushDownProcessor", "preprocessUsages"));
        }
        UsageInfo[] usagesIn = (UsageInfo[])refUsages.get();
        ArrayList<JSClass> targetClasses = new ArrayList<JSClass>(usagesIn.length);
        for (UsageInfo usage : usagesIn) {
            targetClasses.add((JSClass)usage.getElement());
        }
        MultiMap<PsiElement, String> conflicts = JSPushDownConflictsUtil.checkConflicts(this.mySourceClass, this.myMemberInfos, targetClasses, JSVisibilityUtil.DEFAULT_OPTIONS);
        return this.showConflicts(conflicts, usagesIn);
    }

    protected void refreshElements(@NotNull PsiElement[] elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/lang/javascript/refactoring/memberPushDown/JSPushDownProcessor", "refreshElements"));
        }
        LOG.assertTrue(elements.length == 1 && elements[0] instanceof JSClass, (Object)elements);
        this.mySourceClass = (JSClass)elements[0];
    }

    protected void performRefactoring(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/lang/javascript/refactoring/memberPushDown/JSPushDownProcessor", "performRefactoring"));
        }
        try {
            JSClass firstTargetClass = (JSClass)usages[0].getElement();
            Collection<PsiFile> filesWithUsages = JSRefactoringUtil.qualifyIncomingReferences(JSRefactoringUtil.getUsages(JSMemberInfo.getStatics(this.myMemberInfos), firstTargetClass));
            ArrayList<FormatFixer> postponedFormatters = new ArrayList<FormatFixer>();
            final HashMap<PsiElement, Boolean> movedMembers = new HashMap<PsiElement, Boolean>(this.myMemberInfos.length);
            for (JSMemberInfo jSMemberInfo : this.myMemberInfos) {
                movedMembers.put(jSMemberInfo.getMember(), jSMemberInfo.isToAbstract());
            }
            for (int i = 0; i < usages.length; ++i) {
                UsageInfo usage = usages[i];
                JSClass targetClass = (JSClass)usage.getElement();
                for (JSMemberInfo info : this.myMemberInfos) {
                    JSAttributeListOwner newMember;
                    ArrayList<String> namespacesInTargetFile;
                    ArrayList<String> importsInTargetFile;
                    JSAttributeListOwner member = (JSAttributeListOwner)info.getMember();
                    if (member instanceof JSFunction) {
                        importsInTargetFile = new ArrayList<String>();
                        namespacesInTargetFile = new ArrayList<String>();
                        JSRefactoringUtil.fixOutgoingReferences((PsiElement)member, importsInTargetFile, namespacesInTargetFile, movedMembers.keySet(), targetClass, true, false);
                        ImportUtils.insertImportStatements((PsiElement)targetClass, importsInTargetFile);
                        JSFunction method = (JSFunction)member;
                        if (this.mySourceClass.isInterface() && !targetClass.isInterface()) {
                            PsiElement docComment;
                            newMember = (JSAttributeListOwner)targetClass.add((PsiElement)JSRefactoringUtil.buildImplementationMethod(method, targetClass));
                            if ((this.myDocCommentPolicy == 2 || this.myDocCommentPolicy == 1) && (docComment = JSRefactoringUtil.findDocComment((PsiElement)method)) != null) {
                                targetClass.addBefore(docComment.copy(), (PsiElement)newMember);
                            }
                            JSChangeVisibilityUtil.setVisibility(newMember, JSAttributeList.AccessType.PUBLIC);
                        } else {
                            newMember = (JSAttributeListOwner)JSRefactoringUtil.addMemberToTargetClass(targetClass, method.copy());
                            JSRefactoringUtil.handleDocCommentAndFormat((PsiElement)newMember, postponedFormatters);
                        }
                    } else if (member instanceof JSVariable) {
                        importsInTargetFile = new ArrayList();
                        namespacesInTargetFile = new ArrayList();
                        JSRefactoringUtil.fixOutgoingReferences((PsiElement)member, importsInTargetFile, namespacesInTargetFile, movedMembers.keySet(), targetClass, true, false);
                        postponedFormatters.addAll(JSRefactoringUtil.addUseNamespaceDirectives((JSQualifiedNamedElement)targetClass, namespacesInTargetFile));
                        ImportUtils.insertImportStatements((PsiElement)targetClass, importsInTargetFile);
                        PsiElement varStatementCopy = JSRefactoringUtil.addMemberToTargetClass(targetClass, (PsiElement)JSRefactoringUtil.getVarStatementCopy((JSVariable)member));
                        JSRefactoringUtil.handleDocCommentAndFormat(varStatementCopy, postponedFormatters);
                        newMember = (JSAttributeListOwner)PsiTreeUtil.getChildOfType((PsiElement)varStatementCopy, JSVariable.class);
                    } else {
                        JSClass aClass = (JSClass)member;
                        LOG.assertTrue(Boolean.FALSE.equals(info.getOverrides()));
                        JSRefactoringUtil.addToSupersList(targetClass, aClass.getQualifiedName(), true);
                        newMember = null;
                    }
                    if (newMember == null) continue;
                    JSRefactoringUtil.fixOutgoingReferences((PsiElement)newMember, new ArrayList<String>(), new ArrayList<String>(), movedMembers.keySet(), targetClass, false, false);
                }
                JSRefactoringUtil.postProcess((PsiElement)(i == 0 ? this.mySourceClass : null), (JSQualifiedNamedElement)targetClass, i == 0 ? filesWithUsages : Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), postponedFormatters, false, true);
            }
            JSRefactoringUtil.addRemovalFormatters(this.mySourceClass, movedMembers.keySet(), new Condition<JSFunction>(){

                public boolean value(JSFunction function) {
                    Boolean isToAbstract = (Boolean)movedMembers.get(function);
                    return isToAbstract.booleanValue() ? JSPushDownProcessor.this.myDocCommentPolicy == 1 : true;
                }
            }, (Condition<JSVariable>)Conditions.alwaysTrue(), postponedFormatters);
            for (JSMemberInfo jSMemberInfo : this.myMemberInfos) {
                JSAttributeListOwner toDelete;
                PsiElement docComment;
                JSAttributeListOwner member = (JSAttributeListOwner)jSMemberInfo.getMember();
                if (member instanceof JSFunction) {
                    if (jSMemberInfo.isToAbstract()) {
                        if (this.myDocCommentPolicy == 1 && (docComment = JSRefactoringUtil.findDocComment((PsiElement)member)) != null) {
                            JSRefactoringUtil.deleteWithNoPostponedFormatting(docComment);
                        }
                        toDelete = null;
                    } else {
                        docComment = JSRefactoringUtil.findDocComment((PsiElement)member);
                        if (docComment != null) {
                            JSRefactoringUtil.deleteWithNoPostponedFormatting(docComment);
                        }
                        toDelete = member;
                    }
                } else if (member instanceof JSVariable) {
                    docComment = JSRefactoringUtil.findDocComment((PsiElement)member);
                    if (docComment != null) {
                        JSRefactoringUtil.deleteWithNoPostponedFormatting(docComment);
                    }
                    toDelete = member;
                } else {
                    JSReferenceList refList = jSMemberInfo.isExtendsNotImplements() ? this.mySourceClass.getExtendsList() : this.mySourceClass.getImplementsList();
                    JSRefactoringUtil.removeFromReferenceList(refList, (JSClass)member, postponedFormatters);
                    toDelete = null;
                }
                if (toDelete == null) continue;
                JSRefactoringUtil.deleteWithNoPostponedFormatting((PsiElement)toDelete);
            }
            JSRefactoringUtil.format(postponedFormatters);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }
}

