/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.template.postfix;

import com.intellij.codeInsight.template.postfix.templates.PostfixTemplateWithExpressionSelector;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.refactoring.introduceVariable.InplaceSettings;
import com.intellij.lang.javascript.refactoring.introduceVariable.JSIntroduceVariableHandler;
import com.intellij.lang.javascript.refactoring.introduceVariable.Settings;
import com.intellij.lang.javascript.template.postfix.JSPostfixTemplateUtils;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.introduce.inplace.OccurrencesChooser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSIntroduceVariablePostfixTemplate
extends PostfixTemplateWithExpressionSelector {
    public JSIntroduceVariablePostfixTemplate() {
        super("var", "var name = expr", JSPostfixTemplateUtils.selectorAllExpressionsWithCurrentOffset());
    }

    protected void expandForChooseExpression(@NotNull PsiElement context, @NotNull Editor editor) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/template/postfix/JSIntroduceVariablePostfixTemplate", "expandForChooseExpression"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/lang/javascript/template/postfix/JSIntroduceVariablePostfixTemplate", "expandForChooseExpression"));
        }
        JSIntroduceVariableHandler handler = JSIntroduceVariablePostfixTemplate.getHandler();
        editor.getSelectionModel().setSelection(context.getTextRange().getStartOffset(), context.getTextRange().getEndOffset());
        handler.invoke(context.getProject(), editor, context.getContainingFile(), null);
    }

    private static JSIntroduceVariableHandler getHandler() {
        return ApplicationManager.getApplication().isUnitTestMode() ? JSIntroduceVariablePostfixTemplate.getMockHandler() : new JSIntroduceVariableHandler();
    }

    private static JSIntroduceVariableHandler getMockHandler() {
        return new JSIntroduceVariableHandler(){

            @Override
            @Nullable
            protected Settings getSettings(Project project, Editor editor, Pair<JSExpression, TextRange> expressionDescriptor, JSExpression[] occurrences, PsiElement scope) {
                return JSIntroduceVariablePostfixTemplate.getMockSettings();
            }

            @Override
            protected InplaceSettings<Settings> getInplaceSettings(Pair<JSExpression, TextRange> expr, JSExpression[] occurrences, PsiElement scope, OccurrencesChooser.ReplaceChoice choice) {
                final InplaceSettings<Settings> settings = super.getInplaceSettings(expr, occurrences, scope, choice);
                return new InplaceSettings<Settings>(){

                    @Override
                    public String[] getSuggestedNames() {
                        return settings.getSuggestedNames();
                    }

                    @Override
                    public Settings getSettings() {
                        return JSIntroduceVariablePostfixTemplate.getMockSettings();
                    }
                };
            }
        };
    }

    private static Settings getMockSettings() {
        return new Settings(){

            @Override
            public Settings.IntroducedVarType getIntroducedVarType() {
                return Settings.IntroducedVarType.VAR;
            }

            @Override
            public boolean isReplaceAllOccurrences() {
                return true;
            }

            @Override
            public String getVariableName() {
                return "foo";
            }

            @Override
            public String getVariableType() {
                return null;
            }
        };
    }
}

