/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.types;

import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.util.Processor;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeFromUsageDetector {
    @Nullable
    public static JSType detectTypeFromUsage(final PsiElement parent, final PsiFile containingFile) {
        JSSourceElement[] body;
        if (parent instanceof JSVariable) {
            JSExpression expression = ((JSVariable)parent).getInitializer();
            if (expression != null) {
                JSType type = JSResolveUtil.getExpressionJSType(expression);
                return type;
            }
        } else if (parent instanceof JSFunction && (body = ((JSFunction)parent).getBody()).length > 0) {
            Object type;
            THashSet usedTypes = new THashSet(4, (TObjectHashingStrategy)new TObjectHashingStrategy<JSType>(){

                public int computeHashCode(JSType object) {
                    return object.getTypeText(JSType.TypeTextFormat.SIMPLE).hashCode();
                }

                public boolean equals(JSType o1, JSType o2) {
                    return o1.getTypeText(JSType.TypeTextFormat.SIMPLE).equals(o2.getTypeText(JSType.TypeTextFormat.SIMPLE));
                }
            });
            ArrayList<JSClass> classesList = new ArrayList<JSClass>();
            Ref hasUnresolvedTypes = new Ref();
            Ref hasValuelessReturns = new Ref();
            body[0].acceptChildren((PsiElementVisitor)new JSRecursiveElementVisitor((Set)usedTypes, classesList, hasUnresolvedTypes, hasValuelessReturns){
                final /* synthetic */ Set val$usedTypes;
                final /* synthetic */ List val$classesList;
                final /* synthetic */ Ref val$hasUnresolvedTypes;
                final /* synthetic */ Ref val$hasValuelessReturns;
                {
                    this.val$usedTypes = set;
                    this.val$classesList = list;
                    this.val$hasUnresolvedTypes = ref;
                    this.val$hasValuelessReturns = ref2;
                }

                public void visitJSReturnStatement(JSReturnStatement node) {
                    super.visitJSReturnStatement(node);
                    JSExpression expression = node.getExpression();
                    if (expression != null) {
                        JSType jsType = JSTypeEvaluator.forceEvaluateType(parent, expression, containingFile);
                        if (jsType == null || !this.val$usedTypes.add(jsType)) {
                            return;
                        }
                        PsiElement psiElement = JSResolveUtil.findType(jsType.getTypeText(), parent, true);
                        if (psiElement instanceof JSClass) {
                            this.val$classesList.add((JSClass)psiElement);
                        } else {
                            this.val$hasUnresolvedTypes.set((Object)true);
                        }
                    } else {
                        this.val$hasValuelessReturns.set((Object)true);
                    }
                }

                public void visitJSFunctionExpression(JSFunctionExpression node) {
                }

                public void visitJSFunctionDeclaration(JSFunction node) {
                }
            });
            if (classesList.isEmpty() && hasUnresolvedTypes.get() == null) {
                JSTypeSource source = JSTypeSourceFactory.createTypeSource(parent);
                type = JSNamedType.createType("void", source, JSTypeContext.INSTANCE);
            } else {
                type = !classesList.isEmpty() && hasUnresolvedTypes.get() == null && hasValuelessReturns.get() == null ? TypeFromUsageDetector.calcCommonType(classesList) : (hasUnresolvedTypes.get() != null && usedTypes.size() == 1 ? (JSType)usedTypes.iterator().next() : JSAnyType.get(parent, false));
            }
            return type;
        }
        return null;
    }

    @NotNull
    public static JSType calcCommonType(List<JSClass> aClasses) {
        JSClass aClass;
        if (aClasses.size() == 0) {
            JSAnyType jSAnyType = JSAnyType.get(null, false);
            if (jSAnyType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/types/TypeFromUsageDetector", "calcCommonType"));
            }
            return jSAnyType;
        }
        Ref classRef = new Ref((Object)aClasses.get(0));
        THashSet descendantClasses = new THashSet();
        TypeFromUsageDetector.processNontrivialAncestors(aClasses.get(0), new Processor<JSClass>((Set)descendantClasses){
            final /* synthetic */ Set val$descendantClasses;
            {
                this.val$descendantClasses = set;
            }

            public boolean process(JSClass jsClass) {
                this.val$descendantClasses.add(jsClass.getQualifiedName());
                return true;
            }
        }, (Set<JSClass>)new THashSet());
        for (JSClass clazz : aClasses.subList(1, aClasses.size())) {
            THashSet visitedClasses;
            boolean res;
            if (((JSClass)classRef.get()).equals(clazz) || !(res = TypeFromUsageDetector.processNontrivialAncestors(clazz, new Processor<JSClass>((Set)descendantClasses, classRef){
                final /* synthetic */ Set val$descendantClasses;
                final /* synthetic */ Ref val$classRef;
                {
                    this.val$descendantClasses = set;
                    this.val$classRef = ref;
                }

                public boolean process(JSClass jsClass) {
                    String qName = jsClass.getQualifiedName();
                    if (this.val$descendantClasses.contains(qName)) {
                        this.val$classRef.set((Object)jsClass);
                        return false;
                    }
                    return true;
                }
            }, (Set<JSClass>)(visitedClasses = new THashSet())))) continue;
            classRef.set(null);
            break;
        }
        String qualifiedName = (aClass = (JSClass)classRef.get()) != null ? aClass.getQualifiedName() : null;
        JSAnyType jSAnyType = qualifiedName == null ? JSAnyType.get((PsiElement)aClasses.get(0), false) : JSNamedType.createType(qualifiedName, JSTypeSourceFactory.createTypeSource((PsiElement)aClasses.get(0), true), JSTypeContext.INSTANCE);
        if (jSAnyType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/types/TypeFromUsageDetector", "calcCommonType"));
        }
        return jSAnyType;
    }

    private static boolean processNontrivialAncestors(JSClass aClass, Processor<JSClass> processor, Set<JSClass> visited) {
        if (!visited.add(aClass)) {
            return false;
        }
        if (!processor.process((Object)aClass)) {
            return false;
        }
        for (JSClass superClazz : aClass.getSupers()) {
            if ("Object".equals(superClazz.getQualifiedName())) break;
            if (!processor.process((Object)superClazz)) {
                return false;
            }
            if (TypeFromUsageDetector.processNontrivialAncestors(superClazz, processor, visited)) continue;
            return false;
        }
        for (JSClass superClazz : aClass.getImplementedInterfaces()) {
            if ("Object".equals(superClazz.getQualifiedName())) break;
            visited.add(superClazz);
            if (!processor.process((Object)superClazz)) {
                return false;
            }
            if (TypeFromUsageDetector.processNontrivialAncestors(superClazz, processor, visited)) continue;
            return false;
        }
        return true;
    }
}

