/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ui.newclass;

import com.intellij.ide.wizard.AbstractWizardStepEx;
import com.intellij.ide.wizard.CommitStepException;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.ui.newclass.MainStep;
import com.intellij.lang.javascript.ui.newclass.WizardModel;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.TableUtil;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.TableView;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomVariablesStep
extends AbstractWizardStepEx {
    static final Object ID = new Object();
    private final WizardModel myModel;
    private TableView<Item> myTable;
    private JPanel myPanel;
    private JLabel myTitleLabel;
    private static ColumnInfo<Item, String> NAME = new ColumnInfo<Item, String>(JSBundle.message((String)"varible.name.column.title", (Object[])new Object[0])){

        @Nullable
        public String valueOf(Item item) {
            return item.name;
        }
    };
    private static ColumnInfo<Item, String> VALUE = new ColumnInfo<Item, String>(JSBundle.message((String)"varible.value.column.title", (Object[])new Object[0])){

        @Nullable
        public String valueOf(Item item) {
            return item.value;
        }

        public boolean isCellEditable(Item item) {
            return true;
        }

        public void setValue(Item item, String value) {
            item.value = value;
        }
    };

    public CustomVariablesStep(WizardModel model) {
        super(null);
        this.myModel = model;
        this.$$$setupUI$$$();
        this.myTable.setPreferredScrollableViewportSize(new Dimension(100, this.myTable.getRowHeight() * 3));
    }

    @NotNull
    public Object getStepId() {
        Object object = ID;
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ui/newclass/CustomVariablesStep", "getStepId"));
        }
        return object;
    }

    @Nullable
    public Object getNextStepId() {
        return null;
    }

    @Nullable
    public Object getPreviousStepId() {
        return MainStep.ID;
    }

    public boolean isComplete() {
        return true;
    }

    public void _init() {
        String text = JSBundle.message((String)"custom.variables.step.title.label.text", (Object[])new Object[]{this.myModel.getTemplateName()});
        this.myTitleLabel.setText(UIUtil.removeMnemonic((String)text));
        this.myTitleLabel.setDisplayedMnemonic(text.charAt(UIUtil.getDisplayMnemonicIndex((String)text) + 1));
        ListTableModel model = new ListTableModel(new ColumnInfo[]{NAME, VALUE});
        List items = ContainerUtil.map(this.myModel.getCustomTemplateAttributes(this.myModel.getTemplateName()).entrySet(), (Function)new Function<Map.Entry<String, String>, Item>(){

            public Item fun(Map.Entry<String, String> e) {
                return new Item(e.getKey(), e.getValue());
            }
        });
        ContainerUtil.sort((List)items, (Comparator)new Comparator<Item>(){

            @Override
            public int compare(Item o1, Item o2) {
                return StringUtil.naturalCompare((String)o1.name, (String)o2.name);
            }
        });
        model.addRows((Collection)items);
        this.myTable.setModelAndUpdateColumns(model);
    }

    public void commit(AbstractWizardStepEx.CommitType commitType) throws CommitStepException {
        TableUtil.stopEditing(this.myTable);
        List items = ((ListTableModel)this.myTable.getModel()).getItems();
        HashMap<String, String> map = new HashMap<String, String>();
        for (Item item : items) {
            map.put(item.name, item.value);
        }
        this.myModel.setCustomTemplateAttributes(this.myModel.getTemplateName(), map);
    }

    public JComponent getComponent() {
        return this.myPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return null;
    }

    public void shown() {
        TableUtil.editCellAt(this.myTable, (int)0, (int)1);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        TableView tableView;
        JLabel jLabel;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myTitleLabel = jLabel = new JLabel();
        jLabel.setText("Custom template variables:");
        jLabel.setDisplayedMnemonic('C');
        jLabel.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myTable = tableView = new TableView();
        jBScrollPane.setViewportView((Component)tableView);
        jLabel.setLabelFor((Component)jBScrollPane);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private static class Item {
        private final String name;
        private String value;

        private Item(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }
}

