/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation;

import com.intellij.codeInsight.daemon.impl.analysis.DefaultHighlightingSettingProvider;
import com.intellij.codeInsight.daemon.impl.analysis.FileHighlightingSetting;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSMinifiedFileUtil;
import com.intellij.lang.javascript.library.JSLibraryManager;
import com.intellij.lang.javascript.psi.resolve.WalkUpResolveProcessor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ThreeState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSDefaultHighlightingSettingProvider
extends DefaultHighlightingSettingProvider {
    @Nullable
    public FileHighlightingSetting getDefaultSetting(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/validation/JSDefaultHighlightingSettingProvider", "getDefaultSetting"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/validation/JSDefaultHighlightingSettingProvider", "getDefaultSetting"));
        }
        if (!DialectDetector.JAVASCRIPT_FILE_TYPES.contains(file.getFileType())) {
            return null;
        }
        if (project.isDefault()) {
            return null;
        }
        if (!file.isValid()) {
            return null;
        }
        if (WalkUpResolveProcessor.isTooBigForHighlighting(file)) {
            return FileHighlightingSetting.SKIP_HIGHLIGHTING;
        }
        ThreeState explicitlyCompact = JSLibraryManager.getInstance(project).getFileState(file);
        if (explicitlyCompact == ThreeState.YES) {
            return FileHighlightingSetting.SKIP_HIGHLIGHTING;
        }
        if (explicitlyCompact == ThreeState.NO) {
            return FileHighlightingSetting.SKIP_INSPECTION;
        }
        if (JSMinifiedFileUtil.isFileContentMinified(file)) {
            return FileHighlightingSetting.SKIP_HIGHLIGHTING;
        }
        return ProjectRootManager.getInstance((Project)project).getFileIndex().isInContent(file) ? null : FileHighlightingSetting.SKIP_HIGHLIGHTING;
    }
}

