/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.Nullable;

public class JSParameterInserter {
    private final ASTNode anchorNode;
    private final JSParameterList parameterList;
    private final JSFunction fun;
    private final int myParameterIndex;
    private String mySemicolon;
    private boolean myOptionalParameter;
    private String myParameterInitializer;
    private Project myProject;
    private JSLanguageDialect myLanguageDialect;
    private boolean myHasRestParameterAfter;
    private boolean myHasOptionalParameterBefore;

    private JSParameterInserter(ASTNode anchorNode, JSParameterList parameterList, JSFunction fun, int parameterIndex, boolean hasRestParameterAfter, boolean hasOptionalParameterBefore) {
        this.anchorNode = anchorNode;
        this.parameterList = parameterList;
        this.myParameterIndex = parameterIndex;
        this.fun = fun;
        this.myProject = fun.getProject();
        this.myLanguageDialect = JSUtils.getDialect(fun.getContainingFile());
        this.myHasRestParameterAfter = hasRestParameterAfter;
        this.myHasOptionalParameterBefore = hasOptionalParameterBefore;
    }

    @Nullable
    public static JSParameterInserter build(PsiElement node) {
        JSFunction fun = (JSFunction)PsiTreeUtil.getNonStrictParentOfType((PsiElement)node, (Class[])new Class[]{JSFunction.class});
        if (fun == null) {
            return null;
        }
        JSParameterList parameterList = fun.getParameterList();
        if (parameterList == null) {
            return null;
        }
        ASTNode anchorNode = parameterList.getNode().findChildByType(JSTokenTypes.LPAR);
        if (anchorNode == null) {
            return null;
        }
        JSParameter[] existingParameters = parameterList.getParameters();
        int index = 0;
        boolean hasRestParameterAfter = false;
        boolean hasOptionalParameterBefore = false;
        for (int i = existingParameters.length - 1; i >= 0; --i) {
            JSParameter existingParameter = existingParameters[i];
            if (!existingParameter.isRest()) {
                anchorNode = existingParameter.getNode();
                index = i + 1;
                hasOptionalParameterBefore = existingParameter.isOptional();
                break;
            }
            hasRestParameterAfter = true;
        }
        return new JSParameterInserter(anchorNode, parameterList, fun, index, hasRestParameterAfter, hasOptionalParameterBefore);
    }

    public JSParameter doInsert(String s, boolean optionalParameter, String parameterInitializer) {
        ASTNode fromText = JSChangeUtil.createJSTreeFromText(this.myProject, "function xxx (x," + s + ",x2) {}", this.myLanguageDialect);
        this.myParameterInitializer = parameterInitializer;
        this.myOptionalParameter = optionalParameter;
        JSParameter parameter = ((JSFunction)fromText.getPsi()).getParameterList().getParameters()[1];
        boolean hasMoreThanParameter = this.parameterList.getParameters().length > 0;
        PsiElement anchor = this.anchorNode.getPsi();
        this.parameterList.addRangeAfter((PsiElement)(hasMoreThanParameter && this.myParameterIndex > 0 ? parameter.getPrevSibling() : parameter), (PsiElement)(hasMoreThanParameter && this.myParameterIndex == 0 ? parameter.getNextSibling() : parameter), anchor);
        return (JSParameter)PsiTreeUtil.getNextSiblingOfType((PsiElement)anchor, JSParameter.class);
    }

    public JSFunction getFunction() {
        return this.fun;
    }

    public void fixCall(JSCallExpression callExpression) {
        JSExpression[] expressions = callExpression.getArguments();
        int effectiveParametersCount = expressions.length - (this.myHasRestParameterAfter ? 1 : 0);
        if (effectiveParametersCount < this.myParameterIndex || effectiveParametersCount == this.myParameterIndex && this.myOptionalParameter && !this.myHasOptionalParameterBefore) {
            return;
        }
        if (this.mySemicolon == null) {
            this.mySemicolon = JSCodeStyleSettings.getSemicolon(callExpression.getContainingFile());
        }
        String s = "";
        if (callExpression instanceof JSNewExpression) {
            s = s + "new ";
        }
        s = s + callExpression.getMethodExpression().getText() + "(";
        int index = 0;
        if (index == this.myParameterIndex) {
            s = s + this.myParameterInitializer;
            s = s + ",";
        }
        for (JSExpression e : expressions) {
            if (index == this.myParameterIndex && index > 0) {
                s = s + this.myParameterInitializer;
                s = s + ",";
            }
            s = s + e.getText();
            s = s + ",";
            ++index;
        }
        if (index == this.myParameterIndex && index > 0) {
            s = s + this.myParameterInitializer;
            s = s + ",";
        }
        s = StringUtil.trimEnd((String)s, (String)",");
        s = s + ")";
        s = s + this.mySemicolon;
        callExpression.replace(JSChangeUtil.createExpressionFromText(this.myProject, s, JSUtils.getDialect(callExpression.getContainingFile())).getPsi());
    }

    public boolean mustBeOptional() {
        return this.myHasOptionalParameterBefore;
    }
}

