/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.ExternalAnnotator;
import com.intellij.lang.javascript.compiler.JSLanguageCompilerResult;
import com.intellij.lang.javascript.compiler.JSLanguageCompilerResultContainer;
import com.intellij.lang.javascript.compiler.JSLanguageExternalCompiler;
import com.intellij.lang.typescript.compiler.TypeScriptCompileInfo;
import com.intellij.lang.typescript.compiler.TypeScriptCompileInfoBuilder;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerConfigUtil;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerService;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptCompilerExternalAnnotator
extends ExternalAnnotator<DataToCompile, List<JSLanguageCompilerResult>> {
    public static final Logger LOGGER = Logger.getInstance((String)"#com.intellij.lang.javascript.compiler.JSLanguageExternalCompilerImpl");

    @Nullable
    public DataToCompile collectInformation(@NotNull PsiFile file, @NotNull Editor editor, boolean hasErrors) {
        GlobalSearchScope scope;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/compiler/TypeScriptCompilerExternalAnnotator", "collectInformation"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/lang/typescript/compiler/TypeScriptCompilerExternalAnnotator", "collectInformation"));
        }
        Project project = file.getProject();
        if (!TypeScriptCompilerSettings.getSettings(project).isDoCompilerAnnotation()) {
            return null;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Start annotation for TypeScript file " + file.getName() + " md:" + virtualFile.getModificationStamp() + " md-doc:" + editor.getDocument().getModificationStamp());
        }
        if (!(scope = TypeScriptCompilerService.getCompileScope(project)).accept(file.getVirtualFile()) || !virtualFile.isInLocalFileSystem() || null != virtualFile.getUserData(JSLanguageExternalCompiler.GENERATED_FILE_MARKER)) {
            return null;
        }
        FileDocumentManager manager = FileDocumentManager.getInstance();
        boolean hasChangedConfig = false;
        for (Document document : manager.getUnsavedDocuments()) {
            VirtualFile docFile = manager.getFile(document);
            if (docFile == null || !TypeScriptCompilerConfigUtil.isConfig(docFile, docFile.getFileType())) continue;
            hasChangedConfig = true;
            break;
        }
        TypeScriptCompileInfo input = TypeScriptCompileInfoBuilder.createCompilerInputWithUnSavedFiles(project, file.getVirtualFile(), true, editor.getDocument().getModificationStamp());
        DataToCompile result = new DataToCompile();
        result.project = project;
        result.info = input;
        result.hasChangedConfigBeforeAnnotating = hasChangedConfig;
        return result;
    }

    @Nullable
    public List<JSLanguageCompilerResult> doAnnotate(DataToCompile data) {
        if (null == data) {
            return null;
        }
        TypeScriptCompileInfo collectedInfo = data.info;
        if (null == collectedInfo) {
            return null;
        }
        Project project = data.project;
        if (data.hasChangedConfigBeforeAnnotating) {
            Application application = ApplicationManager.getApplication();
            application.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    FileDocumentManager.getInstance().saveAllDocuments();
                }
            }, ModalityState.defaultModalityState());
        }
        TypeScriptCompilerService service = TypeScriptCompilerService.getService(project);
        try {
            LOGGER.debug("Compile from annotator");
            Future<JSLanguageCompilerResultContainer> compile = service.compile(collectedInfo);
            return compile == null ? null : compile.get(30L, TimeUnit.SECONDS).getCompiledResults();
        }
        catch (Exception e) {
            LOGGER.debug(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public void apply(@NotNull PsiFile file, List<JSLanguageCompilerResult> annotationResult, @NotNull AnnotationHolder holder) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/compiler/TypeScriptCompilerExternalAnnotator", "apply"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/lang/typescript/compiler/TypeScriptCompilerExternalAnnotator", "apply"));
        }
        if (annotationResult == null) {
            return;
        }
        Document document = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file);
        if (document == null) {
            return;
        }
        for (JSLanguageCompilerResult result : annotationResult) {
            if (StringUtil.isEmpty((String)result.myFileAbsoluteSystemDependPath) || !FileUtil.pathsEqual((String)result.myFileAbsoluteSystemDependPath, (String)file.getVirtualFile().getCanonicalPath())) continue;
            try {
                int lineStartOffset;
                int line = result.myLine;
                if (line < 0 || line > document.getLineCount()) continue;
                int errorStartOffset = lineStartOffset = document.getLineStartOffset(line);
                int lineEndOffset = document.getLineEndOffset(line);
                if ((errorStartOffset += result.myColumn) > lineEndOffset) continue;
                PsiElement element = file.findElementAt(errorStartOffset);
                if (element == null && lineStartOffset < errorStartOffset) {
                    element = file.findElementAt(errorStartOffset - 1);
                }
                if (element == null) continue;
                String message = result.myErrorText;
                if ("error".equals(result.myCategory)) {
                    Annotation annotation = holder.createErrorAnnotation(element, message);
                    if (message == null || !StringUtil.startsWith((CharSequence)message, (CharSequence)"TS2304")) continue;
                    annotation.setHighlightType(ProblemHighlightType.LIKE_UNKNOWN_SYMBOL);
                    continue;
                }
                holder.createWarningAnnotation(element, message);
            }
            catch (Exception e) {
                LOGGER.debug(e.getMessage(), (Throwable)e);
            }
        }
    }

    static class DataToCompile {
        public Project project;
        public TypeScriptCompileInfo info;
        public boolean hasChangedConfigBeforeAnnotating;

        DataToCompile() {
        }
    }
}

