/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.refactoring;

import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.compiler.ui.projectView.TypeScriptNestingTreeStructureProvider;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;

public class TypeScriptCompilerMoveFileUtils {
    public static Collection<PsiFile> getSiblings(PsiFile file) {
        VirtualFile fileVirtualFile = file.getVirtualFile();
        if (fileVirtualFile == null) {
            return ContainerUtil.emptyList();
        }
        if (!TypeScriptCompilerSettings.acceptFileType(fileVirtualFile.getFileType())) {
            return ContainerUtil.emptyList();
        }
        String name = TypeScriptNestingTreeStructureProvider.getName(fileVirtualFile);
        VirtualFile parent = fileVirtualFile.getParent();
        if (parent == null) {
            return ContainerUtil.emptyList();
        }
        ArrayList result = ContainerUtil.newArrayList();
        for (VirtualFile virtualFile : parent.getChildren()) {
            PsiFile psiFile;
            String fileName;
            if (virtualFile.equals(fileVirtualFile) || !StringUtil.equals((CharSequence)name, (CharSequence)(fileName = TypeScriptNestingTreeStructureProvider.getName(virtualFile))) || !TypeScriptNestingTreeStructureProvider.isAcceptableExtension(virtualFile) || (psiFile = file.getManager().findFile(virtualFile)) == null) continue;
            result.add(psiFile);
        }
        return result;
    }

    public static boolean hasLinkedCompiledFiles(PsiFile file) {
        if (!TypeScriptCompilerSettings.getSettings(file.getProject()).isCompilerEnabled()) {
            return false;
        }
        VirtualFile fileVirtualFile = file.getVirtualFile();
        if (fileVirtualFile == null) {
            return false;
        }
        if (!TypeScriptCompilerSettings.acceptFileType(fileVirtualFile.getFileType())) {
            return false;
        }
        return !TypeScriptCompilerMoveFileUtils.getSiblings(file).isEmpty();
    }
}

