/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.formatter.blocks;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.formatter.blocks.JSBlock;
import com.intellij.lang.javascript.formatter.blocks.SubBlockVisitor;
import com.intellij.lang.javascript.formatter.blocks.alignment.ASTNodeBasedAlignmentFactory;
import com.intellij.lang.javascript.types.TypeScriptClassElementType;
import com.intellij.lang.typescript.TypeScriptElementTypes;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.xml.XmlFormattingPolicy;
import com.intellij.psi.formatter.xml.XmlTagBlock;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptSubBlockVisitor
extends SubBlockVisitor {
    public TypeScriptSubBlockVisitor(@Nullable JSBlock block, @NotNull CodeStyleSettings settings, @Nullable ASTNodeBasedAlignmentFactory alignmentFactory) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/typescript/formatter/blocks/TypeScriptSubBlockVisitor", "<init>"));
        }
        super(block, settings, JavaScriptSupportLoader.TYPESCRIPT, alignmentFactory);
    }

    @Override
    @Nullable
    protected Indent getIndent(ASTNode node, ASTNode child, @Nullable Indent sharedSmartIndent) {
        IElementType parentNodeElementType;
        IElementType nodeElementType = node.getElementType();
        IElementType childElementType = child.getElementType();
        ASTNode parentNode = node.getTreeParent();
        IElementType iElementType = parentNodeElementType = parentNode != null ? parentNode.getElementType() : null;
        if (parentNodeElementType instanceof TypeScriptClassElementType && JSElementTypes.FUNCTION_DECLARATIONS.contains(nodeElementType) && JSElementTypes.REFERENCE_EXPRESSION == childElementType) {
            return Indent.getNoneIndent();
        }
        if (nodeElementType == TypeScriptElementTypes.PROPERTY_SIGNATURE && childElementType == JSTokenTypes.IDENTIFIER) {
            return Indent.getNoneIndent();
        }
        if (nodeElementType == TypeScriptElementTypes.INDEX_SIGNATURE && childElementType == JSTokenTypes.LBRACKET) {
            return Indent.getNoneIndent();
        }
        if (nodeElementType instanceof TypeScriptClassElementType && childElementType == TypeScriptElementTypes.INDEX_SIGNATURE) {
            return Indent.getNormalIndent();
        }
        if (nodeElementType == TypeScriptElementTypes.IMPLICIT_MODULE && (childElementType == TypeScriptElementTypes.IMPLICIT_MODULE || childElementType == JSStubElementTypes.TYPESCRIPT_MODULE)) {
            return Indent.getNoneIndent();
        }
        return super.getIndent(node, child, sharedSmartIndent);
    }

    @Override
    @NotNull
    protected XmlTagBlock createXmlTagBlock(ASTNode child, Wrap wrap, Alignment childAlignment, Indent childIndent, XmlFormattingPolicy policy) {
        TypeScriptXmlTagBlock typeScriptXmlTagBlock = new TypeScriptXmlTagBlock(child, wrap, childAlignment, policy, childIndent);
        if (typeScriptXmlTagBlock == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/formatter/blocks/TypeScriptSubBlockVisitor", "createXmlTagBlock"));
        }
        return typeScriptXmlTagBlock;
    }

    private static class TypeScriptXmlTagBlock
    extends XmlTagBlock {
        public TypeScriptXmlTagBlock(ASTNode child, Wrap wrap, Alignment childAlignment, XmlFormattingPolicy policy, Indent childIndent) {
            super(child, wrap, childAlignment, policy, childIndent);
        }

        public TypeScriptXmlTagBlock(ASTNode child, Wrap wrap, Alignment alignment, XmlFormattingPolicy policy, Indent indent, boolean space) {
            super(child, wrap, alignment, policy, indent, space);
        }

        protected XmlTagBlock createTagBlock(ASTNode child, Indent indent, Wrap wrap, Alignment alignment) {
            return new TypeScriptXmlTagBlock(child, wrap, alignment, this.myXmlFormattingPolicy, indent != null ? indent : Indent.getNoneIndent(), this.isPreserveSpace());
        }

        protected boolean useMyFormatter(Language myLanguage, Language childLanguage, PsiElement childPsi) {
            IElementType type = childPsi.getNode().getElementType();
            if (type == JSTokenTypes.XML_JS_SCRIPT || type == JSTokenTypes.NON_CHAMELEON_XML_JS_SCRIPT) {
                return false;
            }
            return super.useMyFormatter(myLanguage, childLanguage, childPsi);
        }
    }
}

