/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.psi;

import com.intellij.javascript.nodejs.ResolvedModuleInfo;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.ES6ElementTypes;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.JSExportAssignment;
import com.intellij.lang.ecmascript6.resolve.ES6ImportHandler;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.ecmascript6.types.ES6ImportDeclarationElementType;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.ecmascript6.TypeScriptQualifiedItemProcessor;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.frameworks.amd.TypeScriptNodeReference;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptExportAssignment;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.lang.javascript.psi.resolve.accessibility.TypeScriptModuleAccessibilityChecker;
import com.intellij.lang.javascript.settings.JSApplicationSettings;
import com.intellij.lang.typescript.TypeScriptElementTypes;
import com.intellij.lang.typescript.formatter.TypeScriptCodeStyleSettings;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.resolve.TypeScriptAugmentationUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptAutoImportUtil {
    public static final TokenSet EXPORT_ASSIGNMENTS = TokenSet.create((IElementType[])new IElementType[]{ES6ElementTypes.EXPORT_DEFAULT_ASSIGNMENT, TypeScriptElementTypes.EXPORT_ASSIGNMENT});
    public static final TokenSet ES6_IMPORT_DECLARATION = TokenSet.create((IElementType[])new IElementType[]{ES6ElementTypes.IMPORT_DECLARATION});

    public static boolean isAvailableForImport(@NotNull JSElement elementToImport, JSReferencePlaceInfo placeInfo, @NotNull Project project) {
        if (elementToImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToImport", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "isAvailableForImport"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "isAvailableForImport"));
        }
        assert (DialectDetector.isTypeScript((PsiElement)elementToImport));
        JSReferenceExpression place = placeInfo.place;
        if (place.getQualifier() == null && TypeScriptModuleAccessibilityChecker.checkElementCanBeExported((PsiElement)elementToImport)) {
            String refName;
            JSExportAssignment assignment;
            if (elementToImport instanceof TypeScriptModule) {
                return false;
            }
            boolean isClassType = elementToImport instanceof JSClass;
            if (placeInfo.isStrictTypeContext && !isClassType) {
                return false;
            }
            if (!TypeScriptAutoImportUtil.isElementCanBeUsedInContext(elementToImport, placeInfo, isClassType)) {
                return false;
            }
            PsiElement parent = elementToImport.getParent();
            if (parent instanceof JSVarStatement) {
                parent = parent.getParent();
            }
            if (parent instanceof ES6ExportDefaultAssignment) {
                return true;
            }
            if (!TypeScriptPsiUtil.isTopLevelContainer(parent) || parent instanceof JSFile && !((JSFile)parent).isCommonJSModule() || parent.isEquivalentTo(placeInfo.container)) {
                return false;
            }
            if (parent instanceof TypeScriptModule && TypeScriptAugmentationUtil.isExternalModuleAugmentation((TypeScriptModule)parent)) {
                return false;
            }
            TypeScriptModuleAccessibilityChecker checker = TypeScriptModuleAccessibilityChecker.INSTANCE;
            if (checker.check((PsiElement)place, (PsiElement)elementToImport) != null) {
                return false;
            }
            PsiFile file = elementToImport.getContainingFile();
            VirtualFile elementVirtualFile = file.getVirtualFile();
            if (!(file instanceof JSFile) || !TypeScriptConfigService.Provider.isAccessible(project, placeInfo.file, elementVirtualFile)) {
                return false;
            }
            if (ES6ImportHandler.isExported((PsiElement)elementToImport)) {
                return true;
            }
            if (isClassType && (assignment = TypeScriptAutoImportUtil.getExportAssignment(elementToImport)) != null && (refName = assignment.getInitializerReference()) != null) {
                return refName.equals(elementToImport.getName());
            }
        }
        return false;
    }

    private static boolean isElementCanBeUsedInContext(@NotNull JSElement elementToImport, @NotNull JSReferencePlaceInfo placeInfo, boolean isClassType) {
        if (elementToImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToImport", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "isElementCanBeUsedInContext"));
        }
        if (placeInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "placeInfo", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "isElementCanBeUsedInContext"));
        }
        PsiElement parentContext = placeInfo.parent;
        boolean isNewContext = parentContext instanceof JSNewExpression;
        boolean isCallContext = parentContext instanceof JSCallExpression;
        if (!isClassType && isNewContext) {
            return false;
        }
        if (isClassType && isCallContext && !isNewContext) {
            return false;
        }
        return !(elementToImport instanceof TypeScriptInterface) || !isCallContext;
    }

    @NotNull
    public static GlobalSearchScope createSymbolToImportSearchScope(@NotNull PsiElement element, final Project project) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "createSymbolToImportSearchScope"));
        }
        DelegatingGlobalSearchScope delegatingGlobalSearchScope = new DelegatingGlobalSearchScope(JSResolveUtil.getResolveScope(element)){

            public boolean contains(@NotNull VirtualFile file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil$1", "contains"));
                }
                return super.contains(file) && TypeScriptAutoImportUtil.checkDefinitionForNodeModules(file, project);
            }
        };
        if (delegatingGlobalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "createSymbolToImportSearchScope"));
        }
        return delegatingGlobalSearchScope;
    }

    public static boolean checkDefinitionForNodeModules(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "checkDefinitionForNodeModules"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "checkDefinitionForNodeModules"));
        }
        if (TypeScriptUtil.isUnderNodeModules(file, project)) {
            return TypeScriptUtil.isDefinitionFile(file);
        }
        return true;
    }

    public static void addImportStatement(@NotNull JSQualifiedNamedElement elementToImport, @NotNull PsiElement place) {
        ES6ImportDeclaration possibleImport;
        if (elementToImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToImport", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "addImportStatement"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "addImportStatement"));
        }
        Project project = place.getProject();
        String name = elementToImport.getName();
        boolean isExportDefault = true;
        if (elementToImport instanceof JSAttributeListOwner) {
            JSAttributeList attributeList = ((JSAttributeListOwner)elementToImport).getAttributeList();
            if (!(elementToImport.getParent() instanceof JSExportAssignment) && attributeList != null && ES6ImportHandler.isExported((PsiElement)elementToImport)) {
                isExportDefault = false;
            }
        }
        JSQualifiedName qualifier = null;
        JSQualifiedName namespace = elementToImport.getNamespace();
        String externalModuleName = null;
        PsiElement externalModule = null;
        if (namespace == null) {
            Pair<String, PsiElement> moduleNameWithResolve = TypeScriptAutoImportUtil.getExternalModuleName(project, elementToImport, place);
            if (moduleNameWithResolve != null) {
                externalModuleName = (String)moduleNameWithResolve.first;
                externalModule = (PsiElement)moduleNameWithResolve.second;
            }
        } else {
            String topmostParent = JSQualifiedNameImpl.getTopmostParent(namespace);
            if (StringUtil.isQuotedString((String)topmostParent)) {
                externalModuleName = TypeScriptAutoImportUtil.wrapWithQuotesFromSettings(elementToImport, StringUtil.unquoteString((String)topmostParent));
                qualifier = ((JSQualifiedNameImpl)namespace).withoutInnermostComponent(null);
            } else {
                qualifier = namespace;
            }
        }
        JSExportAssignment exportAssignment = TypeScriptAutoImportUtil.getExportAssignment((JSElement)elementToImport);
        boolean hasTypeScriptExportAssignment = exportAssignment instanceof TypeScriptExportAssignment;
        final PsiNamedElement scope = TypeScriptAutoImportUtil.getScopeToAddImport(place, externalModuleName);
        if (externalModule != null && (possibleImport = TypeScriptAutoImportUtil.findExistingImport(elementToImport, (PsiElement)scope, externalModule)) != null && JSApplicationSettings.getInstance().isMergeImports() && TypeScriptAutoImportUtil.tryToAddImportToExistingDeclaration(project, possibleImport, name, isExportDefault)) {
            return;
        }
        ASTNode importNode = TypeScriptAutoImportUtil.createImportNode(project, name, externalModuleName, isExportDefault, qualifier, hasTypeScriptExportAssignment);
        if (importNode == null) {
            return;
        }
        final JSSourceElement importPsi = (JSSourceElement)importNode.getPsi();
        if (scope == null) {
            return;
        }
        final Pair<Boolean, PsiElement> placeForImport = TypeScriptAutoImportUtil.findPlaceForImport((PsiElement)scope);
        new WriteCommandAction.Simple<Void>(project, TypeScriptAutoImportUtil.getActionName(), new PsiFile[]{place.getContainingFile()}){

            protected void run() throws Throwable {
                if (((Boolean)placeForImport.first).booleanValue()) {
                    scope.addAfter((PsiElement)importPsi, (PsiElement)placeForImport.second);
                } else {
                    scope.addBefore((PsiElement)importPsi, (PsiElement)placeForImport.second);
                }
            }
        }.execute();
    }

    public static PsiNamedElement getScopeToAddImport(@NotNull PsiElement place, String externalModuleName) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "getScopeToAddImport"));
        }
        return externalModuleName == null ? (PsiNamedElement)PsiTreeUtil.getParentOfType((PsiElement)place, (Class[])new Class[]{JSFile.class, TypeScriptModule.class}) : (PsiNamedElement)PsiTreeUtil.getParentOfType((PsiElement)place, JSFile.class);
    }

    @Nullable
    public static ASTNode createImportNode(Project project, String name, String externalModuleName, boolean isExportDefault, JSQualifiedName qualifier, boolean hasTypeScriptExportAssignment) {
        ES6ImportDeclarationElementType expectedType;
        StringBuilder builder = new StringBuilder("import ");
        if (externalModuleName != null) {
            if (hasTypeScriptExportAssignment) {
                builder.append(name).append(" = require(").append(externalModuleName).append(')');
                expectedType = TypeScriptElementTypes.IMPORT_STATEMENT;
            } else {
                JSCodeStyleSettings settings = TypeScriptCodeStyleSettings.getTypeScriptSettings(project);
                boolean needSpace = settings.SPACES_WITHIN_IMPORTS;
                TypeScriptAutoImportUtil.wrapName(name, isExportDefault, builder, needSpace);
                builder.append(" from ").append(externalModuleName);
                expectedType = ES6ElementTypes.IMPORT_DECLARATION;
            }
        } else {
            builder.append(name).append(" = ");
            if (qualifier != null) {
                builder.append(qualifier);
            }
            if (qualifier != null) {
                builder.append('.');
            }
            if (!isExportDefault) {
                builder.append(name);
            }
            expectedType = TypeScriptElementTypes.IMPORT_STATEMENT;
        }
        builder.append(';');
        ASTNode importNode = JSChangeUtil.createStatementFromText(project, builder.toString(), JavaScriptSupportLoader.TYPESCRIPT);
        if (importNode == null || importNode.getElementType() != expectedType) {
            return null;
        }
        return importNode;
    }

    public static void wrapName(String name, boolean isExportDefault, StringBuilder builder, boolean needSpace) {
        if (!isExportDefault) {
            builder.append('{');
            if (needSpace) {
                builder.append(' ');
            }
        }
        builder.append(name);
        if (!isExportDefault) {
            if (needSpace) {
                builder.append(' ');
            }
            builder.append('}');
        }
    }

    @Nullable
    private static Pair<String, PsiElement> getExternalModuleName(@NotNull Project project, @NotNull JSQualifiedNamedElement elementToImport, @NotNull PsiElement place) {
        Pair<String, VirtualFile> modules;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "getExternalModuleName"));
        }
        if (elementToImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToImport", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "getExternalModuleName"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "getExternalModuleName"));
        }
        String externalModuleName = null;
        PsiFile placePsiFile = place.getContainingFile();
        VirtualFile placeFile = placePsiFile.getVirtualFile();
        PsiFile dstPsiFile = elementToImport.getContainingFile();
        VirtualFile dstFile = dstPsiFile.getVirtualFile();
        VirtualFile moduleDirectory = TypeScriptAutoImportUtil.findParentNodeModule(project, dstFile);
        PsiFile exportModule = null;
        if (moduleDirectory != null && (modules = TypeScriptAutoImportUtil.getModuleNameUsingNodeModules(project, elementToImport, moduleDirectory, dstFile, placePsiFile)) != null) {
            externalModuleName = (String)modules.first;
            VirtualFile file = (VirtualFile)modules.second;
            if (file != null) {
                exportModule = PsiManager.getInstance((Project)project).findFile(file);
            }
        }
        if (externalModuleName == null) {
            externalModuleName = TypeScriptAutoImportUtil.getExternalModuleNameForFile(project, placeFile, dstFile);
            if (externalModuleName == null) {
                return null;
            }
            exportModule = dstPsiFile;
        }
        externalModuleName = StringUtil.trimEnd(externalModuleName, (String)".d.ts");
        externalModuleName = StringUtil.trimEnd((String)externalModuleName, (String)".ts");
        externalModuleName = StringUtil.trimEnd((String)externalModuleName, (String)".tsx");
        externalModuleName = TypeScriptAutoImportUtil.wrapWithQuotesFromSettings(elementToImport, externalModuleName);
        return Pair.create((Object)externalModuleName, (Object)exportModule);
    }

    @NotNull
    private static String wrapWithQuotesFromSettings(@NotNull JSQualifiedNamedElement elementToImport, String externalModuleName) {
        if (elementToImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToImport", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "wrapWithQuotesFromSettings"));
        }
        String quote = JSCodeStyleSettings.getQuote((PsiElement)elementToImport);
        String string = externalModuleName = quote + externalModuleName + quote;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "wrapWithQuotesFromSettings"));
        }
        return string;
    }

    @Nullable
    private static String getExternalModuleNameForFile(Project project, VirtualFile placeFile, VirtualFile dstFile) {
        String externalModuleName;
        if (JSApplicationSettings.getInstance().isUseAbsoluteConfigPath()) {
            TypeScriptConfig file = TypeScriptConfigUtil.getConfigForFile(project, placeFile);
            VirtualFile rootFile = null;
            if (file != null && TypeScriptConfigService.Provider.isConfigInclude(project, dstFile, file)) {
                rootFile = file.getConfigFile().getParent();
            }
            if (rootFile == null) {
                rootFile = ProjectRootManager.getInstance((Project)project).getFileIndex().getContentRootForFile(placeFile, true);
            }
            if (rootFile != null) {
                return VfsUtil.getPath(rootFile, (VirtualFile)dstFile, (char)'/');
            }
        }
        if ((externalModuleName = VfsUtil.getPath((VirtualFile)placeFile, (VirtualFile)dstFile, (char)'/')) == null) {
            return null;
        }
        if (!externalModuleName.startsWith(".") && !externalModuleName.startsWith(String.valueOf(File.separatorChar))) {
            externalModuleName = "./" + externalModuleName;
        }
        return externalModuleName;
    }

    @Nullable
    public static Pair<String, VirtualFile> getModuleNameUsingNodeModules(Project project, @NotNull JSQualifiedNamedElement elementToImport, VirtualFile moduleDirectory, VirtualFile dstFile, PsiFile placePsiFile) {
        if (elementToImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToImport", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "getModuleNameUsingNodeModules"));
        }
        VirtualFile placeFile = placePsiFile.getVirtualFile();
        VirtualFile nodeModulesDirectory = moduleDirectory.getParent();
        assert (nodeModulesDirectory != null);
        VirtualFile parentOfNodeModules = nodeModulesDirectory.getParent();
        if (!VfsUtilCore.isAncestor((VirtualFile)parentOfNodeModules, (VirtualFile)placeFile, (boolean)true)) {
            return null;
        }
        if (!dstFile.getParent().equals(moduleDirectory)) {
            VirtualFile moduleMainFile;
            ResolvedModuleInfo info = TypeScriptNodeReference.resolveModuleInfoFromNodeModulesDir(project, parentOfNodeModules, moduleDirectory.getName());
            if (info != null && TypeScriptAutoImportUtil.checkSymbolInFile(project, moduleMainFile = info.getModuleMainFile(), elementToImport, placePsiFile)) {
                return Pair.create((Object)VfsUtil.getPath((VirtualFile)nodeModulesDirectory, (VirtualFile)moduleMainFile, (char)'/'), (Object)moduleMainFile);
            }
            for (VirtualFile file : moduleDirectory.getChildren()) {
                if (!TypeScriptUtil.isDefinitionFile(file) || !TypeScriptAutoImportUtil.checkSymbolInFile(project, file, elementToImport, placePsiFile)) continue;
                dstFile = file;
                break;
            }
        }
        return Pair.create((Object)VfsUtil.getPath((VirtualFile)nodeModulesDirectory, (VirtualFile)dstFile, (char)'/'), (Object)dstFile);
    }

    public static boolean checkSymbolInFile(@NotNull Project project, @NotNull VirtualFile virtualFile, @NotNull JSQualifiedNamedElement elementToImport, @NotNull PsiFile placePsiFile) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "checkSymbolInFile"));
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "checkSymbolInFile"));
        }
        if (elementToImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToImport", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "checkSymbolInFile"));
        }
        if (placePsiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "placePsiFile", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "checkSymbolInFile"));
        }
        PsiFile possiblePsiFile = PsiManager.getInstance((Project)project).findFile(virtualFile);
        if (!(possiblePsiFile instanceof JSFile)) {
            return false;
        }
        JSFile file = (JSFile)possiblePsiFile;
        return TypeScriptAutoImportUtil.checkSymbolInModule(elementToImport, placePsiFile, (JSElement)file);
    }

    public static boolean checkSymbolInModule(@NotNull JSQualifiedNamedElement elementToImport, @NotNull PsiFile placePsiFile, @NotNull JSElement module) {
        ResolveResult[] results;
        if (elementToImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToImport", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "checkSymbolInModule"));
        }
        if (placePsiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "placePsiFile", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "checkSymbolInModule"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "checkSymbolInModule"));
        }
        String name = elementToImport.getQualifiedName();
        if (name == null) {
            return false;
        }
        ResolveResultSink sink = new ResolveResultSink((PsiElement)placePsiFile, name);
        TypeScriptQualifiedItemProcessor<ResolveResultSink> processor = new TypeScriptQualifiedItemProcessor<ResolveResultSink>(sink, placePsiFile);
        ES6PsiUtil.processExportDeclarationInScope(module, processor, ResolveState.initial(), null, (PsiElement)placePsiFile);
        for (ResolveResult result : results = sink.getResultsAsResolveResults()) {
            PsiElement element = result.getElement();
            if (element == null || !element.isEquivalentTo(element)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static VirtualFile findParentNodeModule(Project project, VirtualFile dstFile) {
        VirtualFile prevDirectory = null;
        VirtualFile stopDir = project.getBaseDir();
        for (VirtualFile currentDirectory = dstFile.getParent(); currentDirectory != null && !stopDir.equals(currentDirectory); currentDirectory = currentDirectory.getParent()) {
            if ("node_modules".equals(currentDirectory.getName())) {
                return prevDirectory;
            }
            prevDirectory = currentDirectory;
        }
        return null;
    }

    @Nullable
    private static JSExportAssignment getExportAssignment(@NotNull JSElement elementToImport) {
        if (elementToImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToImport", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "getExportAssignment"));
        }
        JSElement module = (JSElement)PsiTreeUtil.getParentOfType((PsiElement)elementToImport, (Class[])new Class[]{TypeScriptModule.class, JSFile.class});
        if (module == null) {
            return null;
        }
        Object[] children = JSResolveUtil.getStubbedChildren((PsiElement)module, EXPORT_ASSIGNMENTS);
        PsiElement element = (PsiElement)ArrayUtil.getFirstElement((Object[])children);
        return element instanceof JSExportAssignment ? (JSExportAssignment)element : null;
    }

    @NotNull
    private static Pair<Boolean, PsiElement> findPlaceForImport(@NotNull PsiElement scope) {
        ASTNode lBrace;
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "findPlaceForImport"));
        }
        PsiElement currentChild = scope.getFirstChild();
        if (scope instanceof TypeScriptModule && (lBrace = scope.getNode().findChildByType(JSTokenTypes.LBRACE)) != null) {
            currentChild = lBrace.getPsi().getNextSibling();
        }
        PsiElement lastImport = null;
        while (currentChild != null) {
            if (currentChild instanceof TypeScriptImportStatement || currentChild instanceof ES6ImportDeclaration || TypeScriptAutoImportUtil.isUseStrictStatement(currentChild)) {
                lastImport = currentChild;
            } else if (lastImport == null && !(currentChild instanceof PsiWhiteSpace) && !(currentChild instanceof PsiComment)) break;
            currentChild = currentChild.getNextSibling();
        }
        Pair pair = Pair.create((Object)(lastImport != null ? 1 : 0), (Object)(lastImport != null ? lastImport : currentChild));
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "findPlaceForImport"));
        }
        return pair;
    }

    private static boolean isUseStrictStatement(PsiElement currentChild) {
        JSExpression expression;
        if (currentChild instanceof JSExpressionStatement && (expression = ((JSExpressionStatement)currentChild).getExpression()) instanceof JSLiteralExpression) {
            JSLiteralExpression literal = (JSLiteralExpression)expression;
            return "use strict".equals(literal.getValue());
        }
        return false;
    }

    private static ES6ImportDeclaration findExistingImport(@NotNull JSQualifiedNamedElement elementToImport, @NotNull PsiElement placeModule, @NotNull PsiElement module) {
        PsiElement[] declarations;
        if (elementToImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToImport", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "findExistingImport"));
        }
        if (placeModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "placeModule", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "findExistingImport"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "findExistingImport"));
        }
        for (PsiElement declaration : declarations = JSResolveUtil.getStubbedChildren(placeModule, ES6_IMPORT_DECLARATION)) {
            Collection resolvedElements;
            ES6ImportDeclaration es6Import;
            ES6FromClause clause;
            if (!(declaration instanceof ES6ImportDeclaration) || (clause = (es6Import = (ES6ImportDeclaration)declaration).getFromClause()) == null || !(resolvedElements = clause.resolveReferencedElements()).contains(module)) continue;
            return es6Import;
        }
        return null;
    }

    private static boolean tryToAddImportToExistingDeclaration(final Project project, final @NotNull ES6ImportDeclaration declaration, String name, boolean isExportDefault) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil", "tryToAddImportToExistingDeclaration"));
        }
        Object[] specifiers = declaration.getImportSpecifiers();
        if (specifiers.length == 0) {
            return false;
        }
        final ES6ImportSpecifier lastSpecifier = (ES6ImportSpecifier)ArrayUtil.getLastElement((Object[])specifiers);
        assert (lastSpecifier != null);
        ASTNode toInsertBeforeNode = lastSpecifier.getNode();
        if (toInsertBeforeNode == null) {
            return false;
        }
        StringBuilder builder = new StringBuilder("import {");
        if (isExportDefault) {
            builder.append("default as ");
        }
        builder.append(name);
        builder.append(",}");
        ASTNode importNode = JSChangeUtil.createStatementFromText(project, builder.toString(), JavaScriptSupportLoader.TYPESCRIPT);
        if (importNode == null) {
            return false;
        }
        final ASTNode specifierToInsertNode = importNode.findChildByType((IElementType)ES6ElementTypes.IMPORT_SPECIFIER);
        if (specifierToInsertNode == null) {
            return false;
        }
        final ASTNode commaNode = importNode.findChildByType(JSTokenTypes.COMMA);
        assert (commaNode != null);
        new WriteCommandAction.Simple<Void>(project, TypeScriptAutoImportUtil.getActionName(), new PsiFile[]{declaration.getContainingFile()}){

            protected void run() throws Throwable {
                PsiElement anchor = declaration.addAfter(commaNode.getPsi(), (PsiElement)lastSpecifier);
                declaration.addAfter(specifierToInsertNode.getPsi(), anchor);
                CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
                codeStyleManager.reformat((PsiElement)declaration);
            }
        }.execute();
        return true;
    }

    public static String getActionName() {
        return JSBundle.message((String)"ts.add.import.statement.family.name", (Object[])new Object[0]);
    }

    public static class JSReferencePlaceInfo {
        @NotNull
        private final JSReferenceExpression place;
        @NotNull
        private final PsiElement parent;
        @NotNull
        private final VirtualFile file;
        @NotNull
        private final PsiElement container;
        private final boolean isStrictTypeContext;

        public JSReferencePlaceInfo(@NotNull JSReferenceExpression place) {
            if (place == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil$JSReferencePlaceInfo", "<init>"));
            }
            this.place = place;
            this.parent = place.getParent();
            this.file = place.getContainingFile().getOriginalFile().getVirtualFile();
            this.container = TypeScriptPsiUtil.getTopLevelContainer((PsiElement)place);
            this.isStrictTypeContext = JSResolveUtil.isExprInStrictTypeContext(place);
        }
    }
}

