/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.resolve;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.ecmascript6.TypeScriptImportHandler;
import com.intellij.lang.javascript.ecmascript6.TypeScriptResolveProcessor;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptObjectType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeArgumentList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceListMember;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.resolve.JSGenericTypesEvaluator;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeResolveResult;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSIntersectionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.TypeScriptGenericThisTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptGenericTypesEvaluator
extends JSGenericTypesEvaluator {
    private static TypeScriptGenericTypesEvaluator INSTANCE = null;

    protected TypeScriptGenericTypesEvaluator() {
    }

    public static TypeScriptGenericTypesEvaluator getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new TypeScriptGenericTypesEvaluator();
        }
        return INSTANCE;
    }

    @Override
    @NotNull
    public JSType evaluateGenericsFromQualifier(@NotNull JSType type, @NotNull JSExpression qualifier, @NotNull JSReferenceExpression methodExpression) {
        JSType rawQualifier;
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/typescript/resolve/TypeScriptGenericTypesEvaluator", "evaluateGenericsFromQualifier"));
        }
        if (qualifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifier", "com/intellij/lang/typescript/resolve/TypeScriptGenericTypesEvaluator", "evaluateGenericsFromQualifier"));
        }
        if (methodExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodExpression", "com/intellij/lang/typescript/resolve/TypeScriptGenericTypesEvaluator", "evaluateGenericsFromQualifier"));
        }
        if (DialectDetector.isJavaScript((PsiElement)qualifier)) {
            type = super.evaluateGenericsFromQualifier(type, qualifier, methodExpression);
        }
        boolean hasGenerics = JSTypeUtils.hasGenericParameter(type);
        boolean hasThisGenericType = JSTypeUtils.hasThisGenericType(type);
        if (!hasGenerics && !hasThisGenericType) {
            if (!(type instanceof JSTypeImpl)) {
                JSType jSType = type;
                if (jSType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/resolve/TypeScriptGenericTypesEvaluator", "evaluateGenericsFromQualifier"));
                }
                return jSType;
            }
            JSTypeImpl jsType = (JSTypeImpl)type;
            if (!jsType.isLocal()) {
                JSType jSType = type;
                if (jSType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/resolve/TypeScriptGenericTypesEvaluator", "evaluateGenericsFromQualifier"));
                }
                return jSType;
            }
        }
        if ((rawQualifier = JSResolveUtil.getExpressionJSType(qualifier)) != null && hasThisGenericType) {
            type = TypeScriptGenericTypesEvaluator.evaluateThisType(type, rawQualifier);
        }
        Ref typeRef = Ref.create((Object)type);
        PsiElement sourceElement = type.getSource().getSourceElement();
        TypeScriptGenericTypesEvaluator.evaluateGenericsFromQualifierType(type, sourceElement, (Ref<JSType>)typeRef, rawQualifier);
        JSType jSType = (JSType)typeRef.get();
        if (jSType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/resolve/TypeScriptGenericTypesEvaluator", "evaluateGenericsFromQualifier"));
        }
        return jSType;
    }

    private static JSType evaluateThisType(@NotNull JSType type, final @NotNull JSType qualifierType) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/typescript/resolve/TypeScriptGenericTypesEvaluator", "evaluateThisType"));
        }
        if (qualifierType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifierType", "com/intellij/lang/typescript/resolve/TypeScriptGenericTypesEvaluator", "evaluateThisType"));
        }
        return type.transformTypeHierarchy((Function)new Function<JSType, JSType>(){

            public JSType fun(JSType jsType) {
                if (jsType instanceof TypeScriptGenericThisTypeImpl) {
                    return qualifierType;
                }
                return jsType;
            }
        }, null);
    }

    private static void evaluateGenericsFromQualifierType(@NotNull JSType type, PsiElement sourceElement, Ref<JSType> typeRef, JSType qualifierType) {
        JSTypeResolveResult result;
        JSType constraintType;
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/typescript/resolve/TypeScriptGenericTypesEvaluator", "evaluateGenericsFromQualifierType"));
        }
        if (qualifierType instanceof JSIntersectionTypeImpl) {
            for (JSType typeToProcess : ((JSIntersectionTypeImpl)qualifierType).getTypes()) {
                TypeScriptGenericTypesEvaluator.evaluateGenericsFromQualifierType(type, sourceElement, typeRef, typeToProcess);
            }
            return;
        }
        if (qualifierType instanceof JSGenericTypeImpl) {
            JSGenericTypeImpl genericType = (JSGenericTypeImpl)qualifierType;
            Map<String, JSType> outerArguments = genericType.getOuterArguments();
            if (outerArguments != null) {
                typeRef.set((Object)JSTypeUtils.applyGenericArguments((JSType)typeRef.get(), outerArguments));
            }
        } else if (qualifierType instanceof JSRecordType) {
            MultiMap<String, JSType> generics;
            PsiElement qualifierSource = qualifierType.getSource().getSourceElement();
            JSType objectType = null;
            if (qualifierSource instanceof TypeScriptObjectType) {
                objectType = TypeScriptTypeParser.buildTypeFromTypeScript((JSTypeDeclaration)((TypeScriptObjectType)qualifierSource));
            } else if (qualifierSource instanceof JSClass) {
                objectType = TypeScriptTypeParser.buildTypeFromClass((JSClass)qualifierSource, false);
            } else if (qualifierSource instanceof JSObjectLiteralExpression) {
                objectType = JSResolveUtil.getExpressionJSType((JSExpression)qualifierSource);
            }
            if (objectType != null && !(generics = TypeScriptGenericTypesEvaluator.findGenericsTypeValues(qualifierType, objectType)).isEmpty()) {
                typeRef.set((Object)JSTypeUtils.applyGenericArguments(type, TypeScriptGenericTypesEvaluator.intersectGenerics(generics, null), null));
                return;
            }
        }
        List<JSType> arguments = JSTypeUtils.getGenericTypeArguments(qualifierType);
        if (arguments == null && qualifierType instanceof JSGenericParameterImpl && (constraintType = ((JSGenericParameterImpl)qualifierType).getConstraintType()) != null) {
            qualifierType = constraintType;
            arguments = JSTypeUtils.getGenericTypeArguments(qualifierType);
        }
        if (arguments != null && sourceElement != null) {
            String name = JSTypeUtils.getQualifiedNameMatchingType(qualifierType, false);
            if (name != null) {
                result = TypeScriptImportHandler.getInstance().resolveTypeName(name, sourceElement);
                for (PsiElement psiElement : result.getElements()) {
                    JSClass parentClass;
                    JSClass jSClass;
                    if (!(psiElement instanceof JSClass) || !((jSClass = (JSClass)psiElement) instanceof TypeScriptTypeParameterListOwner) || (parentClass = (JSClass)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)sourceElement, JSClass.class)) == null) continue;
                    TypeScriptGenericTypesEvaluator.processClassWithGenericArguments(jSClass, arguments, parentClass, typeRef);
                }
            }
        } else if (qualifierType instanceof JSTypeImpl) {
            PsiElement source = qualifierType.getSource().getSourceElement();
            assert (source != null);
            result = TypeScriptImportHandler.getInstance().resolveTypeName(qualifierType.getTypeText(JSType.TypeTextFormat.SIMPLE), source);
            JSClass aClass = null;
            for (PsiElement psiElement : result.getElements()) {
                if (!(psiElement instanceof JSClass)) continue;
                aClass = (JSClass)psiElement;
                break;
            }
            JSClass jSClass = (JSClass)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)sourceElement, JSClass.class);
            if (aClass != null && jSClass != null) {
                TypeScriptGenericTypesEvaluator.processClassWithGenericArguments(aClass, new ArrayList<JSType>(), jSClass, typeRef);
            }
        }
    }

    public static boolean processClassWithGenericArguments(JSClass aClass, List<JSType> typeArgumentsList, JSClass requiredParentClass, Ref<JSType> appliedGenerics) {
        return TypeScriptGenericTypesEvaluator.processClassWithGenericArguments(aClass, typeArgumentsList, requiredParentClass, appliedGenerics, ContainerUtil.newHashSet());
    }

    public static boolean processClassWithGenericArguments(JSClass aClass, List<JSType> typeArgumentsList, JSClass requiredParentClass, Ref<JSType> appliedGenerics, @NotNull Set<JSClass> visitedClasses) {
        if (visitedClasses == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitedClasses", "com/intellij/lang/typescript/resolve/TypeScriptGenericTypesEvaluator", "processClassWithGenericArguments"));
        }
        if (!(aClass instanceof TypeScriptTypeParameterListOwner)) {
            return true;
        }
        if (aClass.isEquivalentTo((PsiElement)requiredParentClass)) {
            TypeScriptTypeParameterList typeParameterList = ((TypeScriptTypeParameterListOwner)aClass).getTypeParameterList();
            JSTypeSubstitutor genericArguments = TypeScriptGenericTypesEvaluator.getSubstitutorForTypeArguments(typeParameterList, typeArgumentsList);
            appliedGenerics.set((Object)JSTypeUtils.applyGenericArguments((JSType)appliedGenerics.get(), (Map<String, JSType>)genericArguments));
            return false;
        }
        TypeScriptTypeParameterList typeParameterList = ((TypeScriptTypeParameterListOwner)aClass).getTypeParameterList();
        ArrayList superReferences = ContainerUtil.newArrayList();
        JSReferenceList extendsList = aClass.getExtendsList();
        JSReferenceList implementsList = aClass.getImplementsList();
        if (extendsList != null) {
            superReferences.addAll(extendsList.getResolvedExpressions());
        }
        if (implementsList != null) {
            superReferences.addAll(implementsList.getResolvedExpressions());
        }
        if (!superReferences.isEmpty()) {
            JSTypeSubstitutor typeArguments = TypeScriptGenericTypesEvaluator.getSubstitutorForTypeArguments(typeParameterList, typeArgumentsList);
            for (Pair reference : superReferences) {
                if (reference.second == null || ((Collection)reference.second).isEmpty()) continue;
                List<JSType> superclassTypeArguments = TypeScriptGenericTypesEvaluator.getTypeArgumentsForDeclarations(((JSReferenceListMember)reference.first).getTypeArguments(), (Map<String, JSType>)typeArguments);
                for (JSClass jsSuperClass : (Collection)reference.second) {
                    if (!JSInheritanceUtil.isParentClass(jsSuperClass, requiredParentClass, false)) continue;
                    if (!visitedClasses.add(jsSuperClass)) {
                        return false;
                    }
                    if (TypeScriptGenericTypesEvaluator.processClassWithGenericArguments(jsSuperClass, superclassTypeArguments, requiredParentClass, appliedGenerics, visitedClasses)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @NotNull
    public static List<JSType> getTypeArgumentsForExpression(JSExpression reference, Map<String, JSType> typeArguments) {
        JSTypeDeclaration[] arguments;
        JSExpression nextSibling = reference;
        while ((nextSibling = nextSibling.getNextSibling()) != null && nextSibling.getNode().getElementType() == JSTokenTypes.WHITE_SPACE) {
        }
        if (nextSibling instanceof TypeScriptTypeArgumentList && (arguments = ((TypeScriptTypeArgumentList)nextSibling).getTypeArguments()) != null) {
            List<JSType> list = TypeScriptGenericTypesEvaluator.getTypeArgumentsForDeclarations(arguments, typeArguments);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/resolve/TypeScriptGenericTypesEvaluator", "getTypeArgumentsForExpression"));
            }
            return list;
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/resolve/TypeScriptGenericTypesEvaluator", "getTypeArgumentsForExpression"));
        }
        return list;
    }

    public static List<JSType> getTypeArgumentsForDeclarations(@NotNull JSTypeDeclaration[] declarations, Map<String, JSType> typeArguments) {
        if (declarations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarations", "com/intellij/lang/typescript/resolve/TypeScriptGenericTypesEvaluator", "getTypeArgumentsForDeclarations"));
        }
        List superclassTypeArguments = ContainerUtil.newSmartList();
        for (JSTypeDeclaration typeArgument : declarations) {
            JSType expandedType = TypeScriptTypeParser.buildTypeFromTypeScript(typeArgument);
            if (typeArguments != null) {
                expandedType = JSTypeUtils.applyGenericArguments(expandedType, typeArguments);
            }
            superclassTypeArguments.add(expandedType);
        }
        return superclassTypeArguments;
    }

    @Nullable
    public static JSTypeSubstitutor getSubstitutorForTypeArguments(@Nullable TypeScriptTypeParameterList typeParameterList, @NotNull List<JSType> typeArgumentsList) {
        if (typeArgumentsList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeArgumentsList", "com/intellij/lang/typescript/resolve/TypeScriptGenericTypesEvaluator", "getSubstitutorForTypeArguments"));
        }
        JSTypeSubstitutor genericArguments = null;
        if (!typeArgumentsList.isEmpty() && typeParameterList != null) {
            genericArguments = new JSTypeSubstitutor();
            TypeScriptTypeParameter[] parameters = typeParameterList.getTypeParameters();
            for (int i = 0; i < parameters.length; ++i) {
                String name;
                if (typeArgumentsList.size() <= i || (name = parameters[i].getName()) == null) continue;
                genericArguments.put((Object)name, (Object)typeArgumentsList.get(i));
            }
        }
        return genericArguments;
    }

    @Override
    @Nullable
    public JSType evaluateGenerics(@Nullable JSType type, JSExpression methodExpression, @Nullable PsiElement resolvedFunction, @Nullable JSGenericTypesEvaluator.GenericErrorReporter reporter) {
        if (type != null && methodExpression != null) {
            JSReferenceList list;
            TypeScriptClass tsClass;
            PsiElement callExpression = methodExpression.getParent();
            THashMap map = TypeScriptResolveProcessor.addGenericArgumentsFromCall(resolvedFunction, callExpression, null);
            if (TypeScriptGenericTypesEvaluator.isConstructorSuperCall(resolvedFunction, (PsiElement)methodExpression) && (tsClass = (TypeScriptClass)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)methodExpression, TypeScriptClass.class)) != null && resolvedFunction instanceof TypeScriptFunction && (list = tsClass.getExtendsList()) != null) {
                if (tsClass.getIndirectSuperConstructors().contains(resolvedFunction)) {
                    List<JSType> typesForGenerics = TypeScriptGenericTypesEvaluator.getTypeArgumentsForExpression((JSExpression)ArrayUtil.getFirstElement((Object[])list.getExpressions()), null);
                    JSTypeSubstitutor argumentsFromSuper = TypeScriptGenericTypesEvaluator.getSubstitutorForTypeArguments(((TypeScriptFunction)resolvedFunction).getTypeParameterList(), typesForGenerics);
                    if (argumentsFromSuper != null) {
                        if (map == null) {
                            map = ContainerUtil.newTroveMap();
                        }
                        map.putAll(argumentsFromSuper);
                    }
                } else {
                    Ref typeRef = Ref.create((Object)type);
                    TypeScriptGenericTypesEvaluator.processClassWithGenericArguments((JSClass)tsClass, ContainerUtil.emptyList(), (JSClass)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)resolvedFunction, JSClass.class), (Ref<JSType>)typeRef);
                    type = (JSType)typeRef.get();
                }
            }
            type = JSTypeUtils.applyGenericArguments(type, map, false, reporter);
        }
        return super.evaluateGenerics(type, methodExpression, resolvedFunction, reporter);
    }

    private static boolean isConstructorSuperCall(PsiElement resolveResult, PsiElement callExpression) {
        return callExpression instanceof JSSuperExpression && callExpression.getParent() instanceof JSCallExpression && resolveResult instanceof JSFunction && ((JSFunction)resolveResult).isConstructor();
    }
}

