/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.tsconfig;

import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.index.JavaScriptIndex;
import com.intellij.lang.javascript.library.JSCorePredefinedLibrariesProvider;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.psi.util.JSProjectUtil;
import com.intellij.lang.typescript.TypeScriptSettings;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigImpl;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigLibraryUpdater;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.include.FileIncludeManager;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptConfigServiceImpl
implements TypeScriptConfigService {
    public static final Logger LOGGER = Logger.getInstance(TypeScriptConfigService.class);
    private static final Function<PsiFile, TypeScriptConfig> MAP_TO_CONFIG = new Function<PsiFile, TypeScriptConfig>(){

        public TypeScriptConfig fun(PsiFile file) {
            if (JSLibraryUtil.isProbableLibraryFile(file.getVirtualFile())) {
                return null;
            }
            return TypeScriptConfigImpl.getConfig(file);
        }
    };
    @NotNull
    private final Project myProject;
    @NotNull
    private final CachedValue<Collection<TypeScriptConfig>> myCachedValue;
    private final SimpleModificationTracker myTracker;
    @Nullable
    private final TypeScriptConfigLibraryUpdater myUpdater;

    public TypeScriptConfigServiceImpl(@NotNull Project project, @Nullable TypeScriptConfigLibraryUpdater updater) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigServiceImpl", "<init>"));
        }
        this.myTracker = new SimpleModificationTracker();
        this.myProject = project;
        this.myUpdater = updater;
        CachedValueProvider<Collection<TypeScriptConfig>> cachedValueProvider = new CachedValueProvider<Collection<TypeScriptConfig>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Nullable
            public CachedValueProvider.Result<Collection<TypeScriptConfig>> compute() {
                AccessToken token = ApplicationManager.getApplication().acquireReadActionLock();
                TypeScriptConfigServiceImpl.this.update();
                try {
                    Object[] files = FilenameIndex.getFilesByName((Project)TypeScriptConfigServiceImpl.this.myProject, (String)"tsconfig.json", (GlobalSearchScope)GlobalSearchScope.projectScope((Project)TypeScriptConfigServiceImpl.this.myProject));
                    List configs = ContainerUtil.mapNotNull((Object[])files, (Function)MAP_TO_CONFIG);
                    ArrayList depends = ContainerUtil.newArrayList((Object[])files);
                    depends.add(JSProjectUtil.FILE_SYSTEM_STRUCTURE_MODIFICATION_TRACKER);
                    CachedValueProvider.Result result = CachedValueProvider.Result.create((Object)configs, (Collection)depends);
                    return result;
                }
                finally {
                    token.finish();
                }
            }
        };
        this.myCachedValue = CachedValuesManager.getManager((Project)this.myProject).createCachedValue((CachedValueProvider)cachedValueProvider, false);
    }

    private void update() {
        this.myTracker.incModificationCount();
        if (this.myUpdater != null) {
            this.myUpdater.queueToUpdate();
        }
    }

    public boolean isEnabled() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return true;
        }
        TypeScriptSettings settings = TypeScriptSettings.getSettings(this.myProject);
        if (settings == null) {
            return false;
        }
        return settings.isEnabledConfig();
    }

    public boolean isCheckReferencePaths() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return true;
        }
        TypeScriptSettings settings = TypeScriptSettings.getSettings(this.myProject);
        if (settings == null) {
            return false;
        }
        return settings.isCheckReferencePaths();
    }

    @Override
    public boolean isAccessible(@NotNull VirtualFile scope, @NotNull VirtualFile file) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigServiceImpl", "isAccessible"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigServiceImpl", "isAccessible"));
        }
        if (!this.isEnabled()) {
            return true;
        }
        if (scope.equals(file)) {
            return true;
        }
        String fileName = file.getName();
        boolean isStandardLib = JavaScriptIndex.LIBS_D_TS.contains(fileName);
        if (isStandardLib && (JSCorePredefinedLibrariesProvider.getTypeScriptPredefinedLibraryFiles().contains(file) || JSCorePredefinedLibrariesProvider.getTypeScriptES6PredefinedLibraryFiles().contains(file))) {
            return true;
        }
        Collection<TypeScriptConfig> files = this.getConfigFiles();
        if (files.isEmpty()) {
            return true;
        }
        boolean firstInclude = false;
        boolean bothIncludes = false;
        Collection includesFirst = null;
        for (TypeScriptConfig config : files) {
            if (!config.isIncludeFile(scope)) continue;
            firstInclude = true;
            if (includesFirst == null) {
                includesFirst = new THashSet();
            }
            includesFirst.add(config);
            if (!config.isIncludeFile(file)) continue;
            bothIncludes = true;
            break;
        }
        if (!firstInclude || bothIncludes) {
            return true;
        }
        if (!isStandardLib && !JavaScriptIndex.CORE_LIBS_D_TS.contains(fileName) && TypeScriptUtil.isNodeModulesDefinition(file, this.myProject)) {
            return true;
        }
        return this.checkReferencePaths(file, includesFirst);
    }

    private boolean checkReferencePaths(@NotNull VirtualFile file, @Nullable Collection<TypeScriptConfig> configs) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigServiceImpl", "checkReferencePaths"));
        }
        if (!this.isCheckReferencePaths()) {
            return false;
        }
        if (configs == null) {
            return false;
        }
        return this.checkReferencePaths(file, configs, ContainerUtil.newHashSet());
    }

    private boolean checkReferencePaths(@NotNull VirtualFile startFileToCheck, @NotNull Collection<TypeScriptConfig> configs, @NotNull Collection<VirtualFile> visited) {
        if (startFileToCheck == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startFileToCheck", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigServiceImpl", "checkReferencePaths"));
        }
        if (configs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configs", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigServiceImpl", "checkReferencePaths"));
        }
        if (visited == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visited", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigServiceImpl", "checkReferencePaths"));
        }
        if (!visited.add(startFileToCheck)) {
            return false;
        }
        VirtualFile[] files = FileIncludeManager.getManager((Project)this.myProject).getIncludingFiles(startFileToCheck, false);
        if (files == null || files.length == 0) {
            return false;
        }
        for (VirtualFile virtualFile : files) {
            for (TypeScriptConfig config : configs) {
                if (!config.isIncludeFile(virtualFile)) continue;
                return true;
            }
        }
        for (VirtualFile virtualFile : files) {
            if (!this.checkReferencePaths(virtualFile, configs, visited)) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public Collection<TypeScriptConfig> getConfigInclude(@NotNull VirtualFile scopeFile) {
        if (scopeFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeFile", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigServiceImpl", "getConfigInclude"));
        }
        Collection<TypeScriptConfig> files = this.getConfigFiles();
        if (files.isEmpty()) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigServiceImpl", "getConfigInclude"));
            }
            return list;
        }
        ArrayList result = ContainerUtil.newArrayList();
        for (TypeScriptConfig config : files) {
            if (!this.isConfigInclude(scopeFile, config)) continue;
            result.add(config);
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigServiceImpl", "getConfigInclude"));
        }
        return arrayList;
    }

    @Override
    public boolean isConfigInclude(@NotNull VirtualFile scopeFile, @NotNull TypeScriptConfig config) {
        if (scopeFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeFile", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigServiceImpl", "isConfigInclude"));
        }
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigServiceImpl", "isConfigInclude"));
        }
        return config.isIncludeFile(scopeFile) || this.checkReferencePaths(scopeFile, ContainerUtil.createMaybeSingletonList((Object)config));
    }

    @Override
    public ModificationTracker getTracker() {
        return this.myTracker;
    }

    @Override
    @NotNull
    public Collection<TypeScriptConfig> getConfigFiles() {
        Collection value = (Collection)this.myCachedValue.getValue();
        Collection collection = value == null ? ContainerUtil.emptyList() : value;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigServiceImpl", "getConfigFiles"));
        }
        return collection;
    }
}

