/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.functionmetrics;

import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterItemWithSource;
import com.intellij.psi.PsiElement;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.JSGroupNames;
import com.sixrr.inspectjs.functionmetrics.FunctionMetricsInspection;
import org.jetbrains.annotations.NotNull;

public class ParametersPerFunctionJSInspection
extends FunctionMetricsInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionJSBundle.message("function.with.too.many.parameters.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/functionmetrics/ParametersPerFunctionJSInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = JSGroupNames.FUNCTIONMETRICS_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/functionmetrics/ParametersPerFunctionJSInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @Override
    protected int getDefaultLimit() {
        return 5;
    }

    @Override
    protected String getConfigurationLabel() {
        return InspectionJSBundle.message("function.parameter.limit", new Object[0]);
    }

    @Override
    public String buildErrorString(Object ... args) {
        JSFunction function = (JSFunction)((PsiElement)args[0]).getParent();
        assert (function != null);
        JSParameter[] parameters = function.getParameterVariables();
        int numParameters = parameters.length;
        if (this.functionHasIdentifier(function)) {
            return InspectionJSBundle.message("function.has.too.many.parameters.error.string", numParameters);
        }
        return InspectionJSBundle.message("anonymous.function.has.too.many.parameters.error.string", numParameters);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        public void visitJSFunctionDeclaration(@NotNull JSFunction function) {
            if (function == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/sixrr/inspectjs/functionmetrics/ParametersPerFunctionJSInspection$Visitor", "visitJSFunctionDeclaration"));
            }
            JSParameterItemWithSource[] parameters = function.getParameters();
            int numParameters = parameters.length;
            if (numParameters <= ParametersPerFunctionJSInspection.this.getLimit()) {
                return;
            }
            this.registerFunctionError(function);
        }

        @Override
        public void visitJSFunctionExpression(JSFunctionExpression node) {
            this.visitJSFunctionDeclaration((JSFunction)node);
        }
    }
}

