/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.style;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.lang.ASTNode;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSBreakStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSContinueStatement;
import com.intellij.lang.javascript.psi.JSDoWhileStatement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionCodeFragment;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSForStatement;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSInheritedLanguagesHelper;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSThrowStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.IncorrectOperationException;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.InspectionJSFix;
import com.sixrr.inspectjs.JSGroupNames;
import com.sixrr.inspectjs.JavaScriptInspection;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnterminatedStatementJSInspection
extends JavaScriptInspection
implements CleanupLocalInspectionTool {
    private final TerminateStatementFix fix = new TerminateStatementFix();
    public boolean ignoreSemicolonAtEndOfBlock = true;

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionJSBundle.message("unterminated.statement.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/style/UnterminatedStatementJSInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = JSGroupNames.STYLE_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/style/UnterminatedStatementJSInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return InspectionJSBundle.message("unterminated.statement.error.string", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor(this.ignoreSemicolonAtEndOfBlock);
    }

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionJSBundle.message("unterminated.statement.ignore.atend.of.block", new Object[0]), (InspectionProfileEntry)this, "ignoreSemicolonAtEndOfBlock");
    }

    @Override
    public InspectionJSFix buildFix(PsiElement location) {
        return this.fix;
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private final boolean ignoreSemicolonAtEndOfBlock;

        public Visitor(boolean ignoreSemicolonAtEndOfBlock) {
            this.ignoreSemicolonAtEndOfBlock = ignoreSemicolonAtEndOfBlock;
        }

        public void visitJSCallExpression(JSCallExpression node) {
            PsiElement psiElement;
            super.visitJSCallExpression(node);
            JSExpression methodExpression = node.getMethodExpression();
            if ((methodExpression instanceof JSArrayLiteralExpression || methodExpression instanceof JSObjectLiteralExpression || methodExpression instanceof JSFunctionExpression) && (psiElement = PsiTreeUtil.nextLeaf((PsiElement)methodExpression)) instanceof PsiWhiteSpace && psiElement.textContains('\n')) {
                this.problemsHolder.registerProblem(psiElement, InspectionJSBundle.message("unterminated.statement.error.string2", new Object[0]), this.getProblemHighlightType(psiElement), new LocalQuickFix[0]);
            }
        }

        public void visitJSExpressionStatement(JSExpressionStatement statement) {
            super.visitJSExpressionStatement(statement);
            if (statement.getContainingFile() instanceof JSExpressionCodeFragment || this.isTerminated((JSStatement)statement)) {
                return;
            }
            this.registerError((PsiElement)statement);
        }

        public void visitJSBreakStatement(JSBreakStatement jsBreakStatement) {
            super.visitJSBreakStatement(jsBreakStatement);
            if (this.isTerminated((JSStatement)jsBreakStatement)) {
                return;
            }
            this.registerError((PsiElement)jsBreakStatement);
        }

        public void visitJSContinueStatement(JSContinueStatement jsContinueStatement) {
            super.visitJSContinueStatement(jsContinueStatement);
            if (this.isTerminated((JSStatement)jsContinueStatement)) {
                return;
            }
            this.registerError((PsiElement)jsContinueStatement);
        }

        @Override
        protected void registerError(PsiElement location) {
            PsiFile file = location.getContainingFile();
            PsiElement context = file.getContext();
            if (context != null && !context.textContains('\n')) {
                return;
            }
            this.registerErrorAfter(location);
        }

        public void visitJSReturnStatement(JSReturnStatement jsReturnStatement) {
            super.visitJSReturnStatement(jsReturnStatement);
            if (jsReturnStatement.getNode().findChildByType(JSTokenTypes.RETURN_KEYWORD) == null || this.isTerminated((JSStatement)jsReturnStatement)) {
                return;
            }
            this.registerError((PsiElement)jsReturnStatement);
        }

        public void visitJSThrowStatement(JSThrowStatement jsThrowStatement) {
            super.visitJSThrowStatement(jsThrowStatement);
            if (this.isTerminated((JSStatement)jsThrowStatement)) {
                return;
            }
            this.registerError((PsiElement)jsThrowStatement);
        }

        public void visitJSDoWhileStatement(JSDoWhileStatement jsDoWhileStatement) {
            super.visitJSDoWhileStatement(jsDoWhileStatement);
            if (this.isTerminated((JSStatement)jsDoWhileStatement)) {
                return;
            }
            this.registerError((PsiElement)jsDoWhileStatement);
        }

        public void visitJSVarStatement(JSVarStatement jsVarStatement) {
            super.visitJSVarStatement(jsVarStatement);
            if (this.isTerminated((JSStatement)jsVarStatement)) {
                return;
            }
            this.registerError((PsiElement)jsVarStatement);
        }

        private boolean isTerminated(JSStatement statement) {
            if (!JSInheritedLanguagesHelper.isNeedToBeTerminated((PsiElement)statement)) {
                return true;
            }
            PsiElement parent = statement.getParent();
            if (parent instanceof JSForInStatement || parent instanceof JSForStatement) {
                return true;
            }
            String text = statement.getText();
            if (text == null) {
                return true;
            }
            boolean terminated = text.endsWith(";");
            if (!terminated) {
                IElementType type;
                ASTNode nextLeafNode;
                PsiElement nextLeaf = PsiTreeUtil.nextLeaf((PsiElement)statement);
                if (nextLeaf instanceof PsiWhiteSpace) {
                    nextLeaf = PsiTreeUtil.nextLeaf((PsiElement)nextLeaf);
                }
                if (nextLeaf != null ? (nextLeafNode = nextLeaf.getNode()) != null && ((type = nextLeafNode.getElementType()) == JSTokenTypes.RBRACE || type == XmlTokenType.XML_END_TAG_START || type == XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER) : InjectedLanguageManager.getInstance((Project)statement.getContainingFile().getProject()).getInjectionHost((PsiElement)statement.getContainingFile()) != null) {
                    return this.ignoreSemicolonAtEndOfBlock;
                }
            }
            return terminated;
        }
    }

    private static class TerminateStatementFix
    extends InspectionJSFix {
        private TerminateStatementFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionJSBundle.message("terminate.statement.fix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/style/UnterminatedStatementJSInspection$TerminateStatementFix", "getName"));
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            JSStatement expression;
            PsiElement element = descriptor.getPsiElement();
            if (element instanceof PsiWhiteSpace) {
                element = element.getPrevSibling();
            }
            if ((expression = (JSStatement)PsiTreeUtil.getParentOfType((PsiElement)element, JSStatement.class, (boolean)false)) instanceof JSBlockStatement && expression.getParent() instanceof JSFunctionExpression) {
                expression = (JSStatement)PsiTreeUtil.getParentOfType((PsiElement)expression, JSStatement.class);
            }
            if (expression == null) {
                return;
            }
            expression.getNode().addLeaf(JSTokenTypes.SEMICOLON, (CharSequence)";", null);
        }
    }
}

