/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.v8;

import com.intellij.util.Consumer;
import com.intellij.util.containers.UtilKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.chromium.sdk.internal.v8native.protocol.input.FrameInfo;
import org.chromium.sdk.internal.v8native.protocol.input.FunctionInfo;
import org.chromium.sdk.internal.v8native.protocol.input.ValueHandle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.Breakpoint;
import org.jetbrains.debugger.ExceptionData;
import org.jetbrains.debugger.StepAction;
import org.jetbrains.io.JsonReaderEx;
import org.jetbrains.jsonProtocol.Request;
import org.jetbrains.rpc.CommandProcessorKt;
import org.jetbrains.v8.V8SuspendContext;
import org.jetbrains.v8.V8SuspendContextManagerKt;
import org.jetbrains.v8.V8Vm;
import org.jetbrains.v8.protocol.BreakEventBody;
import org.jetbrains.v8.protocol.FrameDescriptor;
import org.jetbrains.v8.protocol.GetFramesResult;
import org.jetbrains.v8.protocol.IncomingMessage;
import org.jetbrains.v8.protocol.ObjectDescriptor;
import org.jetbrains.v8.protocol.OriginalProtocolKt;
import org.jetbrains.v8.protocol.ProtocolKt;
import org.jetbrains.v8.protocol.ScriptHandle;
import org.jetbrains.v8.protocol.SomeHandle;
import org.jetbrains.v8.protocol.V8ProtocolReader;
import org.jetbrains.v8.protocol.V8ProtocolUtilKt;
import org.jetbrains.v8.value.V8ExceptionData;
import org.jetbrains.v8.value.V8ValueManager;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=2, d1={"\u0000F\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f\u001aL\u0010\r\u001a\u00020\t2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00052\b\u0010\n\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u000e\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u00162\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\u0018"}, d2={"createException", "Lorg/jetbrains/debugger/ExceptionData;", "response", "Lorg/jetbrains/v8/protocol/IncomingMessage;", "body", "Lorg/jetbrains/v8/protocol/BreakEventBody;", "valueLoader", "Lorg/jetbrains/v8/value/V8ValueManager;", "processBreak", "", "event", "vm", "Lorg/jetbrains/v8/V8Vm;", "processBreakWithFrameInfo", "breakData", "eventName", "", "frame", "Lorg/jetbrains/v8/protocol/FrameDescriptor;", "hitBreakpoints", "", "objects", "", "Lorg/jetbrains/v8/protocol/ObjectDescriptor;", "v8-backend"})
public final class BreakEventHandlerKt {
    public static final void processBreak(@NotNull IncomingMessage event, @NotNull V8Vm vm) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        Intrinsics.checkParameterIsNotNull((Object)((Object)vm), (String)"vm");
        if (vm.getHasJbDebuggerSupport()) {
            V8ProtocolReader v8ProtocolReader = V8ProtocolUtilKt.getPROTOCOL_READER();
            JsonReaderEx jsonReaderEx = event.body();
            if (jsonReaderEx == null) {
                Intrinsics.throwNpe();
            }
            BreakEventBody breakData = v8ProtocolReader.readBreakEvent(jsonReaderEx);
            vm.getCommandProcessor().send((Request)ProtocolKt.GetFrames(0, 1)).done(new Consumer<? super T>(breakData, event, vm){
                final /* synthetic */ BreakEventBody $breakData;
                final /* synthetic */ IncomingMessage $event;
                final /* synthetic */ V8Vm $vm;

                public final void consume(GetFramesResult it) {
                    String string = this.$event.event();
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    BreakEventHandlerKt.processBreakWithFrameInfo(this.$breakData, this.$event, string, (FrameDescriptor)CollectionsKt.first(it.frames()), this.$breakData.breakpoints(), it.getObjects(), this.$vm);
                }
                {
                    this.$breakData = breakEventBody;
                    this.$event = incomingMessage;
                    this.$vm = v8Vm;
                }
            }).rejected((Consumer)new Consumer<Throwable>(vm){
                final /* synthetic */ V8Vm $vm;

                public final void consume(Throwable it) {
                    if (Intrinsics.areEqual((Object)"Connection closed", (Object)it.getMessage()) ^ true) {
                        CommandProcessorKt.getLOG().error(it);
                        this.$vm.getDebugListener().errorOccurred("Cannot stop on breakpoint due to internal error: " + it);
                        this.$vm.getCommandProcessor().send((Request)V8SuspendContextManagerKt.ContinueMessage(StepAction.CONTINUE, 0));
                    }
                }
                {
                    this.$vm = v8Vm;
                }
            });
            return;
        }
        vm.getCommandProcessor().send((Request)OriginalProtocolKt.FrameMessage()).done(new Consumer<? super T>(event, vm){
            final /* synthetic */ IncomingMessage $event;
            final /* synthetic */ V8Vm $vm;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final void consume(FrameInfo topFrame) {
                V8SuspendContext context;
                block7: {
                    String string;
                    Integer n;
                    V8ProtocolReader v8ProtocolReader = V8ProtocolUtilKt.getPROTOCOL_READER();
                    JsonReaderEx jsonReaderEx = this.$event.body();
                    if (jsonReaderEx == null) {
                        Intrinsics.throwNpe();
                    }
                    BreakEventBody breakData = v8ProtocolReader.readBreakEvent(jsonReaderEx);
                    ScriptHandle scriptHandle = breakData.getScript();
                    if (scriptHandle != null) {
                        n = scriptHandle.getId();
                    } else {
                        FunctionInfo functionInfo = topFrame.func();
                        n = functionInfo != null ? Integer.valueOf(functionInfo.scriptId()) : null;
                    }
                    int scriptId = n != null ? ((Number)n).intValue() : -1;
                    String string2 = string = this.$event.event();
                    if (string2 == null) throw (Throwable)new IllegalStateException();
                    switch (string2.hashCode()) {
                        case 1481625679: {
                            if (!string.equals("exception")) throw (Throwable)new IllegalStateException();
                            break;
                        }
                        case 94001407: {
                            if (!string.equals("break")) throw (Throwable)new IllegalStateException();
                            List<Breakpoint> breakpoints = this.$vm.getBreakpointManager().findRelatedBreakpoints(scriptId, topFrame.line(), topFrame.column(), breakData.breakpoints());
                            context = new V8SuspendContext(scriptId, this.$vm, breakpoints, false, 8, null);
                            break block7;
                        }
                    }
                    context = new V8SuspendContext(scriptId, this.$vm, null, false, 12, null);
                    context.setExceptionData(BreakEventHandlerKt.access$createException(this.$event, breakData, (V8ValueManager)context.getValueManager()));
                    break block7;
                    throw (Throwable)new IllegalStateException();
                }
                this.$vm.getSuspendContextManager().setContextAndNotify(context, topFrame);
            }
            {
                this.$event = incomingMessage;
                this.$vm = v8Vm;
            }
        });
    }

    /*
     * Unable to fully structure code
     */
    public static final void processBreakWithFrameInfo(@Nullable BreakEventBody breakData, @Nullable IncomingMessage event, @NotNull String eventName, @NotNull FrameDescriptor frame, @Nullable int[] hitBreakpoints, @Nullable List<? extends ObjectDescriptor> objects, @NotNull V8Vm vm) {
        block7: {
            Intrinsics.checkParameterIsNotNull((Object)eventName, (String)"eventName");
            Intrinsics.checkParameterIsNotNull((Object)frame, (String)"frame");
            Intrinsics.checkParameterIsNotNull((Object)vm, (String)"vm");
            scriptId = frame.getScriptId();
            var9_8 = eventName;
            switch (var9_8.hashCode()) {
                case 1481625679: {
                    if (!var9_8.equals("exception")) ** break;
                    break;
                }
                case -995321554: {
                    if (!var9_8.equals("paused")) ** break;
                    ** GOTO lbl15
                }
                case 94001407: {
                    if (!var9_8.equals("break")) ** break;
lbl15:
                    // 2 sources

                    context = new V8SuspendContext(scriptId, vm, vm.getBreakpointManager().findRelatedBreakpoints(scriptId, frame.getLine(), frame.getColumn(), hitBreakpoints), false, 8, null);
                    break block7;
                }
            }
            context = new V8SuspendContext(scriptId, vm, null, false, 12, null);
            v0 = event;
            if (v0 == null) {
                Intrinsics.throwNpe();
            }
            v1 = breakData;
            if (v1 == null) {
                Intrinsics.throwNpe();
            }
            context.setExceptionData(BreakEventHandlerKt.createException(v0, v1, (V8ValueManager)context.getValueManager()));
            break block7;
            throw (Throwable)new IllegalStateException();
        }
        ((V8ValueManager)context.getValueManager()).store(objects);
        vm.getSuspendContextManager().loadScriptIfNeedSetContextAndNotify(context, frame);
    }

    private static final ExceptionData createException(IncomingMessage response, BreakEventBody body, V8ValueManager valueLoader) {
        ValueHandle valueHandle = body.exception();
        if (valueHandle == null) {
            Intrinsics.throwNpe();
        }
        ValueHandle exception = valueHandle;
        if (!UtilKt.isNullOrEmpty(response.refs())) {
            List<SomeHandle> list = response.refs();
            if (list == null) {
                Intrinsics.throwNpe();
            }
            for (SomeHandle handle : list) {
                valueLoader.addHandleFromRefs(handle);
            }
        }
        return (ExceptionData)new V8ExceptionData(valueLoader.addHandleFromRefs(exception), body.uncaught(), body.sourceLineText(), exception.text());
    }

    @NotNull
    public static final /* synthetic */ ExceptionData access$createException(@NotNull IncomingMessage response, @NotNull BreakEventBody body, @NotNull V8ValueManager valueLoader) {
        return BreakEventHandlerKt.createException(response, body, valueLoader);
    }
}

