/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.wip;

import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.ObjectProperty;
import org.jetbrains.debugger.ObjectPropertyImpl;
import org.jetbrains.debugger.ValueModifier;
import org.jetbrains.debugger.Variable;
import org.jetbrains.debugger.VariableImpl;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.values.FunctionValue;
import org.jetbrains.debugger.values.PrimitiveValue;
import org.jetbrains.debugger.values.Value;
import org.jetbrains.debugger.values.ValueType;
import org.jetbrains.debugger.values.VmAwareValueManager;
import org.jetbrains.jsonProtocol.Request;
import org.jetbrains.wip.WipCommandProcessor;
import org.jetbrains.wip.WipFunction;
import org.jetbrains.wip.WipObject;
import org.jetbrains.wip.WipPrimitiveValue;
import org.jetbrains.wip.WipVm;
import org.jetbrains.wip.WipWorker;
import org.jetbrains.wip.protocol.runtime.PropertyDescriptor;
import org.jetbrains.wip.protocol.runtime.RemoteObjectValue;
import org.jetbrains.wip.protocol.runtime.RuntimeKt;

public class WipValueManager
extends VmAwareValueManager<WipVm> {
    private final String objectGroupId;
    @Nullable
    private final WipWorker myWorker;

    public WipValueManager(@NotNull WipVm vm) {
        if (vm == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vm", "org/jetbrains/wip/WipValueManager", "<init>"));
        }
        this(vm, null);
    }

    public WipValueManager(@NotNull WipVm vm, @Nullable String objectGroupId) {
        if (vm == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vm", "org/jetbrains/wip/WipValueManager", "<init>"));
        }
        this(vm, objectGroupId, null);
    }

    public WipValueManager(@NotNull WipVm vm, @Nullable String objectGroupId, @Nullable WipWorker worker) {
        if (vm == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vm", "org/jetbrains/wip/WipValueManager", "<init>"));
        }
        super((Vm)vm);
        this.objectGroupId = objectGroupId;
        this.myWorker = worker;
    }

    @Nullable
    String getObjectGroupId() {
        return this.objectGroupId;
    }

    @NotNull
    public WipCommandProcessor getCommandProcessor() {
        WipCommandProcessor wipCommandProcessor = this.myWorker != null ? this.myWorker.getCommandProcessor() : ((WipVm)this.getVm()).getCommandProcessor();
        if (wipCommandProcessor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/wip/WipValueManager", "getCommandProcessor"));
        }
        return wipCommandProcessor;
    }

    @Nullable
    public WipWorker getWorker() {
        return this.myWorker;
    }

    public void clearCaches() {
        super.clearCaches();
        if (this.objectGroupId != null) {
            this.getCommandProcessor().send((Request)RuntimeKt.ReleaseObjectGroup(this.objectGroupId));
        }
    }

    @NotNull
    public ObjectProperty createProperty(@NotNull PropertyDescriptor descriptor, @NotNull ValueModifier valueModifier) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/wip/WipValueManager", "createProperty"));
        }
        if (valueModifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueModifier", "org/jetbrains/wip/WipValueManager", "createProperty"));
        }
        int flags = 0;
        if (descriptor.getWritable()) {
            flags |= 1;
        }
        if (descriptor.getConfigurable()) {
            flags |= 2;
        }
        if (descriptor.getEnumerable()) {
            flags |= 4;
        }
        ObjectPropertyImpl objectPropertyImpl = new ObjectPropertyImpl(descriptor.name(), this.createValue(descriptor.getValue()), this.createValueAccessor(descriptor.getGet()), this.createValueAccessor(descriptor.getSet()), valueModifier, flags);
        if (objectPropertyImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/wip/WipValueManager", "createProperty"));
        }
        return objectPropertyImpl;
    }

    @Nullable
    private FunctionValue createValueAccessor(@Nullable RemoteObjectValue remoteObjectValue) {
        return remoteObjectValue == null || remoteObjectValue.type() != RemoteObjectValue.Type.FUNCTION ? null : (FunctionValue)this.createValue(remoteObjectValue);
    }

    @NotNull
    public Variable createVariable(@NotNull String name, @Nullable RemoteObjectValue valueData, @Nullable ValueModifier valueModifier) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/wip/WipValueManager", "createVariable"));
        }
        VariableImpl variableImpl = new VariableImpl(name, this.createValue(valueData), valueModifier);
        if (variableImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/wip/WipValueManager", "createVariable"));
        }
        return variableImpl;
    }

    @Contract(value="null -> null")
    public Value createValue(@Nullable RemoteObjectValue valueData) {
        if (valueData == null) {
            return null;
        }
        RemoteObjectValue.Type protocolType = valueData.type();
        switch (protocolType) {
            case OBJECT: {
                ValueType subType = WipValueManager.protocolSubTypeToSdk(valueData.getSubtype());
                switch (subType) {
                    case ARRAY: 
                    case OBJECT: 
                    case NODE: {
                        return new WipObject(subType, valueData, this);
                    }
                    case NULL: {
                        return PrimitiveValue.NULL;
                    }
                }
                throw new IllegalArgumentException();
            }
            case FUNCTION: {
                return new WipFunction(valueData, this);
            }
            case UNDEFINED: {
                return PrimitiveValue.UNDEFINED;
            }
            case NUMBER: {
                return new WipPrimitiveValue(ValueType.NUMBER, valueData.getDescription());
            }
            case STRING: {
                return new WipPrimitiveValue(ValueType.STRING, (String)valueData.value());
            }
            case BOOLEAN: {
                return PrimitiveValue.bool((String)((String)valueData.value()));
            }
        }
        throw new IllegalArgumentException();
    }

    private static ValueType protocolSubTypeToSdk(@Nullable RemoteObjectValue.Subtype subtype) {
        if (subtype == null) {
            return ValueType.OBJECT;
        }
        switch (subtype) {
            case ARRAY: {
                return ValueType.ARRAY;
            }
            case NULL: {
                return ValueType.NULL;
            }
            case NODE: {
                return ValueType.NODE;
            }
        }
        return ValueType.OBJECT;
    }
}

