/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.wip;

import com.intellij.openapi.util.Pair;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.WebWorker;
import org.jetbrains.debugger.WorkerManagerBase;
import org.jetbrains.io.JsonReaderEx;
import org.jetbrains.jsonProtocol.EventType;
import org.jetbrains.jsonProtocol.Request;
import org.jetbrains.wip.WipBreakpoint;
import org.jetbrains.wip.WipBreakpointManager;
import org.jetbrains.wip.WipBreakpointManagerKt;
import org.jetbrains.wip.WipCommandProcessor;
import org.jetbrains.wip.WipServiceWorkerCommandProcessor;
import org.jetbrains.wip.WipVm;
import org.jetbrains.wip.WipWorker;
import org.jetbrains.wip.WipWorkerManagerKt$sam$Function$11a829ec;
import org.jetbrains.wip.protocol.console.ConsoleKt;
import org.jetbrains.wip.protocol.debugger.DebuggerKt;
import org.jetbrains.wip.protocol.debugger.LocationValue;
import org.jetbrains.wip.protocol.runtime.RuntimeKt;
import org.jetbrains.wip.protocol.serviceworker.DispatchMessageEventData;
import org.jetbrains.wip.protocol.serviceworker.WorkerCreatedEventData;
import org.jetbrains.wip.protocol.worker.DispatchMessageFromWorkerEventData;
import org.jetbrains.wip.protocol.worker.WorkerKt;
import org.jetbrains.wip.protocol.worker.WorkerTerminatedEventData;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0013H\u0002J\u0010\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0013H\u0002J\u0016\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001fJ\u000e\u0010 \u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020!J\u0016\u0010\"\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020#2\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010$\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020%J\u000e\u0010&\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020'R \u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR2\u0010\u000b\u001a#\u0012\f\u0012\n \r*\u0004\u0018\u00010\u00070\u0007\u0012\f\u0012\n \r*\u0004\u0018\u00010\u000e0\u000e0\f\u00a2\u0006\u0002\b\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0012\u001a#\u0012\f\u0012\n \r*\u0004\u0018\u00010\u00070\u0007\u0012\f\u0012\n \r*\u0004\u0018\u00010\u00130\u00130\f\u00a2\u0006\u0002\b\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0011\u00a8\u0006("}, d2={"Lorg/jetbrains/wip/WipWorkerManager;", "Lorg/jetbrains/debugger/WorkerManagerBase;", "vm", "Lorg/jetbrains/wip/WipVm;", "(Lorg/jetbrains/wip/WipVm;)V", "activeWorkers", "", "", "Lorg/jetbrains/debugger/WebWorker;", "getActiveWorkers", "()Ljava/util/Map;", "serviceWorkers", "Ljava/util/concurrent/ConcurrentMap;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/wip/WipServiceWorkerCommandProcessor;", "Lorg/jetbrains/annotations/NotNull;", "getServiceWorkers", "()Ljava/util/concurrent/ConcurrentMap;", "workers", "Lorg/jetbrains/wip/WipWorker;", "getWorkers", "enableWorkerDebugging", "", "worker", "registerWorkerBreakpoints", "serviceWorkerCreated", "data", "Lorg/jetbrains/wip/protocol/serviceworker/WorkerCreatedEventData;", "parentCommandProcessor", "Lorg/jetbrains/wip/WipCommandProcessor;", "serviceWorkerMessageReceived", "Lorg/jetbrains/wip/protocol/serviceworker/DispatchMessageEventData;", "serviceWorkerTerminated", "Lorg/jetbrains/wip/protocol/serviceworker/WorkerTerminatedEventData;", "workerCreated", "Lorg/jetbrains/wip/protocol/worker/WorkerCreatedEventData;", "workerMessageReceived", "Lorg/jetbrains/wip/protocol/worker/DispatchMessageFromWorkerEventData;", "workerTerminated", "Lorg/jetbrains/wip/protocol/worker/WorkerTerminatedEventData;", "wip-backend"})
public final class WipWorkerManager
extends WorkerManagerBase {
    @NotNull
    private final ConcurrentMap<String, WipWorker> workers;
    @NotNull
    private final ConcurrentMap<String, WipServiceWorkerCommandProcessor> serviceWorkers;
    private final WipVm vm;

    @NotNull
    public final ConcurrentMap<String, WipWorker> getWorkers() {
        return this.workers;
    }

    @NotNull
    public final ConcurrentMap<String, WipServiceWorkerCommandProcessor> getServiceWorkers() {
        return this.serviceWorkers;
    }

    public final void workerCreated(@NotNull org.jetbrains.wip.protocol.worker.WorkerCreatedEventData data, @NotNull WipCommandProcessor parentCommandProcessor) {
        Unit unit;
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Intrinsics.checkParameterIsNotNull((Object)((Object)parentCommandProcessor), (String)"parentCommandProcessor");
        String id = data.workerId();
        WipWorker wipWorker = (WipWorker)this.workers.remove(id);
        if (wipWorker != null) {
            wipWorker.terminate();
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        WipWorker worker = new WipWorker(id, data.url(), this.vm, parentCommandProcessor);
        this.workers.put(id, worker);
        this.enableWorkerDebugging(worker);
    }

    private final void enableWorkerDebugging(WipWorker worker) {
        worker.getCommandProcessor().send((Request)ConsoleKt.Enable());
        worker.getCommandProcessor().send((Request)DebuggerKt.Enable()).then(new Function<? super T, ? extends SUB_RESULT>(this, worker){
            final /* synthetic */ WipWorkerManager this$0;
            final /* synthetic */ WipWorker $worker;

            public final void fun(Unit it) {
                WipWorkerManager.access$registerWorkerBreakpoints(this.this$0, this.$worker);
            }
            {
                this.this$0 = wipWorkerManager;
                this.$worker = wipWorker;
            }
        });
        worker.getCommandProcessor().send((Request)RuntimeKt.Run());
    }

    /*
     * WARNING - void declaration
     */
    public final void serviceWorkerCreated(@NotNull WorkerCreatedEventData data, @NotNull WipCommandProcessor parentCommandProcessor) {
        void value$iv;
        void key$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Intrinsics.checkParameterIsNotNull((Object)((Object)parentCommandProcessor), (String)"parentCommandProcessor");
        WipServiceWorkerCommandProcessor commandProcessor2 = new WipServiceWorkerCommandProcessor(data.workerId(), parentCommandProcessor);
        commandProcessor2.getEventMap().add((EventType)org.jetbrains.wip.protocol.worker.WorkerCreatedEventData.TYPE, (Function1)new Function1<org.jetbrains.wip.protocol.worker.WorkerCreatedEventData, Unit>(this, commandProcessor2){
            final /* synthetic */ WipWorkerManager this$0;
            final /* synthetic */ WipServiceWorkerCommandProcessor $commandProcessor;

            public final void invoke(@NotNull org.jetbrains.wip.protocol.worker.WorkerCreatedEventData it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                this.this$0.workerCreated(it, this.$commandProcessor);
            }
            {
                this.this$0 = wipWorkerManager;
                this.$commandProcessor = wipServiceWorkerCommandProcessor;
                super(1);
            }
        });
        commandProcessor2.getEventMap().add((EventType)DispatchMessageFromWorkerEventData.TYPE, (Function1)new Function1<DispatchMessageFromWorkerEventData, Unit>(this){
            final /* synthetic */ WipWorkerManager this$0;

            public final void invoke(@NotNull DispatchMessageFromWorkerEventData it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                this.this$0.workerMessageReceived(it);
            }
            {
                this.this$0 = wipWorkerManager;
                super(1);
            }
        });
        commandProcessor2.send((Request)ConsoleKt.Enable());
        commandProcessor2.send((Request)WorkerKt.SetAutoconnectToWorkers(true));
        commandProcessor2.send((Request)WorkerKt.Enable());
        commandProcessor2.send((Request)RuntimeKt.Run());
        Map map = this.serviceWorkers;
        String string = data.workerId();
        WipServiceWorkerCommandProcessor wipServiceWorkerCommandProcessor = commandProcessor2;
        $receiver$iv.put(key$iv, value$iv);
    }

    private final void registerWorkerBreakpoints(WipWorker worker) {
        Iterable $receiver$iv = this.vm.getBreakpointManager().getBreakpoints();
        for (Object element$iv : $receiver$iv) {
            WipBreakpoint it;
            WipBreakpoint breakpoint = it = (WipBreakpoint)((Object)element$iv);
            Promise<Pair<String, List<LocationValue>>> promise2 = WipBreakpointManagerKt.sendSetBreakpointRequest(it.getTarget(), it.getLine(), it.getColumn(), it.getCondition(), worker.getCommandProcessor());
            WipBreakpointManager wipBreakpointManager = this.vm.getBreakpointManager();
            WipBreakpoint wipBreakpoint = breakpoint;
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)wipBreakpoint), (String)"breakpoint");
            Function1<Pair<String, List<? extends LocationValue>>, WipBreakpoint> function1 = wipBreakpointManager.breakpointResolvedHandler(wipBreakpoint);
            promise2.then((Function)(function1 == null ? null : new WipWorkerManagerKt$sam$Function$11a829ec(function1)));
        }
    }

    public final void workerTerminated(@NotNull WorkerTerminatedEventData data) {
        Unit unit;
        WipWorker worker;
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        String id = data.workerId();
        WipWorker wipWorker = worker = (WipWorker)this.workers.remove(id);
        if (wipWorker != null) {
            wipWorker.terminate();
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
    }

    public final void serviceWorkerTerminated(@NotNull org.jetbrains.wip.protocol.serviceworker.WorkerTerminatedEventData data) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        this.serviceWorkers.remove(data.workerId());
    }

    public final void workerMessageReceived(@NotNull DispatchMessageFromWorkerEventData data) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        String workerId = data.workerId();
        Object object = (WipWorker)this.workers.get(workerId);
        if (object == null || (object = ((WipWorker)object).getCommandProcessor()) == null) {
            return;
        }
        Object processor = object;
        ((WipCommandProcessor)((Object)processor)).processIncomingJson(new JsonReaderEx((CharSequence)data.message()));
    }

    public final void serviceWorkerMessageReceived(@NotNull DispatchMessageEventData data) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        WipServiceWorkerCommandProcessor wipServiceWorkerCommandProcessor = (WipServiceWorkerCommandProcessor)((Object)this.serviceWorkers.get(data.workerId()));
        if (wipServiceWorkerCommandProcessor == null) {
            return;
        }
        WipServiceWorkerCommandProcessor processor = wipServiceWorkerCommandProcessor;
        processor.processIncomingJson(new JsonReaderEx((CharSequence)data.message()));
    }

    @NotNull
    public Map<String, WebWorker> getActiveWorkers() {
        Map map = this.workers;
        Intrinsics.checkExpressionValueIsNotNull((Object)map, (String)"workers");
        return map;
    }

    public WipWorkerManager(@NotNull WipVm vm) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)vm), (String)"vm");
        this.vm = vm;
        this.workers = ContainerUtil.newConcurrentMap();
        this.serviceWorkers = ContainerUtil.newConcurrentMap();
    }

    public static final /* synthetic */ void access$registerWorkerBreakpoints(WipWorkerManager $this, @NotNull WipWorker worker) {
        $this.registerWorkerBreakpoints(worker);
    }
}

