/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.integration.diagram;

import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.spring.perspectives.diagrams.beans.SpringBeanPointerWrapper;
import icons.SpringIntegrationIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class SpringIntegrationBeanPointerWrapper
extends SpringBeanPointerWrapper {
    private SpringIntegrationBeanPointerWrapper(@NotNull SpringBeanPointer pointer) {
        if (pointer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointer", "com/intellij/spring/integration/diagram/SpringIntegrationBeanPointerWrapper", "<init>"));
        }
        super(pointer);
    }

    public static SpringIntegrationBeanPointerWrapper create(SpringBeanPointer pointer) {
        return new SpringIntegrationBeanPointerWrapper(pointer);
    }

    public String getName() {
        return "";
    }

    public Icon getIcon() {
        SpringBeanPointer wrapped = (SpringBeanPointer)this.getWrapped();
        if (wrapped.isValid()) {
            CommonSpringBean bean = wrapped.getSpringBean();
            if (bean instanceof DomSpringBean) {
                return ((DomSpringBean)bean).getPresentation().getIcon();
            }
            if (bean.getBeanClass() != null && "org.springframework.integration.channel.DirectChannel".equals(bean.getBeanClass().getQualifiedName())) {
                return SpringIntegrationIcons.Diagram.Channel;
            }
        }
        return super.getIcon();
    }
}

