/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.integration.model;

import com.intellij.openapi.module.Module;
import com.intellij.spring.integration.model.DefaultChannels;
import com.intellij.spring.integration.util.SpringIntegrationUtil;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringImplicitBeansProviderBase;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class SpringIntegrationDefaultChannelBeansProvider
extends SpringImplicitBeansProviderBase {
    public boolean accepts(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/integration/model/SpringIntegrationDefaultChannelBeansProvider", "accepts"));
        }
        return SpringIntegrationUtil.isSpringIntegrationUsed(module);
    }

    @NotNull
    public String getProviderName() {
        if ("Spring Integration" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/integration/model/SpringIntegrationDefaultChannelBeansProvider", "getProviderName"));
        }
        return "Spring Integration";
    }

    protected Collection<CommonSpringBean> getImplicitBeans(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/integration/model/SpringIntegrationDefaultChannelBeansProvider", "getImplicitBeans"));
        }
        HashSet beans = ContainerUtil.newHashSet();
        for (DefaultChannels channel : DefaultChannels.values()) {
            this.addImplicitLibraryBean(beans, module, channel.classname, channel.name);
        }
        return beans;
    }
}

