/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.integration.model.xml.fake;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.contexts.model.XmlSpringModel;
import com.intellij.spring.integration.model.jam.SpringIntegrationJamHeader;
import com.intellij.spring.integration.model.xml.core.Chain;
import com.intellij.spring.integration.model.xml.core.Gateway;
import com.intellij.spring.integration.model.xml.core.GatewayMethod;
import com.intellij.spring.integration.model.xml.core.Header;
import com.intellij.spring.integration.model.xml.core.HeaderEnricherType;
import com.intellij.spring.integration.model.xml.core.HeaderSubElement;
import com.intellij.spring.integration.model.xml.core.HeaderValueRouterType;
import com.intellij.spring.integration.model.xml.core.InboundChannelAdapter;
import com.intellij.spring.integration.model.xml.core.UserDefinedHeader;
import com.intellij.spring.integration.model.xml.fake.SpringIntegrationHeadersFactory;
import com.intellij.spring.integration.util.SpringIntegrationJamUtil;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.util.ArrayUtil;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomUtil;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringIntegrationHeaderPsiReference
extends PsiReferenceBase<PsiElement> {
    private final String myHeaderName;
    private final Module myModule;
    private final NullableFunction<SpringIntegrationJamHeader, String> HEADER_NAME_FUNCTION;

    public SpringIntegrationHeaderPsiReference(@NotNull PsiElement element, @NotNull String roleName, @NotNull Module module) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/integration/model/xml/fake/SpringIntegrationHeaderPsiReference", "<init>"));
        }
        if (roleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roleName", "com/intellij/spring/integration/model/xml/fake/SpringIntegrationHeaderPsiReference", "<init>"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/integration/model/xml/fake/SpringIntegrationHeaderPsiReference", "<init>"));
        }
        super(element, TextRange.from((int)element.getText().indexOf(roleName), (int)roleName.length()));
        this.HEADER_NAME_FUNCTION = new NullableFunction<SpringIntegrationJamHeader, String>(){

            @Nullable
            public String fun(SpringIntegrationJamHeader springIntegrationHeader) {
                String name = springIntegrationHeader.getName();
                return StringUtil.isEmptyOrSpaces((String)name) ? null : name;
            }
        };
        this.myHeaderName = roleName;
        this.myModule = module;
    }

    public PsiElement resolve() {
        if (StringUtil.isEmptyOrSpaces((String)this.myHeaderName)) {
            return null;
        }
        return SpringIntegrationHeadersFactory.getInstance(this.myModule).getOrCreateHeader(this.myHeaderName, this.getElement().getContainingFile());
    }

    public boolean isSoft() {
        return true;
    }

    @NotNull
    public Object[] getVariants() {
        HashSet headers = new HashSet();
        this.addDomConfiguredHeaders((Set<String>)headers);
        this.addJamHeaders((Set<String>)headers);
        Object[] objectArray = ArrayUtil.toObjectArray((Collection)headers);
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/integration/model/xml/fake/SpringIntegrationHeaderPsiReference", "getVariants"));
        }
        return objectArray;
    }

    private void addJamHeaders(Set<String> headers) {
        List<SpringIntegrationJamHeader> jamHeaders = SpringIntegrationJamUtil.getJamHeaders(this.myModule);
        headers.addAll(ContainerUtil.mapNotNull(jamHeaders, this.HEADER_NAME_FUNCTION));
    }

    private void addDomConfiguredHeaders(@NotNull Set<String> headers) {
        if (headers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "headers", "com/intellij/spring/integration/model/xml/fake/SpringIntegrationHeaderPsiReference", "addDomConfiguredHeaders"));
        }
        for (SpringModel springModel : SpringManager.getInstance((Project)this.myModule.getProject()).getAllModels(this.myModule)) {
            if (!(springModel instanceof XmlSpringModel)) continue;
            for (DomFileElement beansFileElement : ((XmlSpringModel)springModel).getLocalModelsRoots()) {
                Beans beans = (Beans)beansFileElement.getRootElement();
                for (Gateway gateway : DomUtil.getChildrenOfType((DomElement)beans, Gateway.class)) {
                    for (GatewayMethod gatewayMethod : gateway.getMethods()) {
                        for (Header header : gatewayMethod.getHeaders()) {
                            ContainerUtil.addIfNotNull(headers, (Object)header.getName().getStringValue());
                        }
                    }
                }
                for (InboundChannelAdapter adapter : DomUtil.getChildrenOfType((DomElement)beans, InboundChannelAdapter.class)) {
                    for (HeaderSubElement headerSubElement : adapter.getHeaders()) {
                        ContainerUtil.addIfNotNull(headers, (Object)headerSubElement.getName().getStringValue());
                    }
                }
                for (Chain chain : DomUtil.getChildrenOfType((DomElement)beans, Chain.class)) {
                    for (HeaderValueRouterType headerValueRouterType : chain.getHeaderValueRouters()) {
                        ContainerUtil.addIfNotNull(headers, (Object)headerValueRouterType.getHeaderName().getStringValue());
                    }
                    for (HeaderEnricherType headerEnricherType : chain.getHeaderEnrichers()) {
                        for (UserDefinedHeader userDefinedHeader : headerEnricherType.getHeaders()) {
                            ContainerUtil.addIfNotNull(headers, (Object)userDefinedHeader.getName().getStringValue());
                        }
                    }
                }
                for (HeaderEnricherType headerEnricherType : DomUtil.getChildrenOfType((DomElement)beans, HeaderEnricherType.class)) {
                    for (UserDefinedHeader userDefinedHeader : headerEnricherType.getHeaders()) {
                        ContainerUtil.addIfNotNull(headers, (Object)userDefinedHeader.getName().getStringValue());
                    }
                }
            }
        }
    }
}

