/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.velocity.editorActions;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.Language;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.BaseScopeProcessor;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.velocity.Icons;
import com.intellij.velocity.VtlReferenceContributor;
import com.intellij.velocity.editorActions.TypeInferenceUtil;
import com.intellij.velocity.editorActions.VtlDirectiveInsertHandler;
import com.intellij.velocity.psi.PsiUtil;
import com.intellij.velocity.psi.VtlDirectiveHeader;
import com.intellij.velocity.psi.VtlElementTypes;
import com.intellij.velocity.psi.VtlImplicitVariable;
import com.intellij.velocity.psi.VtlLanguage;
import com.intellij.velocity.psi.VtlMacro;
import com.intellij.velocity.psi.VtlParameterDeclaration;
import com.intellij.velocity.psi.VtlVariable;
import com.intellij.velocity.psi.directives.VtlDirective;
import com.intellij.velocity.psi.directives.VtlSet;
import com.intellij.velocity.psi.files.VtlFile;
import com.intellij.velocity.psi.reference.VtlReferenceExpression;
import com.intellij.velocity.psi.reference.VtlVariantsProcessor;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class VtlCompletionContributor
extends CompletionContributor {
    public VtlCompletionContributor() {
        this.registerInferredClassNameCompletionProvider();
    }

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        int offset;
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/velocity/editorActions/VtlCompletionContributor", "fillCompletionVariants"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/velocity/editorActions/VtlCompletionContributor", "fillCompletionVariants"));
        }
        PsiFile file = parameters.getPosition().getContainingFile();
        FileViewProvider viewProvider = file.getViewProvider();
        PsiElement vtlLeaf = viewProvider.findElementAt(parameters.getOffset(), (Language)VtlLanguage.INSTANCE);
        if (vtlLeaf == null) {
            return;
        }
        VtlCompletionContributor.addMacroParameterNames(result, vtlLeaf);
        String fileText = file.getText();
        for (offset = parameters.getOffset() - 1; offset > 0 && (Character.isJavaIdentifierPart(fileText.charAt(offset)) || fileText.charAt(offset) == '-'); --offset) {
        }
        boolean braceNeeded = false;
        if (offset > 0 && fileText.charAt(offset) == '{') {
            braceNeeded = true;
            --offset;
        }
        boolean allowDirectives = true;
        if (offset > 0 && fileText.charAt(offset) == '@') {
            allowDirectives = false;
            --offset;
        }
        if (offset >= 0 && fileText.charAt(offset) == '#') {
            if (parameters.getCompletionType() == CompletionType.BASIC) {
                result.stopHere();
                if (allowDirectives) {
                    VtlCompletionContributor.addStandardDirectives(result, braceNeeded, vtlLeaf);
                }
                VtlCompletionContributor.addMacros(result, braceNeeded, vtlLeaf);
            }
        } else {
            VtlReferenceExpression ref = (VtlReferenceExpression)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)parameters.getOffset(), VtlReferenceExpression.class, (boolean)false);
            if (ref != null) {
                if (parameters.getCompletionType() == CompletionType.SMART && !(ref.getParent() instanceof VtlSet)) {
                    return;
                }
                result.stopHere();
                int refNameStart = ref.getRangeInElement().getStartOffset() + ref.getTextRange().getStartOffset();
                boolean lowerCase = refNameStart == parameters.getOffset() || !StringUtil.isCapitalized((String)ref.getReferenceName());
                result.addAllElements(ref.getVariants(parameters.getCompletionType() == CompletionType.SMART, lowerCase));
            }
        }
        super.fillCompletionVariants(parameters, result);
    }

    private static void addMacroParameterNames(final @NotNull CompletionResultSet result, PsiElement vtlLeaf) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/velocity/editorActions/VtlCompletionContributor", "addMacroParameterNames"));
        }
        if (!((PsiElementPattern.Capture)PlatformPatterns.psiElement((IElementType)VtlElementTypes.IDENTIFIER).withParents(new Class[]{VtlParameterDeclaration.class, VtlDirectiveHeader.class, VtlMacro.class})).accepts((Object)vtlLeaf)) {
            return;
        }
        VtlMacro macro = (VtlMacro)PsiTreeUtil.getParentOfType((PsiElement)vtlLeaf, VtlMacro.class);
        assert (macro != null);
        final Set usedNames = ContainerUtil.map2Set((Object[])macro.getParameters(), (Function)new Function<VtlVariable, String>(){

            public String fun(VtlVariable variable) {
                return variable.getName();
            }
        });
        vtlLeaf.getContainingFile().processDeclarations((PsiScopeProcessor)new BaseScopeProcessor(){

            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/velocity/editorActions/VtlCompletionContributor$2", "execute"));
                }
                if (state == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/velocity/editorActions/VtlCompletionContributor$2", "execute"));
                }
                if (element instanceof VtlImplicitVariable && !usedNames.contains(((VtlImplicitVariable)element).getName())) {
                    result.addElement((LookupElement)LookupElementBuilder.create((String)((VtlImplicitVariable)element).getName()));
                }
                return true;
            }
        }, ResolveState.initial(), null, vtlLeaf);
    }

    private static void addMacros(CompletionResultSet result, boolean closingBraceNeeded, PsiElement vtlLeaf) {
        VtlFile containingFile = (VtlFile)vtlLeaf.getContainingFile();
        VtlVariantsProcessor<PsiNamedElement> processor = new VtlVariantsProcessor<PsiNamedElement>(vtlLeaf, false){

            @Override
            protected PsiNamedElement execute(PsiNamedElement element, boolean error) {
                return element;
            }
        };
        processor.setMacroCall(true);
        containingFile.processAllMacrosInScope((PsiScopeProcessor)processor, ResolveState.initial());
        result.addAllElements(VtlReferenceExpression.convertToLookupElements(processor, closingBraceNeeded, true));
    }

    private static void addStandardDirectives(CompletionResultSet result, boolean closingBraceNeeded, PsiElement vtlLeaf) {
        VtlDirective directiveAtOffset = (VtlDirective)PsiTreeUtil.getParentOfType((PsiElement)vtlLeaf, VtlDirective.class, (boolean)true);
        PsiElement vtlParent = directiveAtOffset != null && directiveAtOffset.getFirstChild() == vtlLeaf ? directiveAtOffset.getParent() : vtlLeaf.getParent();
        for (String name : VtlDirective.DIRECTIVE_NAMES) {
            if (!VtlDirective.Validator.isAllowed(vtlParent, name)) continue;
            VtlDirectiveInsertHandler insertHandler = new VtlDirectiveInsertHandler(closingBraceNeeded, VtlDirective.Validator.areParenthesesNeeded(name));
            result.addElement((LookupElement)LookupElementBuilder.create((String)name).withIcon(Icons.SHARP_ICON).bold().withInsertHandler((InsertHandler)insertHandler));
        }
    }

    private void registerInferredClassNameCompletionProvider() {
        this.extend(CompletionType.SMART, (ElementPattern)VtlReferenceContributor.VTLVARIABLE_COMMENT, (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet _result) {
                if (parameters == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/velocity/editorActions/VtlCompletionContributor$4", "addCompletions"));
                }
                if (_result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "_result", "com/intellij/velocity/editorActions/VtlCompletionContributor$4", "addCompletions"));
                }
                PsiComment element = (PsiComment)parameters.getPosition();
                String text = element.getText();
                TextRange typeNameRange = VtlReferenceContributor.findTypeNameRange(text);
                int offset = parameters.getOffset() - element.getTextRange().getStartOffset();
                if (typeNameRange != null && typeNameRange.contains(offset)) {
                    CompletionResultSet result = _result.withPrefixMatcher(text.substring(typeNameRange.getStartOffset(), offset));
                    VtlFile originalFile = (VtlFile)parameters.getOriginalFile();
                    String[] varNameAndTypeAndScopeFilePath = VtlFile.findVariableNameAndTypeAndScopeFilePath(text);
                    assert (varNameAndTypeAndScopeFilePath != null);
                    VtlImplicitVariable originalVariable = originalFile.findImplicitVariable(varNameAndTypeAndScopeFilePath[0], varNameAndTypeAndScopeFilePath[2]);
                    assert (originalVariable != null);
                    Collection<String> types = TypeInferenceUtil.inferVariableType(originalVariable);
                    this.addInferredTypeItems(element, result, types);
                }
            }

            private void addInferredTypeItems(PsiComment element, CompletionResultSet result, Collection<String> typeNames) {
                for (String typeName : typeNames) {
                    LookupElement lookupElement = PsiUtil.createPsiTypeLookupElement((PsiElement)element, typeName);
                    if (lookupElement == null) continue;
                    result.addElement(lookupElement);
                }
            }
        });
    }
}

