/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.velocity.psi.reference;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.util.SimpleMethodCallLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.AbstractQualifiedReference;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.beanProperties.BeanProperty;
import com.intellij.psi.impl.beanProperties.BeanPropertyElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.velocity.Icons;
import com.intellij.velocity.VelocityBundle;
import com.intellij.velocity.editorActions.VtlDirectiveInsertHandler;
import com.intellij.velocity.psi.PsiUtil;
import com.intellij.velocity.psi.VtlCallable;
import com.intellij.velocity.psi.VtlElementTypes;
import com.intellij.velocity.psi.VtlExpression;
import com.intellij.velocity.psi.VtlImplicitVariable;
import com.intellij.velocity.psi.VtlIndexExpression;
import com.intellij.velocity.psi.VtlMacro;
import com.intellij.velocity.psi.VtlMethodCallExpression;
import com.intellij.velocity.psi.VtlVariable;
import com.intellij.velocity.psi.directives.FixedNameVariable;
import com.intellij.velocity.psi.directives.VtlAssignment;
import com.intellij.velocity.psi.directives.VtlMacroCall;
import com.intellij.velocity.psi.files.VtlFile;
import com.intellij.velocity.psi.reference.VelocityNamingUtil;
import com.intellij.velocity.psi.reference.VtlMethod;
import com.intellij.velocity.psi.reference.VtlVariantsProcessor;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VtlReferenceExpression
extends AbstractQualifiedReference<VtlReferenceExpression>
implements VtlExpression {
    public VtlReferenceExpression(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/velocity/psi/reference/VtlReferenceExpression", "<init>"));
        }
        super(node);
    }

    protected boolean processVariantsInner(PsiScopeProcessor processor) {
        PsiClass psiClass;
        VtlExpression qualifier = this.getQualifierInner();
        if (qualifier == null) {
            PsiElement parent = this.getParent();
            if (parent instanceof VtlMacroCall) {
                VtlFile containingFile = ((VtlMacroCall)parent).getContainingFile();
                return containingFile.processAllMacrosInScope(processor, ResolveState.initial());
            }
            return this.processUnqualifiedVariants(processor);
        }
        PsiType type = qualifier.getPsiType();
        if (type instanceof PsiClassType ? (psiClass = com.intellij.psi.util.PsiUtil.resolveClassInType((PsiType)type)) != null && !psiClass.processDeclarations(processor, ResolveState.initial(), null, (PsiElement)this) : type instanceof PsiArrayType && (psiClass = JavaPsiFacade.getInstance((Project)this.getProject()).findClass("java.util.List", this.getResolveScope())) != null && !psiClass.processDeclarations(processor, ResolveState.initial(), null, (PsiElement)this)) {
            return false;
        }
        PsiElement psiElement = qualifier instanceof VtlReferenceExpression ? ((VtlReferenceExpression)qualifier).resolve() : null;
        return psiElement == null || psiElement.processDeclarations(processor, ResolveState.initial(), null, (PsiElement)this);
    }

    public boolean hasQualifier() {
        return this.getQualifierInner() != null;
    }

    public boolean isQualifierResolved() {
        VtlExpression qualifier = this.getQualifierInner();
        return !(qualifier instanceof VtlReferenceExpression) || ((VtlReferenceExpression)qualifier).resolve() != null;
    }

    @Nullable
    private VtlExpression getQualifierInner() {
        for (PsiElement child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child instanceof VtlReferenceExpression || child instanceof VtlIndexExpression) {
                return (VtlExpression)child;
            }
            if (!(child instanceof VtlMethodCallExpression)) continue;
            return ((VtlMethodCallExpression)child).getReferenceExpression();
        }
        return null;
    }

    @Nullable
    public VtlReferenceExpression getParentReferenceExpression() {
        PsiElement parent = this.getParent();
        if (parent instanceof VtlReferenceExpression) {
            return (VtlReferenceExpression)parent;
        }
        return null;
    }

    protected ResolveResult[] resolveInner() {
        VtlAssignment assignment;
        VtlVariable var;
        String referenceName = this.getReferenceName();
        if (referenceName == null) {
            return ResolveResult.EMPTY_ARRAY;
        }
        PsiElement parent = this.getParent();
        if (parent instanceof VtlAssignment && (var = (assignment = (VtlAssignment)parent).getAssignedVariable(FixedNameVariable.getReferenceScope(this))) != null && assignment.getAssignedVariableElement(FixedNameVariable.getReferenceScope(this)) == this) {
            return new ResolveResult[]{new PsiElementResolveResult((PsiElement)var)};
        }
        VtlVariantsProcessor<ResolveResult> processor = new VtlVariantsProcessor<ResolveResult>(parent, referenceName, false, this.getQualifierClassType()){

            @Override
            protected ResolveResult execute(PsiNamedElement element, boolean error) {
                if (element instanceof BeanPropertyElement) {
                    return new PsiElementResolveResult((PsiElement)((BeanPropertyElement)element).getMethod());
                }
                return new PsiElementResolveResult((PsiElement)element, !error);
            }
        };
        this.processVariantsInner((PsiScopeProcessor)processor);
        return processor.getVariants(ResolveResult.EMPTY_ARRAY, Character.isLowerCase(referenceName.charAt(0)));
    }

    @NotNull
    public String getUnresolvedMessage(boolean resolvedWithError) {
        String referenceName = this.getReferenceName();
        PsiElement parent = this.getParent();
        if (parent instanceof VtlMacroCall) {
            String msgKey = resolvedWithError ? "error.wrong.number.of.arguments.for.macro" : "error.cannot.resolve.macro";
            String string = VelocityBundle.message(msgKey, referenceName);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/velocity/psi/reference/VtlReferenceExpression", "getUnresolvedMessage"));
            }
            return string;
        }
        VtlExpression qualifier = this.getQualifierInner();
        if (qualifier == null) {
            String string = VelocityBundle.message("error.cannot.resolve.variable", referenceName);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/velocity/psi/reference/VtlReferenceExpression", "getUnresolvedMessage"));
            }
            return string;
        }
        String typeName = PsiUtil.getPresentableText(qualifier.getPsiType());
        if (!(parent instanceof VtlMethodCallExpression)) {
            String string = VelocityBundle.message("error.cannot.resolve.property", referenceName, typeName);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/velocity/psi/reference/VtlReferenceExpression", "getUnresolvedMessage"));
            }
            return string;
        }
        if (!resolvedWithError) {
            String string = VelocityBundle.message("error.cannot.resolve.method", referenceName, typeName);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/velocity/psi/reference/VtlReferenceExpression", "getUnresolvedMessage"));
            }
            return string;
        }
        String argumentTypes = StringUtil.join((Object[])((VtlMethodCallExpression)parent).getArgumentTypes(), (Function)new Function<PsiType, String>(){

            public String fun(PsiType psiType) {
                return PsiUtil.getPresentableText(psiType);
            }
        }, (String)", ");
        String string = VelocityBundle.message("error.no.applicable.method", referenceName, typeName, "(" + argumentTypes + ")");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/velocity/psi/reference/VtlReferenceExpression", "getUnresolvedMessage"));
        }
        return string;
    }

    @NotNull
    protected VtlReferenceExpression parseReference(String newText) {
        String propertyName;
        if (!(this.getParent() instanceof VtlMethodCallExpression) && (propertyName = VelocityNamingUtil.getPropertyName(newText, this.isFirstCharInLowerCase())) != null) {
            newText = propertyName;
        }
        VtlReferenceExpression vtlReferenceExpression = PsiUtil.createVtlReferenceExpression(newText, this.getProject());
        if (vtlReferenceExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/velocity/psi/reference/VtlReferenceExpression", "parseReference"));
        }
        return vtlReferenceExpression;
    }

    protected PsiElement getSeparator() {
        return this.findChildByType(VtlElementTypes.JAVA_DOT);
    }

    public String toString() {
        return this.getNode().getElementType().toString();
    }

    public PsiElement getReferenceNameElement() {
        return this.findChildByType(VtlElementTypes.IDENTIFIER);
    }

    public boolean isReferenceTo(PsiElement element) {
        PsiManagerEx manager = this.getManager();
        for (ResolveResult result : this.multiResolve(false)) {
            PsiElement target = result.getElement();
            if (manager.areElementsEquivalent(element, target)) {
                return true;
            }
            if (target instanceof BeanPropertyElement && manager.areElementsEquivalent(element, (PsiElement)((BeanPropertyElement)target).getMethod())) {
                return true;
            }
            if (element instanceof VtlMacro && target instanceof FixedNameVariable) {
                return manager.areElementsEquivalent(((FixedNameVariable)target).getTargetElement(), element);
            }
            if (!(element instanceof VtlImplicitVariable) || !(target instanceof VtlVariable) || target instanceof VtlImplicitVariable || !manager.areElementsEquivalent(element, (PsiElement)VtlImplicitVariable.findImplicitCounterpart((VtlVariable)target))) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public LookupElement[] getVariants() {
        if (LookupElement.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/velocity/psi/reference/VtlReferenceExpression", "getVariants"));
        }
        return LookupElement.EMPTY_ARRAY;
    }

    public List<LookupElement> getVariants(boolean propertiesOnly, boolean lowerCase) {
        VtlVariantsProcessor<PsiNamedElement> processor = new VtlVariantsProcessor<PsiNamedElement>(this.getParent(), propertiesOnly){

            @Override
            protected PsiNamedElement execute(PsiNamedElement element, boolean error) {
                return element;
            }
        };
        this.processVariantsInner((PsiScopeProcessor)processor);
        return VtlReferenceExpression.convertToLookupElements(processor, ((PsiElementPattern.Capture)PlatformPatterns.psiElement().afterLeaf(new String[]{"{"})).accepts((Object)this.getElement()), lowerCase);
    }

    public static List<LookupElement> convertToLookupElements(VtlVariantsProcessor<PsiNamedElement> processor, final boolean macroCallInBraces, boolean lowerCase) {
        Object[] variants = processor.getVariants((PsiNamedElement[])PsiNamedElement.EMPTY_ARRAY, lowerCase);
        return ContainerUtil.map2List((Object[])variants, (Function)new Function<PsiNamedElement, LookupElement>(){

            public LookupElement fun(PsiNamedElement element) {
                PsiType type;
                if (element instanceof PsiMethod) {
                    return new SimpleMethodCallLookupElement((PsiMethod)element);
                }
                LookupElementBuilder lookupElement = LookupElementBuilder.create((PsiNamedElement)element);
                if (element instanceof VtlMacro) {
                    return lookupElement.withInsertHandler((InsertHandler)new VtlDirectiveInsertHandler(macroCallInBraces, true)).withIcon(Icons.SHARP_ICON);
                }
                if (element instanceof VtlVariable) {
                    PsiType type2 = ((VtlVariable)element).getPsiType();
                    if (type2 != null) {
                        lookupElement = lookupElement.withTypeText(type2.getPresentableText());
                    }
                } else if (element instanceof BeanPropertyElement && (type = ((BeanPropertyElement)element).getPropertyType()) != null) {
                    lookupElement = lookupElement.withTypeText(type.getPresentableText());
                }
                if (element instanceof ItemPresentation) {
                    lookupElement = lookupElement.withIcon(((ItemPresentation)element).getIcon(false));
                }
                return lookupElement;
            }
        });
    }

    protected boolean isFirstCharInLowerCase() {
        String referenceName = this.getReferenceName();
        return referenceName == null || Character.isLowerCase(referenceName.charAt(0));
    }

    @NotNull
    public VtlCallable[] getCallableCandidates() {
        final String referenceName = this.getReferenceName();
        if (referenceName == null) {
            if (VtlCallable.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/velocity/psi/reference/VtlReferenceExpression", "getCallableCandidates"));
            }
            return VtlCallable.EMPTY_ARRAY;
        }
        VtlVariantsProcessor<VtlCallable> processor = new VtlVariantsProcessor<VtlCallable>(this.getParent(), false){

            @Override
            protected VtlCallable execute(PsiNamedElement element, boolean error) {
                if (!referenceName.equals(element.getName())) {
                    return null;
                }
                if (element instanceof VtlMacro) {
                    return (VtlMacro)element;
                }
                if (element instanceof PsiMethod) {
                    return new VtlMethod((PsiMethod)element);
                }
                return null;
            }
        };
        this.processVariantsInner((PsiScopeProcessor)processor);
        VtlCallable[] vtlCallableArray = processor.getVariants(VtlCallable.EMPTY_ARRAY, Character.isLowerCase(referenceName.charAt(0)));
        if (vtlCallableArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/velocity/psi/reference/VtlReferenceExpression", "getCallableCandidates"));
        }
        return vtlCallableArray;
    }

    @Override
    @Nullable
    public PsiType getPsiType() {
        PsiElement element = this.resolve();
        if (element instanceof VtlVariable) {
            return ((VtlVariable)element).getPsiType();
        }
        if (element instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)element;
            return this.getSubstitutedType(method, method.getReturnType());
        }
        if (element instanceof BeanProperty) {
            BeanProperty beanProperty = (BeanProperty)element;
            return this.getSubstitutedType(beanProperty.getMethod(), beanProperty.getPropertyType());
        }
        return null;
    }

    public PsiType getSubstitutedType(PsiMethod method, PsiType type) {
        if (!(type instanceof PsiClassType)) {
            return type;
        }
        PsiClass containingClass = method.getContainingClass();
        PsiClassType classType = this.getQualifierClassType();
        if (containingClass != null && classType != null) {
            return TypeConversionUtil.getSuperClassSubstitutor((PsiClass)containingClass, (PsiClassType)classType).substitute(type);
        }
        return type;
    }

    @Nullable
    private PsiClassType getQualifierClassType() {
        PsiType type;
        VtlExpression qualifier = this.getQualifierInner();
        if (qualifier != null && (type = qualifier.getPsiType()) instanceof PsiClassType) {
            return (PsiClassType)type;
        }
        return null;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        CheckUtil.checkWritable((PsiElement)this);
        PsiElement newReferenceName = this.parseReference(newElementName).getReferenceNameElement();
        this.getNode().replaceChild(this.getReferenceNameElement().getNode(), newReferenceName.getNode());
        return this;
    }
}

