/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.contexts.chooser;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetManagerAdapter;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.contexts.chooser.SpringContextDescriptor;
import com.intellij.spring.contexts.chooser.SpringMultipleContextsManager;
import com.intellij.spring.contexts.chooser.SpringMultipleContextsPanel;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.options.SpringEditorOptions;
import com.intellij.ui.EditorNotifications;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SpringMultipleContextsEditorNotification
extends EditorNotifications.Provider<SpringMultipleContextsPanel> {
    private final Project myProject;
    private static final Key<SpringMultipleContextsPanel> KEY = Key.create((String)"SpringMultipleContextsManager");

    public SpringMultipleContextsEditorNotification(Project project) {
        this.myProject = project;
        project.getMessageBus().connect((Disposable)project).subscribe(FacetManager.FACETS_TOPIC, (Object)new FacetManagerAdapter(){

            public void facetAdded(@NotNull Facet facet) {
                if (facet == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/intellij/spring/contexts/chooser/SpringMultipleContextsEditorNotification$1", "facetAdded"));
                }
                this.facetChanged(facet);
            }

            public void facetRemoved(@NotNull Facet facet) {
                if (facet == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/intellij/spring/contexts/chooser/SpringMultipleContextsEditorNotification$1", "facetRemoved"));
                }
                this.facetChanged(facet);
            }

            public void facetConfigurationChanged(@NotNull Facet facet) {
                if (facet == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/intellij/spring/contexts/chooser/SpringMultipleContextsEditorNotification$1", "facetConfigurationChanged"));
                }
                this.facetChanged(facet);
            }

            private void facetChanged(Facet facet) {
                if (facet.getTypeId() == SpringFacet.FACET_TYPE_ID) {
                    EditorNotifications.getInstance((Project)SpringMultipleContextsEditorNotification.this.myProject).updateAllNotifications();
                }
            }
        });
    }

    @NotNull
    public Key<SpringMultipleContextsPanel> getKey() {
        Key<SpringMultipleContextsPanel> key = KEY;
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/chooser/SpringMultipleContextsEditorNotification", "getKey"));
        }
        return key;
    }

    public SpringMultipleContextsPanel createNotificationPanel(final @NotNull VirtualFile file, @NotNull FileEditor fileEditor) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/spring/contexts/chooser/SpringMultipleContextsEditorNotification", "createNotificationPanel"));
        }
        if (fileEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileEditor", "com/intellij/spring/contexts/chooser/SpringMultipleContextsEditorNotification", "createNotificationPanel"));
        }
        if (!SpringEditorOptions.getInstance().isShowMultipleContextsPanel()) {
            return null;
        }
        if (DumbService.isDumb((Project)this.myProject)) {
            DumbService.getInstance((Project)this.myProject).smartInvokeLater(new Runnable(){

                @Override
                public void run() {
                    EditorNotifications.getInstance((Project)SpringMultipleContextsEditorNotification.this.myProject).updateNotifications(file);
                }
            });
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(file);
        if (!(psiFile instanceof XmlFile)) {
            return null;
        }
        if (!SpringDomUtils.isSpringXml((XmlFile)((XmlFile)psiFile))) {
            return null;
        }
        List<SpringContextDescriptor> descriptors = SpringMultipleContextsManager.getInstance().getAllContextDescriptors(psiFile);
        if (!descriptors.isEmpty()) {
            ArrayList<SpringContextDescriptor> allDescriptors = new ArrayList<SpringContextDescriptor>();
            allDescriptors.add(SpringContextDescriptor.LOCAL_CONTEXT);
            allDescriptors.add(SpringContextDescriptor.ALL_CONTEXTS);
            allDescriptors.addAll(descriptors);
            SpringContextDescriptor currentContext = SpringMultipleContextsEditorNotification.getUpdatedCurrentContext(psiFile, allDescriptors);
            return new SpringMultipleContextsPanel(psiFile, allDescriptors, currentContext);
        }
        return null;
    }

    @NotNull
    private static SpringContextDescriptor getUpdatedCurrentContext(PsiFile psiFile, List<SpringContextDescriptor> allDescriptors) {
        SpringContextDescriptor cachedDescriptor = SpringMultipleContextsManager.getInstance().getCachedContextDescriptor(psiFile);
        if (cachedDescriptor == null) {
            SpringContextDescriptor springContextDescriptor = SpringMultipleContextsManager.getInstance().getContextDescriptor(psiFile);
            if (springContextDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/chooser/SpringMultipleContextsEditorNotification", "getUpdatedCurrentContext"));
            }
            return springContextDescriptor;
        }
        for (SpringContextDescriptor existing : allDescriptors) {
            if (!cachedDescriptor.getQualifiedName().equals(existing.getQualifiedName())) continue;
            SpringContextDescriptor springContextDescriptor = existing;
            if (springContextDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/chooser/SpringMultipleContextsEditorNotification", "getUpdatedCurrentContext"));
            }
            return springContextDescriptor;
        }
        SpringContextDescriptor springContextDescriptor = SpringContextDescriptor.DEFAULT;
        if (springContextDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/chooser/SpringMultipleContextsEditorNotification", "getUpdatedCurrentContext"));
        }
        return springContextDescriptor;
    }
}

