/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.contexts.model;

import com.intellij.openapi.module.Module;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.contexts.model.CombinedSpringModel;
import com.intellij.spring.contexts.model.LocalModel;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.util.Processor;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CombinedSpringModelImpl
extends SpringModel
implements CombinedSpringModel {
    private final Set<CommonSpringModel> myModels;

    public CombinedSpringModelImpl(@NotNull LocalModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/spring/contexts/model/CombinedSpringModelImpl", "<init>"));
        }
        this(Collections.singleton(model), model.getModule());
    }

    public CombinedSpringModelImpl(@NotNull Set<? extends CommonSpringModel> models, @Nullable Module module) {
        if (models == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "models", "com/intellij/spring/contexts/model/CombinedSpringModelImpl", "<init>"));
        }
        super(module);
        this.myModels = new LinkedHashSet<CommonSpringModel>(models.size());
        this.myModels.addAll(models);
    }

    public CombinedSpringModelImpl(@NotNull Set<SpringModel> models, @NotNull Module module, @Nullable SpringFileSet fileSet) {
        if (models == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "models", "com/intellij/spring/contexts/model/CombinedSpringModelImpl", "<init>"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/contexts/model/CombinedSpringModelImpl", "<init>"));
        }
        super(module, fileSet);
        this.myModels = new LinkedHashSet<CommonSpringModel>(models.size());
        this.myModels.addAll(models);
    }

    public Set<CommonSpringModel> getUnderlyingModels() {
        return this.getModelsToProcess(true);
    }

    @NotNull
    public Set<CommonSpringModel> getModelsToProcess(boolean checkActiveProfiles) {
        LinkedHashSet<CommonSpringModel> models = new LinkedHashSet<CommonSpringModel>();
        models.addAll(this.myModels);
        models.addAll(this.getDependencies());
        LinkedHashSet<CommonSpringModel> linkedHashSet = models;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/CombinedSpringModelImpl", "getModelsToProcess"));
        }
        return linkedHashSet;
    }

    @NotNull
    public Set<String> getAllProfiles() {
        final HashSet<String> profiles = new HashSet<String>();
        this.processModels((Processor)new Processor<CommonSpringModel>(){

            public boolean process(CommonSpringModel model) {
                profiles.addAll(model.getAllProfiles());
                return true;
            }
        });
        HashSet<String> hashSet = profiles;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/CombinedSpringModelImpl", "getAllProfiles"));
        }
        return hashSet;
    }

    @Nullable
    public Set<String> getActiveProfiles() {
        final HashSet<String> profiles = new HashSet<String>();
        this.processModels((Processor)new Processor<CommonSpringModel>(){

            public boolean process(CommonSpringModel model) {
                Set activeProfiles = model.getActiveProfiles();
                if (activeProfiles != null) {
                    profiles.addAll(activeProfiles);
                }
                return true;
            }
        });
        return profiles;
    }

    public String toString() {
        return "CombinedSpringModel[" + this.getModule().getName() + ", #" + this.myModels.size() + "]";
    }
}

