/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.contexts.model;

import com.intellij.jam.JamService;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PackageScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.contexts.model.AbstractSimpleLocalModel;
import com.intellij.spring.contexts.model.LocalAnnotationModel;
import com.intellij.spring.contexts.model.LocalModel;
import com.intellij.spring.contexts.model.graph.LocalModelDependency;
import com.intellij.spring.contexts.model.graph.LocalModelDependencyType;
import com.intellij.spring.impl.SpringCachedModelFactory;
import com.intellij.spring.model.BeanService;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringProfile;
import com.intellij.spring.model.jam.JamPsiMemberSpringBean;
import com.intellij.spring.model.jam.SpringJamModel;
import com.intellij.spring.model.jam.stereotype.CustomSpringComponent;
import com.intellij.spring.model.jam.stereotype.SpringComponentScan;
import com.intellij.spring.model.jam.stereotype.SpringConfiguration;
import com.intellij.spring.model.jam.utils.SpringJamUtils;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringProfileUtils;
import com.intellij.spring.model.xml.context.SpringBeansPackagesScan;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalAnnotationModelImpl
extends LocalAnnotationModel {
    @NotNull
    private final PsiClass myClass;
    @NotNull
    private final Module myModule;
    private Set<String> myActiveProfiles;
    private CachedValue<Set<CommonSpringModel>> myLocalRelatedModels;

    public LocalAnnotationModelImpl(@NotNull PsiClass aClass, @NotNull Module module) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/spring/contexts/model/LocalAnnotationModelImpl", "<init>"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/contexts/model/LocalAnnotationModelImpl", "<init>"));
        }
        this.myActiveProfiles = ContainerUtil.newLinkedHashSet();
        this.myClass = aClass;
        this.myModule = module;
    }

    @NotNull
    public PsiClass getConfig() {
        PsiClass psiClass = this.myClass;
        if (psiClass == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/LocalAnnotationModelImpl", "getConfig"));
        }
        return psiClass;
    }

    protected Collection<SpringBeanPointer> calculateLocalBeans() {
        Set beans = (Set)RecursionManager.createGuard((String)"LocalAnnotationModel#calculateAllBeans").doPreventingRecursion((Object)this.myClass, true, (Computable)new Computable<Set<SpringBeanPointer>>(){

            public Set<SpringBeanPointer> compute() {
                LinkedHashSet allBeans = ContainerUtil.newLinkedHashSet();
                ContainerUtil.addIfNotNull((Collection)allBeans, (Object)LocalAnnotationModelImpl.getBeanForClass(LocalAnnotationModelImpl.this.myClass));
                allBeans.addAll(SpringJamUtils.getInstance().getContextBeans(LocalAnnotationModelImpl.this.myClass, LocalAnnotationModelImpl.this.getActiveProfiles()));
                return BeanService.getInstance().mapSpringBeans((Collection)allBeans);
            }
        });
        return beans == null ? Collections.emptySet() : beans;
    }

    @Nullable
    private static CommonSpringBean getBeanForClass(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/spring/contexts/model/LocalAnnotationModelImpl", "getBeanForClass"));
        }
        JamPsiMemberSpringBean psiMemberSpringBean = (JamPsiMemberSpringBean)JamService.getJamService((Project)aClass.getProject()).getJamElement(JamPsiMemberSpringBean.PSI_MEMBER_SPRING_BEAN_JAM_KEY, (PsiElement)aClass);
        if (psiMemberSpringBean != null) {
            return psiMemberSpringBean;
        }
        if (!aClass.isInterface() && !aClass.hasModifierProperty("abstract") && SpringCommonUtils.isSpringBeanCandidateClass((PsiClass)aClass)) {
            return new CustomSpringComponent(aClass);
        }
        return null;
    }

    public Iterable<CommonSpringModel> getRelatedModels() {
        LinkedHashSet models = ContainerUtil.newLinkedHashSet();
        models.addAll(this.getOrCreateLocalRelatedModels());
        models.add(this.getCustomDiscoveredBeansModel());
        return models;
    }

    @NotNull
    private Set<CommonSpringModel> getOrCreateLocalRelatedModels() {
        if (this.myLocalRelatedModels == null) {
            this.myLocalRelatedModels = CachedValuesManager.getManager((Project)this.getConfig().getProject()).createCachedValue((CachedValueProvider)new CachedValueProvider<Set<CommonSpringModel>>(){

                public CachedValueProvider.Result<Set<CommonSpringModel>> compute() {
                    LinkedHashSet models = ContainerUtil.newLinkedHashSet();
                    Set localModels = LocalAnnotationModelImpl.this.getRelatedLocalModels();
                    models.addAll(localModels);
                    models.addAll(LocalAnnotationModelImpl.this.getPackageScanModels(localModels));
                    return CachedValueProvider.Result.create((Object)models, (Object[])ArrayUtil.mergeArrays((Object[])LocalAnnotationModelImpl.this.getOutsideModelDependencies((LocalModel)LocalAnnotationModelImpl.this), (Object[])LocalAnnotationModelImpl.this.getConfigs(localModels)));
                }
            }, false);
        }
        Set set = (Set)this.myLocalRelatedModels.getValue();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/LocalAnnotationModelImpl", "getOrCreateLocalRelatedModels"));
        }
        return set;
    }

    @NotNull
    private Set<CommonSpringModel> getPackageScanModels(@NotNull Set<LocalModel> localRelatedModels) {
        if (localRelatedModels == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localRelatedModels", "com/intellij/spring/contexts/model/LocalAnnotationModelImpl", "getPackageScanModels"));
        }
        LinkedHashSet packageScanContextModels = ContainerUtil.newLinkedHashSet();
        packageScanContextModels.add(this);
        packageScanContextModels.addAll(localRelatedModels);
        Set set = this.getPackageScanModels(packageScanContextModels, this.myModule, this.myActiveProfiles);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/LocalAnnotationModelImpl", "getPackageScanModels"));
        }
        return set;
    }

    @NotNull
    public Module getModule() {
        Module module = this.myModule;
        if (module == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/LocalAnnotationModelImpl", "getModule"));
        }
        return module;
    }

    @NotNull
    public Set<String> getAllProfiles() {
        LinkedHashSet allProfiles = ContainerUtil.newLinkedHashSet();
        SpringConfiguration configuration = this.getConfiguration();
        if (configuration != null) {
            allProfiles.addAll(configuration.getProfile().getNames());
        }
        JamService service = JamService.getJamService((Project)this.myModule.getProject());
        for (PsiClass psiClass : SpringJamUtils.getInstance().getImportedClasses(this.myClass, this.getModule())) {
            for (SpringConfiguration springConfiguration : service.getAnnotatedMembersList(psiClass, SpringConfiguration.JAM_KEY, true, false, false, true)) {
                allProfiles.addAll(springConfiguration.getProfile().getNames());
            }
        }
        LinkedHashSet linkedHashSet = allProfiles;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/LocalAnnotationModelImpl", "getAllProfiles"));
        }
        return linkedHashSet;
    }

    @NotNull
    public Set<PsiFile> getConfigFiles() {
        LinkedHashSet files = ContainerUtil.newLinkedHashSet();
        if (this.myClass.isValid()) {
            files.add(this.myClass.getContainingFile());
            files.addAll(SpringJamUtils.getInstance().getImportedResources(this.myClass, new Module[]{this.myModule}));
        }
        LinkedHashSet linkedHashSet = files;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/LocalAnnotationModelImpl", "getConfigFiles"));
        }
        return linkedHashSet;
    }

    public boolean hasConfigFile(@NotNull PsiFile configFile) {
        if (configFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configFile", "com/intellij/spring/contexts/model/LocalAnnotationModelImpl", "hasConfigFile"));
        }
        if (!this.myClass.isValid()) {
            return false;
        }
        if (this.myClass.getContainingFile().equals(configFile)) {
            return true;
        }
        return configFile instanceof XmlFile && SpringJamUtils.getInstance().getImportedResources(this.myClass, new Module[]{this.myModule}).contains(configFile);
    }

    @Nullable
    public SpringConfiguration getConfiguration() {
        return (SpringConfiguration)JamService.getJamService((Project)this.myClass.getProject()).getJamElement(SpringConfiguration.JAM_KEY, (PsiElement)this.myClass);
    }

    @NotNull
    public List<SpringBeansPackagesScan> getComponentScans() {
        List list = SpringJamUtils.getInstance().getComponentScans(this.myClass);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/LocalAnnotationModelImpl", "getComponentScans"));
        }
        return list;
    }

    public void setActiveProfiles(@NotNull Set<String> activeProfiles) {
        if (activeProfiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "activeProfiles", "com/intellij/spring/contexts/model/LocalAnnotationModelImpl", "setActiveProfiles"));
        }
        this.myActiveProfiles = activeProfiles;
    }

    @NotNull
    public Set<String> getActiveProfiles() {
        Set<String> set = this.myActiveProfiles;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/LocalAnnotationModelImpl", "getActiveProfiles"));
        }
        return set;
    }

    @NotNull
    public Set<Pair<LocalModel, LocalModelDependency>> getDependentLocalModels() {
        final Module module = this.getModule();
        if (module.isDisposed()) {
            Set<Pair<LocalModel, LocalModelDependency>> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/LocalAnnotationModelImpl", "getDependentLocalModels"));
            }
            return set;
        }
        final LinkedHashSet models = ContainerUtil.newLinkedHashSet();
        SpringJamUtils.getInstance().processImportedResources(this.myClass, (Processor)new Processor<Pair<List<XmlFile>, ? extends PsiElement>>(){

            public boolean process(Pair<List<XmlFile>, ? extends PsiElement> pair) {
                for (XmlFile xmlFile : (List)pair.first) {
                    AbstractSimpleLocalModel.addNotNullModel((Set)models, (LocalModel)SpringCachedModelFactory.getOrCreateLocalXmlModel(xmlFile, module, LocalAnnotationModelImpl.this.getActiveProfiles()), (LocalModelDependency)LocalModelDependency.create((LocalModelDependencyType)LocalModelDependencyType.IMPORT, (PsiElement)((PsiElement)pair.second)));
                }
                return true;
            }
        }, new Module[]{this.myModule});
        SpringJamUtils.getInstance().processImportedClasses(this.myClass, (Processor)new Processor<Pair<PsiClass, ? extends PsiElement>>(){

            public boolean process(Pair<PsiClass, ? extends PsiElement> pair) {
                AbstractSimpleLocalModel.addNotNullModel((Set)models, (LocalModel)LocalAnnotationModelImpl.this.getLocalAnnotationModel((PsiClass)pair.first), (LocalModelDependency)LocalModelDependency.create((LocalModelDependencyType)LocalModelDependencyType.IMPORT, (PsiElement)((PsiElement)pair.second)));
                return true;
            }
        });
        LocalAnnotationModelImpl.processScannedConfigurations(this.myClass, new Processor<Pair<PsiPackage, ? extends PsiElement>>(){

            public boolean process(Pair<PsiPackage, ? extends PsiElement> pair) {
                if (module.isDisposed()) {
                    return false;
                }
                GlobalSearchScope moduleScope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
                GlobalSearchScope searchScope = moduleScope.intersectWith(PackageScope.packageScope((PsiPackage)((PsiPackage)pair.first), (boolean)true));
                List configurations = SpringJamModel.getModel((Module)module).getConfigurations(searchScope);
                for (SpringConfiguration configuration : configurations) {
                    if (!SpringProfileUtils.isProfileAccepted((SpringProfile)configuration.getProfile(), LocalAnnotationModelImpl.this.getActiveProfiles())) continue;
                    PsiElement identifyingElementForDependency = (PsiElement)pair.second;
                    AbstractSimpleLocalModel.addNotNullModel((Set)models, (LocalModel)LocalAnnotationModelImpl.this.getLocalAnnotationModel(configuration), (LocalModelDependency)LocalModelDependency.create((LocalModelDependencyType)LocalModelDependencyType.COMPONENT_SCAN, (PsiElement)(identifyingElementForDependency == null ? (PsiElement)pair.first : identifyingElementForDependency)));
                }
                return true;
            }
        });
        SpringJamUtils.getInstance().processCustomAnnotations(this.myClass, (Processor)new Processor<Pair<PsiClass, LocalModelDependency>>(){

            public boolean process(Pair<PsiClass, LocalModelDependency> enableAnnotation) {
                AbstractSimpleLocalModel.addNotNullModel((Set)models, (LocalModel)LocalAnnotationModelImpl.this.getLocalAnnotationModel((PsiClass)enableAnnotation.getFirst()), (LocalModelDependency)((LocalModelDependency)enableAnnotation.getSecond()));
                return true;
            }
        });
        SpringJamUtils.getInstance().processCustomDependentLocalModels((LocalAnnotationModel)this, (PairProcessor)new PairProcessor<LocalModel, LocalModelDependency>(){

            public boolean process(LocalModel model, LocalModelDependency dependency) {
                AbstractSimpleLocalModel.addNotNullModel((Set)models, (LocalModel)model, (LocalModelDependency)dependency);
                return true;
            }
        });
        LinkedHashSet linkedHashSet = models;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/LocalAnnotationModelImpl", "getDependentLocalModels"));
        }
        return linkedHashSet;
    }

    @Nullable
    private LocalAnnotationModel getLocalAnnotationModel(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/spring/contexts/model/LocalAnnotationModelImpl", "getLocalAnnotationModel"));
        }
        return SpringCachedModelFactory.getOrCreateLocalAnnotationModel(aClass, this.getModule(), this.getActiveProfiles());
    }

    @Nullable
    protected LocalAnnotationModel getLocalAnnotationModel(@NotNull SpringConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/spring/contexts/model/LocalAnnotationModelImpl", "getLocalAnnotationModel"));
        }
        return SpringCachedModelFactory.getOrCreateLocalAnnotationModel(configuration, this.getModule(), this.getActiveProfiles());
    }

    private static boolean processScannedConfigurations(@NotNull PsiClass classToProcess, @NotNull Processor<Pair<PsiPackage, ? extends PsiElement>> processor) {
        if (classToProcess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classToProcess", "com/intellij/spring/contexts/model/LocalAnnotationModelImpl", "processScannedConfigurations"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/spring/contexts/model/LocalAnnotationModelImpl", "processScannedConfigurations"));
        }
        for (SpringBeansPackagesScan packagesScan : SpringJamUtils.getInstance().getComponentScans(classToProcess)) {
            if (packagesScan instanceof SpringComponentScan) {
                SpringComponentScan componentScan = (SpringComponentScan)packagesScan;
                if (componentScan.processPsiPackages(processor)) continue;
                return false;
            }
            for (PsiPackage aPackage : packagesScan.getPsiPackages()) {
                if (processor.process((Object)Pair.create((Object)aPackage, (Object)packagesScan.getIdentifyingPsiElement()))) continue;
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LocalAnnotationModelImpl)) {
            return false;
        }
        LocalAnnotationModelImpl model = (LocalAnnotationModelImpl)((Object)o);
        if (!this.myClass.equals(model.myClass)) {
            return false;
        }
        if (!this.myModule.equals(model.myModule)) {
            return false;
        }
        return SpringProfileUtils.profilesAsString(this.myActiveProfiles).equals(SpringProfileUtils.profilesAsString(model.myActiveProfiles));
    }

    public int hashCode() {
        int result = this.myClass.hashCode();
        result = 31 * result + this.myModule.hashCode();
        result = 31 * result + SpringProfileUtils.profilesAsString(this.myActiveProfiles).hashCode();
        return result;
    }
}

