/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.contexts.model;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.VolatileNotNullLazyValue;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedElementsSearch;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringModificationTrackersManager;
import com.intellij.spring.contexts.model.BeanNamesMapper;
import com.intellij.spring.contexts.model.BeansSpringModel;
import com.intellij.spring.contexts.model.ComponentScanPackagesModel;
import com.intellij.spring.contexts.model.LocalModel;
import com.intellij.spring.contexts.model.LocalXmlModel;
import com.intellij.spring.contexts.model.LocalXmlModelIndexProcessor;
import com.intellij.spring.contexts.model.graph.LocalModelDependency;
import com.intellij.spring.contexts.model.graph.LocalModelDependencyType;
import com.intellij.spring.dom.PlaceholderDomReferenceInjector;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.beans.CustomSetting;
import com.intellij.spring.impl.SpringCachedModelFactory;
import com.intellij.spring.model.BeanService;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.jam.javaConfig.SpringJavaBean;
import com.intellij.spring.model.jam.javaConfig.SpringJavaConfiguration;
import com.intellij.spring.model.jam.javaConfig.SpringOldJavaConfigurationUtil;
import com.intellij.spring.model.jam.stereotype.SpringConfiguration;
import com.intellij.spring.model.jam.utils.SpringJamUtils;
import com.intellij.spring.model.utils.SpringBeanUtils;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringProfileUtils;
import com.intellij.spring.model.xml.AbstractDomSpringBean;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.model.xml.beans.SpringImport;
import com.intellij.spring.model.xml.context.SpringBeansPackagesScan;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.xml.util.PsiElementPointer;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalXmlModelImpl
extends LocalXmlModel {
    private final XmlFile myConfigFile;
    private final Module myModule;
    private final LocalXmlModelIndexProcessor myIndexProcessor;
    private final NotNullLazyValue<BeanNamesMapper> myLocalBeanNamesMapper;
    private Set<String> myActiveProfiles;
    private CachedValue<Set<CommonSpringModel>> myLocalRelatedModels;
    private CachedValue<CommonSpringModel> javaConfigurationModel;
    private CachedValue<CommonSpringModel> explicitlyDefinedBeansModel;
    private final NotNullLazyValue<List<SpringBeanPointer>> myPlaceholders;
    private final Map<String, Collection<XmlTag>> myCustomBeanIdCandidates;
    private final AtomicNotNullLazyValue<Set<String>> myProfiles;
    private final NotNullLazyValue<List<SpringBeanPointer>> myAnnotationConfigApplicationContexts;
    private final NotNullLazyValue<List<SpringBeansPackagesScan>> myComponentScanBeans;
    private final NotNullLazyValue<MultiMap<SpringBeanPointer, SpringBeanPointer>> myDirectInheritorsMap;
    private static final Key<CachedValue<Map<XmlFile, LocalModelDependency>>> IMPORT_FILES_KEY = Key.create((String)"IMPORT_FILES_KEY");

    public LocalXmlModelImpl(@NotNull XmlFile configFile, @NotNull Module module) {
        if (configFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configFile", "com/intellij/spring/contexts/model/LocalXmlModelImpl", "<init>"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/contexts/model/LocalXmlModelImpl", "<init>"));
        }
        this.myLocalBeanNamesMapper = new VolatileNotNullLazyValue<BeanNamesMapper>(){

            @NotNull
            protected BeanNamesMapper compute() {
                BeanNamesMapper beanNamesMapper = new BeanNamesMapper(LocalXmlModelImpl.this);
                if (beanNamesMapper == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/LocalXmlModelImpl$1", "compute"));
                }
                return beanNamesMapper;
            }
        };
        this.myPlaceholders = new VolatileNotNullLazyValue<List<SpringBeanPointer>>(){

            @NotNull
            protected List<SpringBeanPointer> compute() {
                List list = LocalXmlModelImpl.this.computePlaceholders();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/LocalXmlModelImpl$2", "compute"));
                }
                return list;
            }
        };
        this.myCustomBeanIdCandidates = new ConcurrentFactoryMap<String, Collection<XmlTag>>(){

            @Nullable
            protected Collection<XmlTag> create(String key) {
                if (!LocalXmlModelImpl.this.canProcessBeans()) {
                    return Collections.emptyList();
                }
                return LocalXmlModelImpl.this.myIndexProcessor.getCustomBeanCandidates(key);
            }
        };
        this.myProfiles = new AtomicNotNullLazyValue<Set<String>>(){

            @NotNull
            protected Set<String> compute() {
                DomFileElement<Beans> element = LocalXmlModelImpl.this.getRoot();
                if (element != null) {
                    HashSet hashSet = new HashSet((Collection)SpringProfileUtils.getAllProfiles((Beans)((Beans)element.getRootElement())));
                    if (hashSet == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/LocalXmlModelImpl$4", "compute"));
                    }
                    return hashSet;
                }
                Set<String> set = Collections.emptySet();
                if (set == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/LocalXmlModelImpl$4", "compute"));
                }
                return set;
            }
        };
        this.myAnnotationConfigApplicationContexts = new VolatileNotNullLazyValue<List<SpringBeanPointer>>(){

            @NotNull
            protected List<SpringBeanPointer> compute() {
                if (!LocalXmlModelImpl.this.canProcessBeans()) {
                    List<SpringBeanPointer> list = Collections.emptyList();
                    if (list == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/LocalXmlModelImpl$5", "compute"));
                    }
                    return list;
                }
                List<SpringBeanPointer> list = LocalXmlModelImpl.this.myIndexProcessor.getAnnotationConfigs(LocalXmlModelImpl.this.getActiveProfiles());
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/LocalXmlModelImpl$5", "compute"));
                }
                return list;
            }
        };
        this.myComponentScanBeans = new VolatileNotNullLazyValue<List<SpringBeansPackagesScan>>(){

            @NotNull
            protected List<SpringBeansPackagesScan> compute() {
                if (!LocalXmlModelImpl.this.canProcessBeans()) {
                    List<SpringBeansPackagesScan> list = Collections.emptyList();
                    if (list == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/LocalXmlModelImpl$6", "compute"));
                    }
                    return list;
                }
                List<SpringBeansPackagesScan> list = LocalXmlModelImpl.this.myIndexProcessor.getComponentScans();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/LocalXmlModelImpl$6", "compute"));
                }
                return list;
            }
        };
        this.myDirectInheritorsMap = new VolatileNotNullLazyValue<MultiMap<SpringBeanPointer, SpringBeanPointer>>(){

            @NotNull
            protected MultiMap<SpringBeanPointer, SpringBeanPointer> compute() {
                MultiMap<SpringBeanPointer, SpringBeanPointer> map = new MultiMap<SpringBeanPointer, SpringBeanPointer>(){

                    @NotNull
                    protected Map<SpringBeanPointer, Collection<SpringBeanPointer>> createMap() {
                        ConcurrentMap concurrentMap = ContainerUtil.newConcurrentMap();
                        if (concurrentMap == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/LocalXmlModelImpl$7$1", "createMap"));
                        }
                        return concurrentMap;
                    }
                };
                for (SpringBeanPointer pointer : LocalXmlModelImpl.this.getAllDomBeans()) {
                    SpringBeanPointer parentPointer = pointer.getParentPointer();
                    if (parentPointer == null) continue;
                    map.putValue((Object)parentPointer.getBasePointer(), (Object)pointer);
                }
                MultiMap<SpringBeanPointer, SpringBeanPointer> multiMap = map;
                if (multiMap == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/LocalXmlModelImpl$7", "compute"));
                }
                return multiMap;
            }
        };
        this.myConfigFile = configFile;
        this.myModule = module;
        this.myIndexProcessor = new LocalXmlModelIndexProcessor(this.myConfigFile, this.myModule);
    }

    @Nullable
    public DomFileElement<Beans> getRoot() {
        return SpringDomUtils.getSpringDomFileElement((XmlFile)this.myConfigFile);
    }

    @NotNull
    public Set<PsiFile> getConfigFiles() {
        Set<XmlFile> set = Collections.singleton(this.myConfigFile);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/LocalXmlModelImpl", "getConfigFiles"));
        }
        return set;
    }

    public boolean hasConfigFile(@NotNull PsiFile configFile) {
        if (configFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configFile", "com/intellij/spring/contexts/model/LocalXmlModelImpl", "hasConfigFile"));
        }
        return this.myConfigFile.equals(configFile);
    }

    private Project getProject() {
        return this.myConfigFile.getProject();
    }

    @NotNull
    public XmlFile getConfig() {
        XmlFile xmlFile = this.myConfigFile;
        if (xmlFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/LocalXmlModelImpl", "getConfig"));
        }
        return xmlFile;
    }

    public Collection<XmlTag> getCustomBeanCandidates(String id) {
        return this.myCustomBeanIdCandidates.get(id);
    }

    private BeanNamesMapper getLocalBeanNamesMapper() {
        return (BeanNamesMapper)this.myLocalBeanNamesMapper.getValue();
    }

    @NotNull
    public Set<String> getAllBeanNames(@NotNull String beanName) {
        if (beanName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beanName", "com/intellij/spring/contexts/model/LocalXmlModelImpl", "getAllBeanNames"));
        }
        THashSet set = new THashSet(this.getLocalBeanNamesMapper().getAllBeanNames(beanName));
        this.processRelatedModels((Processor)new Processor<CommonSpringModel>((Set)set, beanName){
            final /* synthetic */ Set val$set;
            final /* synthetic */ String val$beanName;
            {
                this.val$set = set;
                this.val$beanName = string;
            }

            public boolean process(CommonSpringModel model) {
                this.val$set.addAll(model.getAllBeanNames(this.val$beanName));
                return true;
            }
        });
        THashSet tHashSet = set;
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/LocalXmlModelImpl", "getAllBeanNames"));
        }
        return tHashSet;
    }

    public Collection<PsiElementPointer> getDuplicatedNames(@NotNull String beanName) {
        if (beanName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beanName", "com/intellij/spring/contexts/model/LocalXmlModelImpl", "getDuplicatedNames"));
        }
        return this.getLocalBeanNamesMapper().getDuplicatedNames(beanName);
    }

    protected Collection<SpringBeanPointer> calculateLocalBeans() {
        return Collections.unmodifiableCollection(this.getAllDomBeans());
    }

    public Iterable<CommonSpringModel> getRelatedModels() {
        LinkedHashSet models = ContainerUtil.newLinkedHashSet();
        models.addAll(this.getOrCreateLocalRelatedModels());
        models.add(this.getCustomDiscoveredBeansModel());
        models.add(this.getOldJavaConfigurationBeansModel());
        models.add(this.getExplicitlyDefinedBeansModel());
        return models;
    }

    private Set<CommonSpringModel> getOrCreateLocalRelatedModels() {
        if (this.myLocalRelatedModels == null) {
            this.myLocalRelatedModels = CachedValuesManager.getManager((Project)this.getProject()).createCachedValue((CachedValueProvider)new CachedValueProvider<Set<CommonSpringModel>>(){

                public CachedValueProvider.Result<Set<CommonSpringModel>> compute() {
                    LinkedHashSet models = ContainerUtil.newLinkedHashSet();
                    Set localModels = LocalXmlModelImpl.this.getRelatedLocalModels();
                    models.addAll(localModels);
                    models.addAll(LocalXmlModelImpl.this.getPackageScanModels(localModels));
                    return CachedValueProvider.Result.create((Object)models, (Object[])ArrayUtil.mergeArrays((Object[])LocalXmlModelImpl.this.getOutsideModelDependencies((LocalModel)LocalXmlModelImpl.this), (Object[])LocalXmlModelImpl.this.getConfigs(localModels)));
                }
            }, false);
        }
        return (Set)this.myLocalRelatedModels.getValue();
    }

    @NotNull
    private Set<CommonSpringModel> getPackageScanModels(@NotNull Set<LocalModel> localRelatedModels) {
        if (localRelatedModels == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localRelatedModels", "com/intellij/spring/contexts/model/LocalXmlModelImpl", "getPackageScanModels"));
        }
        LinkedHashSet packageScanContextModels = ContainerUtil.newLinkedHashSet();
        packageScanContextModels.add(this);
        packageScanContextModels.addAll(localRelatedModels);
        Set set = this.getPackageScanModels(packageScanContextModels, this.myModule, this.myActiveProfiles);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/LocalXmlModelImpl", "getPackageScanModels"));
        }
        return set;
    }

    private CommonSpringModel getOldJavaConfigurationBeansModel() {
        if (this.javaConfigurationModel == null) {
            this.javaConfigurationModel = CachedValuesManager.getManager((Project)this.getProject()).createCachedValue((CachedValueProvider)new CachedValueProvider<CommonSpringModel>(){

                public CachedValueProvider.Result<CommonSpringModel> compute() {
                    BeansSpringModel model = new BeansSpringModel(LocalXmlModelImpl.this.getModule(), (NotNullLazyValue)new NotNullLazyValue<Collection<? extends SpringBeanPointer>>(){

                        @NotNull
                        protected Collection<? extends SpringBeanPointer> compute() {
                            LinkedHashSet pointers = ContainerUtil.newLinkedHashSet();
                            for (SpringJavaConfiguration javaConfiguration : SpringOldJavaConfigurationUtil.getJavaConfigurations((Module)LocalXmlModelImpl.this.myModule)) {
                                for (SpringJavaBean javaBean : javaConfiguration.getBeans()) {
                                    if (!javaBean.isPublic()) continue;
                                    pointers.add(BeanService.getInstance().createSpringBeanPointer((CommonSpringBean)javaBean));
                                }
                            }
                            LinkedHashSet linkedHashSet = pointers;
                            if (linkedHashSet == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/LocalXmlModelImpl$10$1", "compute"));
                            }
                            return linkedHashSet;
                        }
                    });
                    return CachedValueProvider.Result.create((Object)model, (Object[])LocalXmlModelImpl.this.getOutsideModelDependencies((LocalModel)LocalXmlModelImpl.this));
                }
            }, false);
        }
        return (CommonSpringModel)this.javaConfigurationModel.getValue();
    }

    @NotNull
    public Collection<SpringBeanPointer> calculateDomBeans() {
        final ArrayList<SpringBeanPointer> beans = new ArrayList<SpringBeanPointer>();
        Processor<CommonSpringBean> processor = new Processor<CommonSpringBean>(){

            public boolean process(CommonSpringBean bean) {
                beans.add(BeanService.getInstance().createSpringBeanPointer(bean));
                return true;
            }
        };
        DomFileElement<Beans> element = this.getRoot();
        if (element != null) {
            this.processDomBeans((Beans)element.getRootElement(), processor);
        }
        ArrayList<SpringBeanPointer> arrayList = beans;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/LocalXmlModelImpl", "calculateDomBeans"));
        }
        return arrayList;
    }

    private void processDomBeans(@NotNull Beans rootElement, Processor<CommonSpringBean> processor) {
        if (rootElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootElement", "com/intellij/spring/contexts/model/LocalXmlModelImpl", "processDomBeans"));
        }
        if (SpringProfileUtils.isActiveProfile((Beans)rootElement, this.getActiveProfiles())) {
            SpringBeanUtils.getInstance().processChildBeans((DomElement)rootElement, false, processor);
            for (Beans profile : rootElement.getBeansProfiles()) {
                this.processDomBeans(profile, processor);
            }
        }
    }

    @NotNull
    public List<SpringBeanPointer> getDescendants(@NotNull SpringBeanPointer pointer) {
        if (pointer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointer", "com/intellij/spring/contexts/model/LocalXmlModelImpl", "getDescendants"));
        }
        THashSet visited = new THashSet();
        visited.add(pointer);
        MultiMap map = (MultiMap)this.myDirectInheritorsMap.getValue();
        LocalXmlModelImpl.addDescendants((MultiMap<SpringBeanPointer, SpringBeanPointer>)map, pointer, (Set<SpringBeanPointer>)visited);
        SmartList smartList = new SmartList((Collection)visited);
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/LocalXmlModelImpl", "getDescendants"));
        }
        return smartList;
    }

    private static void addDescendants(MultiMap<SpringBeanPointer, SpringBeanPointer> map, SpringBeanPointer current, Set<SpringBeanPointer> result) {
        Collection pointers = map.get((Object)current);
        for (SpringBeanPointer pointer : pointers) {
            if (!result.add(pointer)) continue;
            LocalXmlModelImpl.addDescendants(map, pointer, result);
        }
    }

    @NotNull
    public Module getModule() {
        Module module = this.myModule;
        if (module == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/LocalXmlModelImpl", "getModule"));
        }
        return module;
    }

    @NotNull
    public List<SpringBeanPointer> getPlaceholderConfigurers() {
        List list = (List)this.myPlaceholders.getValue();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/LocalXmlModelImpl", "getPlaceholderConfigurers"));
        }
        return list;
    }

    @NotNull
    public List<SpringBeansPackagesScan> getComponentScans() {
        final Set<String> activeProfiles = this.getActiveProfiles();
        List allComponentScans = (List)this.myComponentScanBeans.getValue();
        if (activeProfiles.isEmpty()) {
            List list = allComponentScans;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/LocalXmlModelImpl", "getComponentScans"));
            }
            return list;
        }
        List list = ContainerUtil.mapNotNull((Collection)allComponentScans, (Function)new Function<SpringBeansPackagesScan, SpringBeansPackagesScan>(){

            public SpringBeansPackagesScan fun(SpringBeansPackagesScan scan) {
                if (scan instanceof DomSpringBean && SpringProfileUtils.isInActiveProfile((DomElement)((DomSpringBean)scan), (Set)activeProfiles)) {
                    return scan;
                }
                return null;
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/LocalXmlModelImpl", "getComponentScans"));
        }
        return list;
    }

    @NotNull
    public List<SpringBeanPointer> getAnnotationConfigApplicationContexts() {
        List list = (List)this.myAnnotationConfigApplicationContexts.getValue();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/LocalXmlModelImpl", "getAnnotationConfigApplicationContexts"));
        }
        return list;
    }

    @NotNull
    public Set<String> getAllProfiles() {
        Set set = (Set)this.myProfiles.getValue();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/LocalXmlModelImpl", "getAllProfiles"));
        }
        return set;
    }

    @NotNull
    public Set<String> getActiveProfiles() {
        Set<String> set = this.myActiveProfiles;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/LocalXmlModelImpl", "getActiveProfiles"));
        }
        return set;
    }

    public void setActiveProfiles(@NotNull Set<String> activeProfiles) {
        if (activeProfiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "activeProfiles", "com/intellij/spring/contexts/model/LocalXmlModelImpl", "setActiveProfiles"));
        }
        this.myActiveProfiles = activeProfiles;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LocalXmlModel)) {
            return false;
        }
        LocalXmlModel model = (LocalXmlModel)o;
        if (!this.myConfigFile.equals(model.getConfig())) {
            return false;
        }
        if (!this.myModule.equals(model.getModule())) {
            return false;
        }
        return SpringProfileUtils.profilesAsString(this.myActiveProfiles).equals(SpringProfileUtils.profilesAsString((Set)model.getActiveProfiles()));
    }

    public int hashCode() {
        int result = this.myConfigFile.hashCode();
        result = 31 * result + this.myModule.hashCode();
        result = 31 * result + SpringProfileUtils.profilesAsString(this.myActiveProfiles).hashCode();
        return result;
    }

    public boolean processByClass(@NotNull SpringModelSearchParameters.BeanClass params, @NotNull Processor<SpringBeanPointer> processor) {
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/intellij/spring/contexts/model/LocalXmlModelImpl", "processByClass"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/spring/contexts/model/LocalXmlModelImpl", "processByClass"));
        }
        if (!params.canSearch() || !this.canProcessBeans()) {
            return true;
        }
        if (!this.myIndexProcessor.processByClass(params, processor, this.getActiveProfiles(), false)) {
            return false;
        }
        return this.processRelatedModels(params, processor);
    }

    public boolean processByName(@NotNull SpringModelSearchParameters.BeanName params, @NotNull Processor<SpringBeanPointer> processor) {
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/intellij/spring/contexts/model/LocalXmlModelImpl", "processByName"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/spring/contexts/model/LocalXmlModelImpl", "processByName"));
        }
        if (!params.canSearch() || !this.canProcessBeans()) {
            return true;
        }
        if (!this.myIndexProcessor.processByName(params, processor, this.getActiveProfiles())) {
            return false;
        }
        return this.processRelatedModels(params, processor);
    }

    private boolean canProcessBeans() {
        DomFileElement<Beans> root = this.getRoot();
        return root != null && SpringProfileUtils.isActiveProfile((Beans)((Beans)root.getRootElement()), this.getActiveProfiles());
    }

    @NotNull
    public Set<Pair<LocalModel, LocalModelDependency>> getDependentLocalModels() {
        LinkedHashSet models = ContainerUtil.newLinkedHashSet();
        Set<String> profiles = this.getActiveProfiles();
        for (Map.Entry<XmlFile, LocalModelDependency> importedXml : LocalXmlModelImpl.getImports(this.getConfig(), profiles).entrySet()) {
            LocalXmlModelImpl.addNotNullModel((Set)models, (LocalModel)SpringCachedModelFactory.getOrCreateLocalXmlModel(importedXml.getKey(), this.getModule(), profiles), (LocalModelDependency)importedXml.getValue());
        }
        for (SpringBeansPackagesScan packagesScan : this.getComponentScans()) {
            LocalModelDependency dependency = LocalModelDependency.create((LocalModelDependencyType)LocalModelDependencyType.COMPONENT_SCAN, (PsiElement)packagesScan.getXmlTag().getOriginalElement());
            for (SpringConfiguration configuration : ComponentScanPackagesModel.getScannedConfigurations((SpringBeansPackagesScan)packagesScan, (Module)this.getModule(), profiles)) {
                LocalXmlModelImpl.addNotNullModel((Set)models, (LocalModel)SpringCachedModelFactory.getOrCreateLocalAnnotationModel(configuration, this.getModule(), profiles), (LocalModelDependency)dependency);
            }
        }
        LinkedHashSet linkedHashSet = models;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/LocalXmlModelImpl", "getDependentLocalModels"));
        }
        return linkedHashSet;
    }

    private static Map<XmlFile, LocalModelDependency> getImports(final @NotNull XmlFile file, final @Nullable Set<String> activeProfiles) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/spring/contexts/model/LocalXmlModelImpl", "getImports"));
        }
        return (Map)CachedValuesManager.getManager((Project)file.getProject()).getCachedValue((UserDataHolder)file, IMPORT_FILES_KEY, (CachedValueProvider)new CachedValueProvider<Map<XmlFile, LocalModelDependency>>(){

            public CachedValueProvider.Result<Map<XmlFile, LocalModelDependency>> compute() {
                LinkedHashMap includes = new LinkedHashMap();
                DomFileElement beans = SpringDomUtils.getSpringDomFileElement((XmlFile)file);
                if (beans != null) {
                    LocalXmlModelImpl.processLocalImports(includes, (Beans)beans.getRootElement(), activeProfiles);
                }
                includes.remove(file);
                return CachedValueProvider.Result.create(includes, (Object[])new Object[]{file, SpringModificationTrackersManager.getInstance((Project)file.getProject()).getOuterModelsModificationTracker()});
            }
        }, false);
    }

    private static void processLocalImports(Map<XmlFile, LocalModelDependency> includes, Beans beans, @Nullable Set<String> activeProfiles) {
        for (SpringImport springImport : beans.getImports()) {
            Set psiFiles = (Set)springImport.getResource().getValue();
            if (psiFiles == null) continue;
            for (PsiFile psiFile : psiFiles) {
                XmlElement springImportXmlElement;
                XmlFile xmlFile;
                if (!(psiFile instanceof XmlFile) || includes.containsKey(xmlFile = (XmlFile)psiFile) || !SpringDomUtils.isSpringXml((XmlFile)xmlFile)) continue;
                DomFileElement fileElement = SpringDomUtils.getSpringDomFileElement((XmlFile)xmlFile);
                assert (fileElement != null) : psiFile;
                Beans child = (Beans)fileElement.getRootElement();
                if (activeProfiles != null && !SpringProfileUtils.isActiveProfile((Beans)child, activeProfiles) || (springImportXmlElement = springImport.getXmlElement()) == null) continue;
                includes.put(xmlFile, LocalModelDependency.create((LocalModelDependencyType)LocalModelDependencyType.IMPORT, (PsiElement)springImportXmlElement));
            }
        }
        for (Beans beanProfiles : beans.getBeansProfiles()) {
            if (activeProfiles != null && !SpringProfileUtils.isActiveProfile((Beans)beanProfiles, activeProfiles)) continue;
            LocalXmlModelImpl.processLocalImports(includes, beanProfiles, activeProfiles);
        }
    }

    private CommonSpringModel getExplicitlyDefinedBeansModel() {
        if (this.explicitlyDefinedBeansModel == null) {
            this.explicitlyDefinedBeansModel = CachedValuesManager.getManager((Project)this.getProject()).createCachedValue((CachedValueProvider)new CachedValueProvider<CommonSpringModel>(){

                public CachedValueProvider.Result<CommonSpringModel> compute() {
                    BeansSpringModel model = new BeansSpringModel(LocalXmlModelImpl.this.getModule(), (NotNullLazyValue)new NotNullLazyValue<Collection<? extends SpringBeanPointer>>(){

                        @NotNull
                        protected Collection<? extends SpringBeanPointer> compute() {
                            LinkedHashSet explicitBeans = ContainerUtil.newLinkedHashSet();
                            Module module = LocalXmlModelImpl.this.getModule();
                            if (LocalXmlModelImpl.isProcessExplicitlyDefinedAnnotatedBeans(module)) {
                                Set explicitBeanPsiClasses = LocalXmlModelImpl.getExplicitBeanCandidatePsiClasses(module);
                                for (PsiClass explicitBeanClass : explicitBeanPsiClasses) {
                                    SpringModelSearchParameters.BeanClass candidateClassParams = SpringModelSearchParameters.byClass((PsiClass)explicitBeanClass).withInheritors().effectiveBeanTypes();
                                    if (!candidateClassParams.canSearch()) continue;
                                    CommonProcessors.FindFirstProcessor findFirstProcessor = new CommonProcessors.FindFirstProcessor();
                                    LocalXmlModelImpl.this.myIndexProcessor.processByClass(candidateClassParams, (Processor<SpringBeanPointer>)findFirstProcessor, LocalXmlModelImpl.this.getActiveProfiles(), true);
                                    if (!findFirstProcessor.isFound()) continue;
                                    explicitBeans.addAll(SpringJamUtils.getInstance().getContextBeans(explicitBeanClass, Collections.emptySet()));
                                }
                            }
                            Set set = BeanService.getInstance().mapSpringBeans((Collection)explicitBeans);
                            if (set == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/LocalXmlModelImpl$14$1", "compute"));
                            }
                            return set;
                        }
                    });
                    return CachedValueProvider.Result.create((Object)model, (Object[])LocalXmlModelImpl.this.getOutsideModelDependencies((LocalModel)LocalXmlModelImpl.this));
                }
            }, false);
        }
        return (CommonSpringModel)this.explicitlyDefinedBeansModel.getValue();
    }

    private static boolean isProcessExplicitlyDefinedAnnotatedBeans(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/contexts/model/LocalXmlModelImpl", "isProcessExplicitlyDefinedAnnotatedBeans"));
        }
        SpringFacet springFacet = SpringFacet.getInstance((Module)module);
        if (springFacet == null) {
            return true;
        }
        CustomSetting setting = springFacet.findSetting("process_explicitly_annotated");
        return setting == null || ((CustomSetting.BOOLEAN)setting).getBooleanValue();
    }

    @NotNull
    private static Set<PsiClass> getExplicitBeanCandidatePsiClasses(final @NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/contexts/model/LocalXmlModelImpl", "getExplicitBeanCandidatePsiClasses"));
        }
        Set set = (Set)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, (CachedValueProvider)new CachedValueProvider<Set<PsiClass>>(){

            public CachedValueProvider.Result<Set<PsiClass>> compute() {
                PsiClass annotationClass = SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.context.annotation.Bean");
                if (annotationClass == null) {
                    return CachedValueProvider.Result.create(Collections.emptySet(), (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
                }
                LinkedHashSet psiClasses = ContainerUtil.newLinkedHashSet();
                GlobalSearchScope searchScope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
                for (PsiMember member : AnnotatedElementsSearch.searchPsiMethods((PsiClass)annotationClass, (SearchScope)searchScope).findAll()) {
                    ContainerUtil.addIfNotNull((Collection)psiClasses, (Object)member.getContainingClass());
                }
                return CachedValueProvider.Result.create((Object)psiClasses, (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
            }
        });
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/LocalXmlModelImpl", "getExplicitBeanCandidatePsiClasses"));
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private List<SpringBeanPointer> computePlaceholders() {
        final Project project = this.getProject();
        SmartList result = new SmartList();
        try {
            PlaceholderDomReferenceInjector.IS_COMPUTING.set(true);
            DomFileElement<Beans> element = this.getRoot();
            if (element != null) {
                CommonProcessors.CollectProcessor<CommonSpringBean> processor = new CommonProcessors.CollectProcessor<CommonSpringBean>((List)result){
                    final /* synthetic */ List val$result;
                    {
                        this.val$result = list;
                    }

                    public boolean process(CommonSpringBean bean) {
                        PsiClass psiClass;
                        String className;
                        if (bean instanceof AbstractDomSpringBean && (className = ((AbstractDomSpringBean)bean).getClassName()) != null && InheritanceUtil.isInheritor((PsiClass)(psiClass = JavaPsiFacade.getInstance((Project)project).findClass(className.trim(), GlobalSearchScope.allScope((Project)project))), (String)"org.springframework.beans.factory.config.PropertyPlaceholderConfigurer")) {
                            this.val$result.add(BeanService.getInstance().createSpringBeanPointer(bean));
                        }
                        return true;
                    }
                };
                this.processDomBeans((Beans)element.getRootElement(), (Processor<CommonSpringBean>)processor);
            }
        }
        finally {
            PlaceholderDomReferenceInjector.IS_COMPUTING.set(false);
        }
        SmartList smartList = result;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/LocalXmlModelImpl", "computePlaceholders"));
        }
        return smartList;
    }
}

