/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.contexts.model.diagram.beans;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.spring.contexts.model.diagram.SpringLocalModelsDataModel;
import com.intellij.spring.contexts.model.diagram.beans.LocalModelGraphElementWrapper;
import com.intellij.spring.contexts.model.diagram.beans.ModuleLocalModelWrapper;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.facet.SpringFileSetService;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FilesetLocalModelWrapper
extends LocalModelGraphElementWrapper<SpringFileSet> {
    private static final String FILESET_PREFIX = "fileset=";
    public static final String DELIMITER = "/";

    protected FilesetLocalModelWrapper(@NotNull SpringFileSet element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/contexts/model/diagram/beans/FilesetLocalModelWrapper", "<init>"));
        }
        super(element);
    }

    @Override
    public String getTitle() {
        return ((SpringFileSet)this.myElement).getName();
    }

    @Override
    public String getToolTip() {
        return "";
    }

    @Override
    public Icon getIcon() {
        return ((SpringFileSet)this.myElement).getIcon();
    }

    @Override
    public String getQualifiedName() {
        return FILESET_PREFIX + ((SpringFileSet)this.myElement).getFacet().getModule().getName() + DELIMITER + ((SpringFileSet)this.myElement).getName();
    }

    public static LocalModelGraphElementWrapper resolveByFQN(String fqn, Project project) {
        if (fqn.startsWith(FILESET_PREFIX)) {
            String path = fqn.substring(FILESET_PREFIX.length());
            if (path.contains(DELIMITER)) {
                SpringFacet facet;
                String moduleName = path.substring(0, path.indexOf(DELIMITER));
                String filesetName = path.substring(path.indexOf(DELIMITER) + 1);
                Module module = ModuleManager.getInstance((Project)project).findModuleByName(moduleName);
                if (module != null && (facet = SpringFacet.getInstance((Module)module)) != null) {
                    for (SpringFileSet fileSet : SpringFileSetService.getInstance().getAllSets(facet)) {
                        if (!fileSet.getName().equals(filesetName)) continue;
                        return new ModuleLocalModelWrapper(module);
                    }
                }
            }
            throw new IllegalArgumentException(String.format("Wrong fileset FQN '%s'", fqn));
        }
        return null;
    }

    @Nullable
    public static LocalModelGraphElementWrapper create(SpringFileSet fileSet) {
        return fileSet == null ? null : new FilesetLocalModelWrapper(fileSet);
    }

    @Override
    public void accept(@NotNull SpringLocalModelsDataModel.RelatedVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/spring/contexts/model/diagram/beans/FilesetLocalModelWrapper", "accept"));
        }
        visitor.visitFileSet((SpringFileSet)this.myElement);
    }
}

