/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.facet;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Disposer;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.SpringFacetConfiguration;
import com.intellij.spring.facet.SpringFacetConfigurationImpl;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.facet.SpringFileSetData;
import com.intellij.spring.facet.SpringFileSetImpl;
import com.intellij.spring.facet.beans.CustomSetting;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SpringFacetImpl
extends SpringFacet {
    private final Set<SpringFileSet> myFileSets = new LinkedHashSet<SpringFileSet>();

    public SpringFacetImpl(FacetType facetType, Module module, String name, SpringFacetConfiguration configuration, Facet underlyingFacet) {
        super(facetType, module, name, configuration, underlyingFacet);
        for (SpringFileSetData fileSetData : ((SpringFacetConfigurationImpl)configuration).getFileSetDescriptors()) {
            SpringFileSetImpl fileSet = new SpringFileSetImpl(fileSetData, this);
            this.myFileSets.add(fileSet);
            Disposer.register((Disposable)this, (Disposable)fileSet);
        }
        Disposer.register((Disposable)this, (Disposable)configuration);
    }

    public Set<SpringFileSet> getFileSets() {
        return Collections.unmodifiableSet(this.myFileSets);
    }

    public SpringFileSet addFileSet(@NonNls @NotNull String id, @NotNull String name) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/spring/facet/SpringFacetImpl", "addFileSet"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/spring/facet/SpringFacetImpl", "addFileSet"));
        }
        return this.addFileSet(new SpringFileSetImpl(id, name, this));
    }

    public SpringFileSet addFileSet(@NotNull SpringFileSet fileSet) {
        if (fileSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileSet", "com/intellij/spring/facet/SpringFacetImpl", "addFileSet"));
        }
        this.myFileSets.add(fileSet);
        ((SpringFacetConfigurationImpl)this.getConfiguration()).addSpringFileSetData(fileSet.getData());
        Disposer.register((Disposable)this, (Disposable)fileSet);
        return fileSet;
    }

    public void removeFileSets() {
        this.myFileSets.clear();
        ((SpringFacetConfigurationImpl)this.getConfiguration()).removeFileSetDescriptors();
    }

    public CustomSetting findSetting(@NotNull String settingName) {
        if (settingName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settingName", "com/intellij/spring/facet/SpringFacetImpl", "findSetting"));
        }
        for (CustomSetting settingBean : ((SpringFacetConfiguration)this.getConfiguration()).getCustomSettings()) {
            if (!settingName.equals(settingBean.getName())) continue;
            return settingBean;
        }
        return null;
    }
}

