/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.facet;

import com.intellij.facet.FacetType;
import com.intellij.framework.FrameworkType;
import com.intellij.framework.detection.DetectedFrameworkDescription;
import com.intellij.framework.detection.FacetBasedFrameworkDetector;
import com.intellij.framework.detection.FileContentPattern;
import com.intellij.framework.detection.FrameworkDetectionContext;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.ElementPattern;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.SpringFacetConfiguration;
import com.intellij.spring.facet.SpringFacetConfigurationImpl;
import com.intellij.spring.facet.SpringFacetType;
import com.intellij.spring.facet.SpringFileSetData;
import com.intellij.spring.facet.SpringFileSetService;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileContent;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class SpringFrameworkDetector
extends FacetBasedFrameworkDetector<SpringFacet, SpringFacetConfiguration> {
    public static final FrameworkType SPRING_FRAMEWORK_TYPE = new SpringFrameworkDetector().getFrameworkType();

    public SpringFrameworkDetector() {
        super("spring");
    }

    protected SpringFacetConfiguration createConfiguration(Collection<VirtualFile> files) {
        SpringFacetConfiguration configuration = (SpringFacetConfiguration)this.getFacetType().createDefaultConfiguration();
        SpringFrameworkDetector.addDefaultFileSet(configuration, files);
        return configuration;
    }

    public List<? extends DetectedFrameworkDescription> detect(@NotNull Collection<VirtualFile> newFiles, @NotNull FrameworkDetectionContext context) {
        if (newFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newFiles", "com/intellij/spring/facet/SpringFrameworkDetector", "detect"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/facet/SpringFrameworkDetector", "detect"));
        }
        Project project = context.getProject();
        if (project == null) {
            return super.detect(newFiles, context);
        }
        final ProjectFileIndex projectFileIndex = ProjectFileIndex.SERVICE.getInstance((Project)project);
        List nonTestDetectedFiles = ContainerUtil.filter(newFiles, (Condition)new Condition<VirtualFile>(){

            public boolean value(VirtualFile virtualFile) {
                return !projectFileIndex.isInTestSourceContent(virtualFile);
            }
        });
        return super.detect((Collection)nonTestDetectedFiles, context);
    }

    private static void addDefaultFileSet(SpringFacetConfiguration configuration, @NotNull Collection<VirtualFile> files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/spring/facet/SpringFrameworkDetector", "addDefaultFileSet"));
        }
        if (files.isEmpty()) {
            return;
        }
        Set empty = Collections.emptySet();
        SpringFileSetData fileSet = SpringFileSetData.create((String)SpringFileSetService.getInstance().getUniqueId(empty), (String)SpringFileSetService.getInstance().getUniqueName(SpringBundle.message("facet.context.default.name", new Object[0]), empty));
        for (VirtualFile file : files) {
            fileSet.addFile(file.getUrl());
        }
        ((SpringFacetConfigurationImpl)configuration).addSpringFileSetData(fileSet);
    }

    public FacetType<SpringFacet, SpringFacetConfiguration> getFacetType() {
        return FacetType.findInstance(SpringFacetType.class);
    }

    @NotNull
    public FileType getFileType() {
        LanguageFileType languageFileType = StdFileTypes.XML;
        if (languageFileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/facet/SpringFrameworkDetector", "getFileType"));
        }
        return languageFileType;
    }

    @NotNull
    public ElementPattern<FileContent> createSuitableFilePattern() {
        FileContentPattern fileContentPattern = FileContentPattern.fileContent().xmlWithRootTagNamespace("http://www.springframework.org/schema/beans");
        if (fileContentPattern == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/facet/SpringFrameworkDetector", "createSuitableFilePattern"));
        }
        return fileContentPattern;
    }
}

