/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.facet;

import com.intellij.facet.ui.FacetBasedFrameworkSupportProvider;
import com.intellij.framework.library.DownloadableLibraryService;
import com.intellij.framework.library.FrameworkSupportWithLibrary;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.ide.util.frameworkSupport.FrameworkRole;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportConfigurableBase;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportModel;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportProviderBase;
import com.intellij.ide.util.frameworkSupport.FrameworkVersion;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.libraries.CustomLibraryDescription;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.facet.SpringConfigurator;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.facet.SpringFileSetService;
import com.intellij.spring.facet.SpringProjectCategory;
import com.intellij.spring.library.SpringLibraryType;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.util.ObjectUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collections;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringFrameworkSupportProvider
extends FacetBasedFrameworkSupportProvider<SpringFacet> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.spring.facet.SpringFrameworkSupportProvider");
    @NonNls
    private static final String SPRING_CONFIG_XML = "spring-config.xml";
    private boolean myCreateEmptySpringXml;

    public SpringFrameworkSupportProvider() {
        super(SpringFacet.getSpringFacetType());
    }

    public String[] getPrecedingFrameworkProviderIds() {
        return new String[]{"facet:web", "facet:jsf"};
    }

    public String getTitle() {
        return SpringBundle.message("framework.title.spring", new Object[0]);
    }

    @NotNull
    public String[] getProjectCategories() {
        String[] stringArray = new String[]{SpringFacet.FACET_TYPE_ID.toString()};
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/facet/SpringFrameworkSupportProvider", "getProjectCategories"));
        }
        return stringArray;
    }

    public FrameworkRole[] getRoles() {
        return new FrameworkRole[]{SpringProjectCategory.ROLE};
    }

    @NotNull
    public FrameworkSupportConfigurableBase createConfigurable(@NotNull FrameworkSupportModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/spring/facet/SpringFrameworkSupportProvider", "createConfigurable"));
        }
        SpringFrameworkSupportConfigurable springFrameworkSupportConfigurable = new SpringFrameworkSupportConfigurable(model);
        if (springFrameworkSupportConfigurable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/facet/SpringFrameworkSupportProvider", "createConfigurable"));
        }
        return springFrameworkSupportConfigurable;
    }

    public void setupConfiguration(SpringFacet facet, ModifiableRootModel rootModel, FrameworkVersion version) {
    }

    protected void onFacetCreated(final SpringFacet facet, ModifiableRootModel rootModel, FrameworkVersion version) {
        final Module module = facet.getModule();
        StartupManager.getInstance((Project)module.getProject()).runWhenProjectIsInitialized(new Runnable(){

            @Override
            public void run() {
                DumbService.getInstance((Project)module.getProject()).runWhenSmart(new Runnable(){

                    @Override
                    public void run() {
                        SpringConfigurator configurator;
                        boolean configured = false;
                        SpringConfigurator[] springConfiguratorArray = (SpringConfigurator[])Extensions.getExtensions((ExtensionPointName)SpringConfigurator.EP_NAME);
                        int n = springConfiguratorArray.length;
                        for (int i = 0; i < n && !(configured = (configurator = springConfiguratorArray[i]).configure(module)); ++i) {
                        }
                        if (!configured && SpringFrameworkSupportProvider.this.myCreateEmptySpringXml) {
                            try {
                                PsiDirectory directory;
                                VirtualFile[] sourceRoots = ModuleRootManager.getInstance((Module)module).getSourceRoots();
                                if (sourceRoots.length > 0 && (directory = PsiManager.getInstance((Project)module.getProject()).findDirectory(sourceRoots[0])) != null && directory.findFile(SpringFrameworkSupportProvider.SPRING_CONFIG_XML) == null) {
                                    FileTemplate template = SpringCommonUtils.getSpringXmlTemplate((Module[])new Module[]{module});
                                    PsiElement psiElement = FileTemplateUtil.createFromTemplate((FileTemplate)template, (String)SpringFrameworkSupportProvider.SPRING_CONFIG_XML, null, (PsiDirectory)directory);
                                    if (!(psiElement instanceof XmlFile)) {
                                        return;
                                    }
                                    VirtualFile file = ((XmlFile)psiElement).getVirtualFile();
                                    assert (file != null) : psiElement;
                                    SpringFileSetService fileSetService = SpringFileSetService.getInstance();
                                    Set existingSets = Collections.emptySet();
                                    String defaultUniqueId = fileSetService.getUniqueId(existingSets);
                                    String uniqueName = fileSetService.getUniqueName(SpringBundle.message("facet.context.default.name", new Object[0]), existingSets);
                                    SpringFileSet fileSet = facet.addFileSet(defaultUniqueId, uniqueName);
                                    fileSet.addFile(file);
                                }
                            }
                            catch (Exception e) {
                                LOG.error((Throwable)e);
                            }
                        }
                    }
                });
            }
        });
    }

    private class SpringFrameworkSupportConfigurable
    extends FrameworkSupportConfigurableBase
    implements FrameworkSupportWithLibrary {
        public SpringFrameworkSupportConfigurable(FrameworkSupportModel model) {
            super((FrameworkSupportProviderBase)SpringFrameworkSupportProvider.this, model, SpringFrameworkSupportProvider.this.getVersions(), SpringFrameworkSupportProvider.this.getVersionLabelText());
        }

        public JComponent getComponent() {
            JPanel allPanel = new JPanel(new BorderLayout());
            final JBCheckBox createEmptySpringXml = new JBCheckBox("Create empty spring-config.xml");
            createEmptySpringXml.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    SpringFrameworkSupportProvider.this.myCreateEmptySpringXml = createEmptySpringXml.isSelected();
                }
            });
            allPanel.add((Component)createEmptySpringXml, "North");
            allPanel.add((Component)ObjectUtils.assertNotNull((Object)super.getComponent()), "Center");
            return allPanel;
        }

        public void addSupport(@NotNull Module module, @NotNull ModifiableRootModel rootModel, @Nullable Library library) {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/facet/SpringFrameworkSupportProvider$SpringFrameworkSupportConfigurable", "addSupport"));
            }
            if (rootModel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootModel", "com/intellij/spring/facet/SpringFrameworkSupportProvider$SpringFrameworkSupportConfigurable", "addSupport"));
            }
            super.addSupport(module, rootModel, library);
        }

        @NotNull
        public CustomLibraryDescription createLibraryDescription() {
            CustomLibraryDescription customLibraryDescription = DownloadableLibraryService.getInstance().createDescriptionForType(SpringLibraryType.class);
            if (customLibraryDescription == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/facet/SpringFrameworkSupportProvider$SpringFrameworkSupportConfigurable", "createLibraryDescription"));
            }
            return customLibraryDescription;
        }

        public boolean isLibraryOnly() {
            return false;
        }
    }
}

