/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.facet.searchers;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.spring.facet.searchers.ConfigSearcherScopeModifier;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomService;
import com.intellij.xml.config.ConfigFileSearcher;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlConfigSearcher
extends ConfigFileSearcher {
    private final GlobalSearchScope myScope;

    public XmlConfigSearcher(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/facet/searchers/XmlConfigSearcher", "<init>"));
        }
        this(module, true);
    }

    public XmlConfigSearcher(@NotNull Module module, boolean withDependenciesAndLibraries) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/facet/searchers/XmlConfigSearcher", "<init>"));
        }
        super(module, module.getProject());
        GlobalSearchScope notTestsScope = GlobalSearchScope.notScope((GlobalSearchScope)module.getModuleTestsWithDependentsScope());
        GlobalSearchScope moduleContentWithoutTests = module.getModuleContentScope().intersectWith(notTestsScope);
        GlobalSearchScope scope = withDependenciesAndLibraries ? GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module, (boolean)false) : GlobalSearchScope.moduleScope((Module)module);
        scope = scope.union((SearchScope)moduleContentWithoutTests).intersectWith(notTestsScope);
        this.myScope = ConfigSearcherScopeModifier.runModifiers((Module)module, (GlobalSearchScope)scope);
    }

    public Set<PsiFile> search(@Nullable Module module, @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/facet/searchers/XmlConfigSearcher", "search"));
        }
        if (module == null) {
            return Collections.emptySet();
        }
        List elements = DomService.getInstance().getFileElements(Beans.class, project, this.myScope);
        return ContainerUtil.map2Set((Collection)elements, (Function)new Function<DomFileElement<Beans>, PsiFile>(){

            public PsiFile fun(DomFileElement<Beans> element) {
                return element.getFile();
            }
        });
    }
}

