/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.factories.resolvers;

import com.intellij.psi.PsiClassType;
import com.intellij.spring.factories.resolvers.AbstractProxiedTypeResolver;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.xml.beans.SpringBean;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScopedProxyFactoryBeanTypeResolver
extends AbstractProxiedTypeResolver {
    @NonNls
    private static final String FACTORY_CLASS = "org.springframework.aop.scope.ScopedProxyFactoryBean";
    @NonNls
    private static final String TARGET_BEAN_NAME_PROPERTY_NAME = "targetBeanName";

    @Override
    @NotNull
    public Set<String> getObjectType(@Nullable CommonSpringBean context) {
        SpringBean springBean;
        PsiClassType type;
        if (context instanceof SpringBean && (type = ScopedProxyFactoryBeanTypeResolver.getTargetType(springBean = (SpringBean)context)) != null) {
            Set<String> targetInterfaceNames;
            if (ScopedProxyFactoryBeanTypeResolver.isBooleanPropertySetAndFalse(springBean, "proxyTargetClass") && !(targetInterfaceNames = ScopedProxyFactoryBeanTypeResolver.getAllInterfaceNames(type)).isEmpty()) {
                Set<String> set = targetInterfaceNames;
                if (set == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/factories/resolvers/ScopedProxyFactoryBeanTypeResolver", "getObjectType"));
                }
                return set;
            }
            Set<String> set = Collections.singleton(type.getCanonicalText());
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/factories/resolvers/ScopedProxyFactoryBeanTypeResolver", "getObjectType"));
            }
            return set;
        }
        Set<String> set = Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/factories/resolvers/ScopedProxyFactoryBeanTypeResolver", "getObjectType"));
        }
        return set;
    }

    @Nullable
    private static PsiClassType getTargetType(@NotNull SpringBean context) {
        PsiClassType fromTargetName;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/factories/resolvers/ScopedProxyFactoryBeanTypeResolver", "getTargetType"));
        }
        String targetBeanName = ScopedProxyFactoryBeanTypeResolver.getPropertyValue((CommonSpringBean)context, TARGET_BEAN_NAME_PROPERTY_NAME);
        if (targetBeanName != null && (fromTargetName = ScopedProxyFactoryBeanTypeResolver.getTypeFromBeanName(context, targetBeanName)) != null) {
            return fromTargetName;
        }
        return null;
    }

    @Override
    public boolean accept(@NotNull String factoryClassName) {
        if (factoryClassName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factoryClassName", "com/intellij/spring/factories/resolvers/ScopedProxyFactoryBeanTypeResolver", "accept"));
        }
        return FACTORY_CLASS.equals(factoryClassName);
    }
}

