/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.impl;

import com.intellij.facet.FacetFinder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.SpringManager;
import com.intellij.spring.SpringModificationTrackersManager;
import com.intellij.spring.contexts.chooser.SpringContextDescriptor;
import com.intellij.spring.contexts.chooser.SpringMultipleContextsManager;
import com.intellij.spring.contexts.model.CombinedSpringModelImpl;
import com.intellij.spring.contexts.model.LocalAnnotationModel;
import com.intellij.spring.contexts.model.LocalXmlModel;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.impl.SpringCachedModelFactory;
import com.intellij.spring.impl.SpringCombinedModelFactory;
import com.intellij.spring.model.jam.SpringJamModel;
import com.intellij.spring.model.jam.stereotype.SpringConfiguration;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.xml.DomService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringManagerImpl
extends SpringManager {
    private static String AUTOCONFIG_PROPERTY = "idea.spring.autoconfig";
    private static final Key<CachedValue<Set<SpringModel>>> ALL_MODELS_MODULE_WITH_DEPS = Key.create((String)"ALL_MODELS_MODULE_WITH_DEPS");
    private final Project myProject;

    public SpringManagerImpl(Project project) {
        this.myProject = project;
    }

    @NotNull
    public Object[] getModelsDependencies(@NotNull Module module, Object ... additional) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/impl/SpringManagerImpl", "getModelsDependencies"));
        }
        ArrayList<Object> dependencies = new ArrayList<Object>(6);
        Collections.addAll(dependencies, additional);
        Object[] objectArray = SpringManagerImpl.addModuleModelsDependencies(module, dependencies).toArray();
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/impl/SpringManagerImpl", "getModelsDependencies"));
        }
        return objectArray;
    }

    @NotNull
    private static Collection<Object> addModuleModelsDependencies(@NotNull Module module, Collection<Object> dependencies) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/impl/SpringManagerImpl", "addModuleModelsDependencies"));
        }
        Project project = module.getProject();
        SpringModificationTrackersManager modificationTrackersManager = SpringModificationTrackersManager.getInstance((Project)project);
        dependencies.add(modificationTrackersManager.getProfilesModificationTracker());
        dependencies.add(modificationTrackersManager.getMultipleContextsModificationTracker());
        dependencies.add(ProjectRootManager.getInstance((Project)project));
        dependencies.add(FacetFinder.getInstance((Project)project).getAllFacetsOfTypeModificationTracker(SpringFacet.FACET_TYPE_ID));
        SpringFacet facet = SpringFacet.getInstance((Module)module);
        if (facet != null) {
            dependencies.add(facet.getConfiguration());
        }
        Collection<Object> collection = dependencies;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/impl/SpringManagerImpl", "addModuleModelsDependencies"));
        }
        return collection;
    }

    @NotNull
    public Set<SpringModel> getAllModels(final @NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/impl/SpringManagerImpl", "getAllModels"));
        }
        Set set = (Set)CachedValuesManager.getManager((Project)this.myProject).getCachedValue((UserDataHolder)module, ALL_MODELS_MODULE_WITH_DEPS, (CachedValueProvider)new CachedValueProvider<Set<SpringModel>>(){

            public CachedValueProvider.Result<Set<SpringModel>> compute() {
                Set<SpringModel> models = SpringManagerImpl.isAutoConfigMode() ? SpringManagerImpl.this.getAutoConfiguredModels(module) : SpringManagerImpl.computeAllModels(module, true);
                Object[] dependencies = SpringManagerImpl.this.getModelsDependencies(module, PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT);
                return CachedValueProvider.Result.create(models, (Object[])dependencies);
            }
        }, false);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/impl/SpringManagerImpl", "getAllModels"));
        }
        return set;
    }

    @NotNull
    public Set<SpringModel> getAllModelsWithoutDependencies(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/impl/SpringManagerImpl", "getAllModelsWithoutDependencies"));
        }
        Set<SpringModel> set = SpringCombinedModelFactory.getAllModelsWithoutDependencies(module);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/impl/SpringManagerImpl", "getAllModelsWithoutDependencies"));
        }
        return set;
    }

    @NotNull
    public Set<SpringModel> getAutoConfiguredModels(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/impl/SpringManagerImpl", "getAutoConfiguredModels"));
        }
        LinkedHashSet models = ContainerUtilRt.newLinkedHashSet();
        models.addAll(SpringManagerImpl.getModels(module));
        Set modules = ContainerUtil.newConcurrentSet();
        ModuleUtilCore.getDependencies((Module)module, (Set)modules);
        for (Module dependency : modules) {
            models.addAll(SpringManagerImpl.getModels(dependency));
        }
        LinkedHashSet annotationModels = ContainerUtil.newLinkedHashSet();
        for (SpringConfiguration configuration : SpringJamModel.getModel((Module)module).getConfigurations(GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module))) {
            LocalAnnotationModel annotationModel = SpringCachedModelFactory.getOrCreateLocalAnnotationModel(configuration, module, Collections.emptySet());
            if (annotationModel == null) continue;
            annotationModels.add(annotationModel);
        }
        if (annotationModels.size() > 0) {
            models.add(new CombinedSpringModelImpl(annotationModels, module));
        }
        Set<SpringModel> set = Collections.singleton(new CombinedSpringModelImpl(models, module));
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/impl/SpringManagerImpl", "getAutoConfiguredModels"));
        }
        return set;
    }

    private static Set<SpringModel> getModels(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/impl/SpringManagerImpl", "getModels"));
        }
        return SpringManagerImpl.createXmlModelsForAllSpringConfigs(module, GlobalSearchScope.moduleWithLibrariesScope((Module)module));
    }

    @NotNull
    public SpringModel getCombinedModel(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/impl/SpringManagerImpl", "getCombinedModel"));
        }
        CombinedSpringModelImpl combinedSpringModelImpl = new CombinedSpringModelImpl(this.getAllModels(module), module);
        if (combinedSpringModelImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/impl/SpringManagerImpl", "getCombinedModel"));
        }
        return combinedSpringModelImpl;
    }

    private static Set<SpringModel> computeAllModels(@NotNull Module module, boolean withDependentModules) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/impl/SpringManagerImpl", "computeAllModels"));
        }
        final Ref hasModels = Ref.create((Object)false);
        final Ref hasFacets = Ref.create((Object)false);
        final LinkedHashSet<SpringModel> result = new LinkedHashSet<SpringModel>();
        ModuleUtilCore.ModuleVisitor visitor = new ModuleUtilCore.ModuleVisitor(){

            public boolean visit(Module module) {
                if (!((Boolean)hasFacets.get()).booleanValue()) {
                    hasFacets.set((Object)(SpringFacet.getInstance((Module)module) != null ? 1 : 0));
                }
                Set<SpringModel> models = SpringCombinedModelFactory.getAllModelsWithoutDependencies(module);
                for (SpringModel springModel : models) {
                    hasModels.set((Object)true);
                    result.add(springModel);
                }
                return true;
            }
        };
        if (withDependentModules) {
            ModuleUtilCore.visitMeAndDependentModules((Module)module, (ModuleUtilCore.ModuleVisitor)visitor);
            LinkedHashSet dependencies = new LinkedHashSet();
            ModuleUtilCore.getDependencies((Module)module, dependencies);
            for (Module dep : dependencies) {
                visitor.visit(dep);
            }
        } else {
            visitor.visit(module);
        }
        if (result.isEmpty() && !((Boolean)hasModels.get()).booleanValue() && ((Boolean)hasFacets.get()).booleanValue()) {
            GlobalSearchScope scope = GlobalSearchScope.moduleWithDependentsScope((Module)module).intersectWith(GlobalSearchScopesCore.projectProductionScope((Project)module.getProject()));
            return SpringManagerImpl.createXmlModelsForAllSpringConfigs(module, scope);
        }
        SpringCombinedModelFactory.setDependencies(result);
        return result;
    }

    @NotNull
    private static Set<SpringModel> createXmlModelsForAllSpringConfigs(Module module, GlobalSearchScope scope) {
        HashSet localXmlModels = ContainerUtil.newHashSet();
        Project project = module.getProject();
        Collection files = DomService.getInstance().getDomFileCandidates(Beans.class, project, scope);
        for (VirtualFile virtualFile : files) {
            XmlFile xmlFile;
            SpringModel localModel;
            PsiFile file1;
            Module mod = ModuleUtilCore.findModuleForFile((VirtualFile)virtualFile, (Project)project);
            if (mod == null || SpringFacet.getInstance((Module)mod) == null || !((file1 = PsiManager.getInstance((Project)project).findFile(virtualFile)) instanceof XmlFile) || (localModel = SpringCombinedModelFactory.createSingleXmlModel(xmlFile = (XmlFile)file1, mod)) == null) continue;
            localXmlModels.add(localModel);
        }
        HashSet hashSet = localXmlModels;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/impl/SpringManagerImpl", "createXmlModelsForAllSpringConfigs"));
        }
        return hashSet;
    }

    @NotNull
    public Set<SpringModel> getSpringModelsByFile(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/spring/impl/SpringManagerImpl", "getSpringModelsByFile"));
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        if (module == null) {
            Set<SpringModel> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/impl/SpringManagerImpl", "getSpringModelsByFile"));
            }
            return set;
        }
        Set<SpringModel> models = SpringCombinedModelFactory.findModelsInScope(file, module);
        if (!models.isEmpty()) {
            Set<SpringModel> set = models;
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/impl/SpringManagerImpl", "getSpringModelsByFile"));
            }
            return set;
        }
        SpringModel model = SpringCombinedModelFactory.createSingleModel(file, module);
        Set set = ContainerUtil.createMaybeSingletonSet((Object)model);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/impl/SpringManagerImpl", "getSpringModelsByFile"));
        }
        return set;
    }

    @Nullable
    public SpringModel getSpringModelByFile(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/spring/impl/SpringManagerImpl", "getSpringModelByFile"));
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        if (module == null) {
            return null;
        }
        Set<SpringModel> allModels = this.getSpringModelsByFile(file);
        if (allModels.size() == 1) {
            return allModels.iterator().next();
        }
        SpringContextDescriptor descriptor = SpringMultipleContextsManager.getInstance().getContextDescriptor(file);
        if (descriptor.equals((Object)SpringContextDescriptor.LOCAL_CONTEXT)) {
            return SpringCombinedModelFactory.createSingleModel(file, module);
        }
        if (descriptor.equals((Object)SpringContextDescriptor.ALL_CONTEXTS)) {
            return new CombinedSpringModelImpl(allModels, module);
        }
        String descriptorId = descriptor.getId();
        Module descriptorModule = descriptor.getModule();
        if (descriptorModule != null) {
            for (SpringModel model : allModels) {
                SpringFileSet fileSet = model.getFileSet();
                if (fileSet == null || !descriptorId.equals(fileSet.getId()) || !descriptorModule.equals(model.getModule())) continue;
                return model;
            }
        }
        return null;
    }

    @Nullable
    public LocalXmlModel getLocalSpringModel(@NotNull XmlFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/spring/impl/SpringManagerImpl", "getLocalSpringModel"));
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        return module == null ? null : this.getLocalSpringModel(file, module);
    }

    @Nullable
    public LocalXmlModel getLocalSpringModel(@NotNull XmlFile file, @NotNull Module module) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/spring/impl/SpringManagerImpl", "getLocalSpringModel"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/impl/SpringManagerImpl", "getLocalSpringModel"));
        }
        return SpringCachedModelFactory.getOrCreateLocalXmlModel(file, module, null);
    }

    @Nullable
    public LocalAnnotationModel getLocalSpringModel(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/spring/impl/SpringManagerImpl", "getLocalSpringModel"));
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass);
        return module == null ? null : this.getLocalSpringModel(psiClass, module);
    }

    @Nullable
    public LocalAnnotationModel getLocalSpringModel(@NotNull PsiClass psiClass, @NotNull Module module) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/spring/impl/SpringManagerImpl", "getLocalSpringModel"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/impl/SpringManagerImpl", "getLocalSpringModel"));
        }
        return SpringCachedModelFactory.getOrCreateLocalAnnotationModel(psiClass, module, Collections.emptySet());
    }

    public static boolean isAutoConfigMode() {
        return Boolean.parseBoolean(System.getProperty(AUTOCONFIG_PROPERTY, "false"));
    }
}

