/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.converters;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.beanProperties.BeanProperty;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.converters.BeanPropertyConverter;
import com.intellij.spring.model.converters.SpringConverterUtil;
import com.intellij.spring.model.properties.PropertyReference;
import com.intellij.spring.model.properties.PropertyReferenceSet;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BeanPropertyConverterImpl
extends BeanPropertyConverter {
    public List<BeanProperty> fromString(@Nullable String s, ConvertContext context) {
        if (s == null) {
            return null;
        }
        GenericAttributeValue value = (GenericAttributeValue)context.getInvocationElement();
        PropertyReference[] references = this.createReferences((GenericDomValue<List<BeanProperty>>)value, (PsiElement)value.getXmlAttributeValue(), context);
        if (references.length == 0) {
            return null;
        }
        ResolveResult[] results = references[references.length - 1].multiResolve(false);
        ArrayList<BeanProperty> beanProperties = new ArrayList<BeanProperty>(results.length);
        for (ResolveResult result : results) {
            PsiMethod method = (PsiMethod)result.getElement();
            if (method == null) continue;
            BeanProperty beanProperty = BeanProperty.createBeanProperty((PsiMethod)method);
            ContainerUtil.addIfNotNull(beanProperties, (Object)beanProperty);
        }
        return beanProperties;
    }

    public String toString(@Nullable List<BeanProperty> beanProperty, ConvertContext context) {
        return null;
    }

    @NotNull
    public PropertyReference[] createReferences(GenericDomValue<List<BeanProperty>> genericDomValue, PsiElement element, ConvertContext context) {
        if (element == null) {
            PropertyReference[] propertyReferenceArray = new PropertyReference[]{};
            if (propertyReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/converters/BeanPropertyConverterImpl", "createReferences"));
            }
            return propertyReferenceArray;
        }
        CommonSpringBean springBean = SpringConverterUtil.getCurrentBeanCustomAware((ConvertContext)context);
        assert (springBean != null);
        PropertyReference[] propertyReferenceArray = new PropertyReferenceSet(element, springBean.getBeanClass(), genericDomValue, context, springBean).getPsiReferences();
        if (propertyReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/converters/BeanPropertyConverterImpl", "createReferences"));
        }
        return propertyReferenceArray;
    }
}

