/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.converters;

import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.impl.light.LightMethodBuilder;
import com.intellij.psi.scope.processor.MethodResolveProcessor;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.factories.SpringFactoryBeansManager;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.converters.PsiMethodConverter;
import com.intellij.spring.model.converters.SpringBeanFactoryMethodConverter;
import com.intellij.spring.model.converters.SpringConverterUtil;
import com.intellij.spring.model.highlighting.SpringConstructorArgResolveUtil;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericDomValue;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringBeanFactoryMethodConverterImpl
extends SpringBeanFactoryMethodConverter {
    private static final String ASPECT_OF_METHOD_NAME = "aspectOf";
    private static final ThreadLocal<Set<CommonSpringBean>> RECURSION_GUARD = new ThreadLocal<Set<CommonSpringBean>>(){

        @Override
        protected Set<CommonSpringBean> initialValue() {
            return new HashSet<CommonSpringBean>();
        }
    };

    public PsiMethod fromString(@Nullable String methodName, ConvertContext context) {
        if (ASPECT_OF_METHOD_NAME.equals(methodName)) {
            return SpringBeanFactoryMethodConverterImpl.createAspectOfLightMethod(context.getPsiManager());
        }
        return super.fromString(methodName, context);
    }

    @Nullable
    protected PsiClass getPsiClass(ConvertContext context) {
        SpringBean springBean = SpringBeanFactoryMethodConverterImpl.getSpringBean(context);
        return SpringBeanFactoryMethodConverterImpl.getFactoryClass(springBean);
    }

    protected PsiMethodConverter.MethodAccepter getMethodAccepter(ConvertContext context, final boolean forCompletion) {
        SpringBean springBean = SpringBeanFactoryMethodConverterImpl.getSpringBean(context);
        final boolean fromFactoryBean = springBean.getFactoryBean().getValue() != null;
        return new PsiMethodConverter.MethodAccepter(){

            public boolean accept(PsiMethod psiMethod) {
                if (psiMethod.isConstructor() || psiMethod.getReturnType() == null) {
                    return false;
                }
                PsiClass psiClass = psiMethod.getContainingClass();
                assert (psiClass != null);
                String containingClass = psiClass.getQualifiedName();
                return (!forCompletion || containingClass == null || !containingClass.equals("java.lang.Object")) && SpringFactoryBeansManager.getInstance().isValidFactoryMethod(psiMethod, fromFactoryBean);
            }
        };
    }

    @NotNull
    public static List<PsiMethod> getFactoryMethodCandidates(@NotNull SpringBean springBean, @NotNull String methodName) {
        if (springBean == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "springBean", "com/intellij/spring/model/converters/SpringBeanFactoryMethodConverterImpl", "getFactoryMethodCandidates"));
        }
        if (methodName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodName", "com/intellij/spring/model/converters/SpringBeanFactoryMethodConverterImpl", "getFactoryMethodCandidates"));
        }
        PsiClass factoryClass = SpringBeanFactoryMethodConverterImpl.getFactoryClass(springBean);
        SmartList result = new SmartList();
        if (factoryClass != null) {
            PsiMethod[] methods;
            if (ASPECT_OF_METHOD_NAME.equals(methodName)) {
                result.add(SpringBeanFactoryMethodConverterImpl.createAspectOfLightMethod(springBean.getPsiManager()));
            }
            if ((methods = MethodResolveProcessor.findMethod((PsiClass)factoryClass, (String)methodName)).length > 0) {
                boolean fromFactoryBean = springBean.getFactoryBean().getValue() != null;
                for (PsiMethod method : methods) {
                    if (!SpringFactoryBeansManager.getInstance().isValidFactoryMethod(method, fromFactoryBean)) continue;
                    result.add(method);
                }
            }
        }
        SmartList smartList = result;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/converters/SpringBeanFactoryMethodConverterImpl", "getFactoryMethodCandidates"));
        }
        return smartList;
    }

    private static LightMethodBuilder createAspectOfLightMethod(PsiManager manager) {
        return new LightMethodBuilder(manager, ASPECT_OF_METHOD_NAME).setModifiers(new String[]{"static", "public"}).setMethodReturnType("java.lang.Object");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static PsiClass getFactoryClass(SpringBean springBean) {
        PsiClass beanClass = null;
        if (!DomUtil.hasXml((DomElement)springBean.getFactoryBean())) {
            beanClass = springBean.getBeanClass(false);
        } else {
            SpringBeanPointer factoryBeanPointer = (SpringBeanPointer)springBean.getFactoryBean().getValue();
            if (factoryBeanPointer == null) {
                return null;
            }
            CommonSpringBean factoryBean = factoryBeanPointer.getSpringBean();
            if (!factoryBean.equals(springBean) && RECURSION_GUARD.get().add(factoryBean)) {
                try {
                    beanClass = factoryBean.getBeanClass(true);
                }
                finally {
                    RECURSION_GUARD.get().remove(factoryBean);
                }
            }
        }
        if (beanClass != null && SpringFactoryBeansManager.getInstance().isFactoryBeanClass(beanClass)) {
            PsiClass[] types = SpringFactoryBeansManager.getInstance().getProductTypes(beanClass, (CommonSpringBean)springBean);
            return types.length == 0 ? null : types[0];
        }
        return beanClass;
    }

    public LocalQuickFix[] getQuickFixes(ConvertContext context) {
        SpringBean springBean;
        PsiClass psiClass;
        GenericDomValue element = (GenericDomValue)context.getInvocationElement();
        String elementName = element.getStringValue();
        if (elementName != null && elementName.length() > 0 && (psiClass = SpringBeanFactoryMethodConverterImpl.getFactoryMethodClass(springBean = SpringBeanFactoryMethodConverterImpl.getSpringBean(context))) != null && !(psiClass instanceof PsiCompiledElement)) {
            return new LocalQuickFix[]{SpringBeanFactoryMethodConverterImpl.getCreateNewMethodQuickFix(springBean, psiClass, elementName)};
        }
        return LocalQuickFix.EMPTY_ARRAY;
    }

    @Nullable
    private static PsiClass getFactoryMethodClass(SpringBean springBean) {
        SpringBeanPointer factoryBeanPointer = (SpringBeanPointer)springBean.getFactoryBean().getValue();
        return factoryBeanPointer != null ? factoryBeanPointer.getSpringBean().getBeanClass(false) : springBean.getBeanClass(false);
    }

    private static LocalQuickFix getCreateNewMethodQuickFix(final SpringBean springBean, final PsiClass beanClass, final String elementName) {
        return new LocalQuickFix(){

            @NotNull
            public String getName() {
                String string = SpringBundle.message("model.create.factory.method.quickfix.message", SpringBeanFactoryMethodConverterImpl.getSignature(springBean, elementName));
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/converters/SpringBeanFactoryMethodConverterImpl$2", "getName"));
                }
                return string;
            }

            @NotNull
            public String getFamilyName() {
                String string = SpringBundle.message("model.create.factory.method.quickfix.family.name", new Object[0]);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/converters/SpringBeanFactoryMethodConverterImpl$2", "getFamilyName"));
                }
                return string;
            }

            public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/model/converters/SpringBeanFactoryMethodConverterImpl$2", "applyFix"));
                }
                if (descriptor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/spring/model/converters/SpringBeanFactoryMethodConverterImpl$2", "applyFix"));
                }
                try {
                    assert (beanClass != null);
                    PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)beanClass.getProject()).getElementFactory();
                    String signature = SpringBeanFactoryMethodConverterImpl.getSignature(springBean, elementName) + "{ return null; }";
                    PsiMethod method = elementFactory.createMethodFromText(signature, null);
                    beanClass.add((PsiElement)method);
                }
                catch (IncorrectOperationException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    @NonNls
    private static String getSignature(@NotNull SpringBean springBean, @NotNull String elementName) {
        if (springBean == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "springBean", "com/intellij/spring/model/converters/SpringBeanFactoryMethodConverterImpl", "getSignature"));
        }
        if (elementName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementName", "com/intellij/spring/model/converters/SpringBeanFactoryMethodConverterImpl", "getSignature"));
        }
        boolean isStatic = springBean.getFactoryBean().getValue() == null;
        String params = SpringConstructorArgResolveUtil.suggestParamsForConstructorArgsAsString(springBean);
        PsiClass psiClass = springBean.getBeanClass();
        String returnType = psiClass == null ? "java.lang.String" : psiClass.getQualifiedName();
        StringBuilder signature = new StringBuilder();
        signature.append("public");
        signature.append(" ");
        signature.append(isStatic ? "static" : "");
        signature.append(" ");
        signature.append(returnType);
        signature.append(" ");
        signature.append(elementName);
        signature.append(" (");
        signature.append(params);
        signature.append(")");
        return signature.toString();
    }

    @NotNull
    private static SpringBean getSpringBean(ConvertContext context) {
        SpringBean bean = (SpringBean)SpringConverterUtil.getCurrentBean((ConvertContext)context);
        assert (bean != null);
        SpringBean springBean = bean;
        if (springBean == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/converters/SpringBeanFactoryMethodConverterImpl", "getSpringBean"));
        }
        return springBean;
    }

    protected Object[] getVariants(ConvertContext context) {
        return ArrayUtil.append((Object[])super.getVariants(context), (Object)LookupElementBuilder.create((String)ASPECT_OF_METHOD_NAME));
    }
}

