/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.events.jam;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.jam.JamService;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.spring.model.events.beans.PublishEventPointDescriptor;
import com.intellij.spring.model.events.jam.SpringEventListener;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringEventModelUtils {
    private static final String PUBLISH_EVENT_METHOD = "publishEvent";

    @NotNull
    public static List<SpringEventListener> getEventListeners(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/spring/model/events/jam/SpringEventModelUtils", "getEventListeners"));
        }
        List list = JamService.getJamService((Project)aClass.getProject()).getAnnotatedMembersList(aClass, true, true, false, true, new JamMemberMeta[]{SpringEventListener.METHOD_META});
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/events/jam/SpringEventModelUtils", "getEventListeners"));
        }
        return list;
    }

    @NotNull
    public static List<SpringEventListener> getEventListeners(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/model/events/jam/SpringEventModelUtils", "getEventListeners"));
        }
        List<SpringEventListener> list = SpringEventModelUtils.getEventListeners(GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module), module.getProject());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/events/jam/SpringEventModelUtils", "getEventListeners"));
        }
        return list;
    }

    @NotNull
    public static List<SpringEventListener> getEventListeners(@NotNull GlobalSearchScope scope, @NotNull Project project) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/spring/model/events/jam/SpringEventModelUtils", "getEventListeners"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/model/events/jam/SpringEventModelUtils", "getEventListeners"));
        }
        List list = JamService.getJamService((Project)project).getJamMethodElements(SpringEventListener.SEM_KEY, "org.springframework.context.event.EventListener", scope);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/events/jam/SpringEventModelUtils", "getEventListeners"));
        }
        return list;
    }

    @NotNull
    public static Set<PublishEventPointDescriptor> getPublishPoints(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/model/events/jam/SpringEventModelUtils", "getPublishPoints"));
        }
        Set<PublishEventPointDescriptor> set = SpringEventModelUtils.getPublishPoints(GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module), module.getProject());
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/events/jam/SpringEventModelUtils", "getPublishPoints"));
        }
        return set;
    }

    @NotNull
    public static Collection<PublishEventPointDescriptor> getPublishPoints(@NotNull Module module, @NotNull PsiType handledType) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/model/events/jam/SpringEventModelUtils", "getPublishPoints"));
        }
        if (handledType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handledType", "com/intellij/spring/model/events/jam/SpringEventModelUtils", "getPublishPoints"));
        }
        Set<PublishEventPointDescriptor> points = SpringEventModelUtils.getPublishPoints(GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module), module.getProject());
        List<PublishEventPointDescriptor> list = SpringEventModelUtils.filter(points, handledType);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/events/jam/SpringEventModelUtils", "getPublishPoints"));
        }
        return list;
    }

    @NotNull
    public static Set<PublishEventPointDescriptor> getPublishPoints(@NotNull GlobalSearchScope scope, @NotNull Project project) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/spring/model/events/jam/SpringEventModelUtils", "getPublishPoints"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/model/events/jam/SpringEventModelUtils", "getPublishPoints"));
        }
        HashSet descriptors = ContainerUtil.newHashSet();
        for (PsiMethod publishEventMethod : SpringEventModelUtils.getPublishEventMethods(project)) {
            descriptors.addAll(SpringEventModelUtils.searchAndCachePublishPoints(publishEventMethod, (SearchScope)scope));
        }
        descriptors.addAll(SpringEventModelUtils.searchEventListenerDescriptors(scope, project));
        HashSet hashSet = descriptors;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/events/jam/SpringEventModelUtils", "getPublishPoints"));
        }
        return hashSet;
    }

    public static List<PublishEventPointDescriptor> filter(@NotNull Set<PublishEventPointDescriptor> allDescriptors, final @NotNull PsiType eventType) {
        if (allDescriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allDescriptors", "com/intellij/spring/model/events/jam/SpringEventModelUtils", "filter"));
        }
        if (eventType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "eventType", "com/intellij/spring/model/events/jam/SpringEventModelUtils", "filter"));
        }
        return ContainerUtil.filter(allDescriptors, (Condition)new Condition<PublishEventPointDescriptor>(){

            public boolean value(PublishEventPointDescriptor descriptor) {
                PsiType publishType = descriptor.getEventType();
                return publishType != null && eventType.isAssignableFrom(publishType);
            }
        });
    }

    @NotNull
    public static List<SpringEventListener> getEventListeners(@NotNull Module module, final @NotNull PsiType publishType) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/model/events/jam/SpringEventModelUtils", "getEventListeners"));
        }
        if (publishType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "publishType", "com/intellij/spring/model/events/jam/SpringEventModelUtils", "getEventListeners"));
        }
        List list = ContainerUtil.filter(SpringEventModelUtils.getEventListeners(GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module), module.getProject()), (Condition)new Condition<SpringEventListener>(){

            public boolean value(SpringEventListener listener) {
                PsiType eventType = SpringEventModelUtils.getEventListenerHandledType(listener.getPsiElement());
                return eventType != null && eventType.isAssignableFrom(publishType);
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/events/jam/SpringEventModelUtils", "getEventListeners"));
        }
        return list;
    }

    @NotNull
    public static Set<PublishEventPointDescriptor> searchEventListenerDescriptors(@NotNull GlobalSearchScope scope, @NotNull Project project) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/spring/model/events/jam/SpringEventModelUtils", "searchEventListenerDescriptors"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/model/events/jam/SpringEventModelUtils", "searchEventListenerDescriptors"));
        }
        HashSet descriptors = ContainerUtil.newHashSet();
        for (SpringEventListener listener : SpringEventModelUtils.getEventListeners(scope, project)) {
            PsiMethod psiMethod = listener.getPsiElement();
            PsiType returnType = psiMethod.getReturnType();
            if (returnType == null || PsiType.VOID.equals((Object)returnType)) continue;
            descriptors.add(PublishEventPointDescriptor.create(psiMethod));
        }
        HashSet hashSet = descriptors;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/events/jam/SpringEventModelUtils", "searchEventListenerDescriptors"));
        }
        return hashSet;
    }

    public static PsiMethod[] getPublishEventMethods(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/model/events/jam/SpringEventModelUtils", "getPublishEventMethods"));
        }
        PsiClass eventPublisherClass = SpringEventModelUtils.findApplicationEventPublisher(project);
        if (eventPublisherClass != null) {
            return eventPublisherClass.findMethodsByName(PUBLISH_EVENT_METHOD, false);
        }
        return PsiMethod.EMPTY_ARRAY;
    }

    @Nullable
    public static PsiClass findApplicationEventPublisher(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/model/events/jam/SpringEventModelUtils", "findApplicationEventPublisher"));
        }
        return JavaPsiFacade.getInstance((Project)project).findClass("org.springframework.context.ApplicationEventPublisher", GlobalSearchScope.allScope((Project)project));
    }

    @NotNull
    private static Set<PublishEventPointDescriptor> searchAndCachePublishPoints(final @NotNull PsiMethod publishEventMethod, final @NotNull SearchScope searchScope) {
        if (publishEventMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "publishEventMethod", "com/intellij/spring/model/events/jam/SpringEventModelUtils", "searchAndCachePublishPoints"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/intellij/spring/model/events/jam/SpringEventModelUtils", "searchAndCachePublishPoints"));
        }
        Set set = (Set)CachedValuesManager.getCachedValue((PsiElement)publishEventMethod, (CachedValueProvider)new CachedValueProvider<Set<PublishEventPointDescriptor>>(){

            @Nullable
            public CachedValueProvider.Result<Set<PublishEventPointDescriptor>> compute() {
                return CachedValueProvider.Result.create((Object)SpringEventModelUtils.searchPublishPoints(publishEventMethod, searchScope), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
            }
        });
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/events/jam/SpringEventModelUtils", "searchAndCachePublishPoints"));
        }
        return set;
    }

    @NotNull
    private static Set<PublishEventPointDescriptor> searchPublishPoints(@NotNull PsiMethod publishEventMethod, @NotNull SearchScope searchScope) {
        if (publishEventMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "publishEventMethod", "com/intellij/spring/model/events/jam/SpringEventModelUtils", "searchPublishPoints"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/intellij/spring/model/events/jam/SpringEventModelUtils", "searchPublishPoints"));
        }
        final HashSet set = ContainerUtil.newHashSet();
        MethodReferencesSearch.search((PsiMethod)publishEventMethod, (SearchScope)searchScope, (boolean)true).forEach((Processor)new Processor<PsiReference>(){

            public boolean process(PsiReference psiReference) {
                PsiExpression[] expressions;
                PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)psiReference.getElement(), PsiMethodCallExpression.class);
                if (methodCallExpression != null && (expressions = methodCallExpression.getArgumentList().getExpressions()).length == 1) {
                    set.add(PublishEventPointDescriptor.create(expressions[0]));
                }
                return true;
            }
        });
        HashSet hashSet = set;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/events/jam/SpringEventModelUtils", "searchPublishPoints"));
        }
        return hashSet;
    }

    @Nullable
    public static PsiType getEventListenerHandledType(@NotNull PsiMethod method) {
        PsiParameter[] parameters;
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/spring/model/events/jam/SpringEventModelUtils", "getEventListenerHandledType"));
        }
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)method, (String)"org.springframework.context.event.EventListener", (boolean)true) && (parameters = method.getParameterList().getParameters()).length == 1) {
            return parameters[0].getType();
        }
        return null;
    }

    public static boolean isPublishEventExpression(@NotNull PsiMethodCallExpression psiElement) {
        PsiElement element;
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/spring/model/events/jam/SpringEventModelUtils", "isPublishEventExpression"));
        }
        PsiReferenceExpression methodExpression = psiElement.getMethodExpression();
        if (PUBLISH_EVENT_METHOD.equals(methodExpression.getReferenceName()) && (element = methodExpression.resolve()) instanceof PsiMethod) {
            PsiClass containingClass = ((PsiMethod)element).getContainingClass();
            return containingClass != null && InheritanceUtil.isInheritor((PsiClass)containingClass, (String)"org.springframework.context.ApplicationEventPublisher");
        }
        return false;
    }
}

