/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.highlighting.SpringAutowireUtil;
import com.intellij.spring.model.utils.SpringModelUtils;
import com.intellij.spring.model.utils.SpringPropertyUtils;
import com.intellij.spring.model.xml.SpringModelElement;
import com.intellij.spring.model.xml.beans.CNamespaceDomElement;
import com.intellij.spring.model.xml.beans.CNamespaceRefValue;
import com.intellij.spring.model.xml.beans.ConstructorArg;
import com.intellij.spring.model.xml.beans.ConstructorArgDefinition;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.model.xml.beans.SpringInjection;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringConstructorArgResolveUtil {
    private SpringConstructorArgResolveUtil() {
    }

    public static List<PsiMethod> findMatchingMethods(SpringBean springBean) {
        CommonSpringModel model = SpringModelUtils.getInstance().getSpringModel((SpringModelElement)springBean);
        return SpringConstructorArgResolveUtil.findMatchingMethods(springBean, model);
    }

    private static List<PsiMethod> findMatchingMethods(SpringBean springBean, CommonSpringModel springModel) {
        List methods = springBean.getInstantiationMethods();
        if (methods.size() == 0) {
            return methods;
        }
        Set args = springBean.getAllConstructorArgs();
        boolean constructorAutowire = SpringAutowireUtil.isConstructorAutowire(springBean);
        Map<Integer, ConstructorArg> indexedArgs = SpringConstructorArgResolveUtil.getIndexedConstructorArgs(args);
        ArrayList<PsiMethod> accepted = new ArrayList<PsiMethod>(methods.size());
        for (PsiMethod method : methods) {
            PsiParameter[] parameters = method.getParameterList().getParameters();
            if (!SpringConstructorArgResolveUtil.acceptMethodByAutowire(constructorAutowire, args, parameters) || !SpringConstructorArgResolveUtil.acceptMethodByParameterTypes(indexedArgs, constructorAutowire, springModel, args, parameters)) continue;
            accepted.add(method);
        }
        return accepted;
    }

    public static boolean acceptMethodByAutowire(boolean constructorAutowire, Set<ConstructorArg> args, PsiParameter[] parameters) {
        return (constructorAutowire || parameters.length == args.size()) && (!constructorAutowire || parameters.length >= args.size());
    }

    private static boolean acceptMethodByParameterTypes(Map<Integer, ConstructorArg> indexedArgs, boolean constructorAutowire, CommonSpringModel model, Set<ConstructorArg> args, PsiParameter[] parameters) {
        for (int i = 0; i < parameters.length; ++i) {
            PsiParameter parameter = parameters[i];
            if (SpringConstructorArgResolveUtil.acceptParameter(parameter, args, indexedArgs, i) || constructorAutowire && !SpringAutowireUtil.autowireByType(model, parameter.getType(), parameter.getName(), false).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public static boolean acceptParameter(PsiParameter parameter, Collection<ConstructorArg> list, Map<Integer, ConstructorArg> indexedArgs, int i) {
        PsiType psiType = parameter.getType();
        if (indexedArgs.get(i) != null) {
            ConstructorArg arg = indexedArgs.get(i);
            return arg.isAssignable(psiType);
        }
        for (ConstructorArg arg : list) {
            if (indexedArgs.values().contains(arg)) continue;
            return arg.isAssignable(psiType);
        }
        return false;
    }

    public static Map<Integer, ConstructorArg> getIndexedConstructorArgs(Collection<ConstructorArg> list) {
        HashMap<Integer, ConstructorArg> indexed = new HashMap<Integer, ConstructorArg>();
        for (ConstructorArg constructorArg : list) {
            Integer value = (Integer)constructorArg.getIndex().getValue();
            if (value == null) continue;
            indexed.put(value, constructorArg);
        }
        return indexed;
    }

    @Nullable
    public static PsiMethod getSpringBeanConstructor(SpringBean springBean, CommonSpringModel springModel) {
        if (SpringConstructorArgResolveUtil.isInstantiatedByFactory(springBean)) {
            return null;
        }
        List<PsiMethod> psiMethods = SpringConstructorArgResolveUtil.findMatchingMethods(springBean, springModel);
        PsiMethod resolvedConstructor = null;
        for (PsiMethod psiMethod : psiMethods) {
            if (resolvedConstructor != null && resolvedConstructor.getParameterList().getParametersCount() >= psiMethod.getParameterList().getParametersCount()) continue;
            resolvedConstructor = psiMethod;
        }
        return resolvedConstructor;
    }

    public static boolean isInstantiatedByFactory(SpringBean springBean) {
        return DomUtil.hasXml((DomElement)springBean.getFactoryMethod());
    }

    public static boolean hasEmptyConstructor(SpringBean springBean) {
        PsiClass beanClass = springBean.getBeanClass(false);
        if (beanClass != null) {
            PsiMethod[] constructors = beanClass.getConstructors();
            if (constructors.length == 0) {
                return true;
            }
            for (PsiMethod constructor : constructors) {
                if (constructor.getParameterList().getParametersCount() != 0) continue;
                return true;
            }
        }
        return false;
    }

    public static String suggestParamsForConstructorArgsAsString(SpringBean springBean) {
        ArrayList<String> params = new ArrayList<String>();
        for (PsiParameter psiParameter : SpringConstructorArgResolveUtil.suggestParamsForConstructorArgs(springBean)) {
            params.add(psiParameter.getText());
        }
        return StringUtil.join(params, (String)",");
    }

    public static List<PsiParameter> suggestParamsForConstructorArgs(SpringBean springBean) {
        LinkedList<PsiParameter> methodParameters = new LinkedList<PsiParameter>();
        Project project = springBean.getManager().getProject();
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
        PsiClassType defaultParamType = SpringConstructorArgResolveUtil.getDefaultParamType(project, elementFactory);
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
        ArrayList<String> existedNames = new ArrayList<String>();
        List cNamespaceDomElements = springBean.getCNamespaceConstructorArgDefinitions();
        if (cNamespaceDomElements.size() > 0) {
            for (CNamespaceDomElement namespaceDomElement : cNamespaceDomElements) {
                String name = namespaceDomElement.getAttributeName();
                if (StringUtil.isEmptyOrSpaces((String)name)) continue;
                methodParameters.add(elementFactory.createParameter(StringUtil.sanitizeJavaIdentifier((String)name), SpringConstructorArgResolveUtil.getConstructorArgDefinitionType(defaultParamType, (ConstructorArgDefinition)namespaceDomElement)));
            }
        } else {
            for (ConstructorArg arg : SpringConstructorArgResolveUtil.sortConstructorArgsByIndex(springBean.getConstructorArgs())) {
                if (arg == null) continue;
                PsiType type = SpringConstructorArgResolveUtil.getConstructorArgDefinitionType(defaultParamType, (ConstructorArgDefinition)arg);
                String name = SpringConstructorArgResolveUtil.getConstructorArgParamName(codeStyleManager, existedNames, arg, type);
                methodParameters.add(elementFactory.createParameter(name, type));
            }
        }
        return methodParameters;
    }

    private static String getConstructorArgParamName(JavaCodeStyleManager codeStyleManager, List<String> existedNames, ConstructorArg arg, PsiType type) {
        String name = arg.getNameAttr().getStringValue();
        if (StringUtil.isEmptyOrSpaces((String)name) || !PsiNameHelper.getInstance((Project)arg.getManager().getProject()).isIdentifier(name)) {
            SuggestedNameInfo nameInfo = codeStyleManager.suggestVariableName(VariableKind.PARAMETER, null, null, type);
            name = nameInfo.names.length > 0 ? nameInfo.names[0] : "p";
            int i = 1;
            while (existedNames.contains(name)) {
                name = name + ++i;
            }
        }
        existedNames.add(name);
        return name;
    }

    private static PsiClassType getDefaultParamType(Project project, PsiElementFactory elementFactory) {
        return elementFactory.createTypeByFQClassName("java.lang.String", GlobalSearchScope.allScope((Project)project));
    }

    private static PsiType getConstructorArgDefinitionType(PsiClassType defaultParamType, ConstructorArgDefinition arg) {
        PsiType type = SpringConstructorArgResolveUtil.getConstructorArgType(arg);
        if (type == null || type.equals(PsiType.NULL)) {
            type = defaultParamType;
        }
        return type;
    }

    @Nullable
    private static PsiType getConstructorArgType(@NotNull ConstructorArgDefinition arg) {
        PsiClass[] effectiveBeanType;
        PsiType psiType;
        if (arg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arg", "com/intellij/spring/model/highlighting/SpringConstructorArgResolveUtil", "getConstructorArgType"));
        }
        if (arg instanceof ConstructorArg && (psiType = (PsiType)((ConstructorArg)arg).getType().getValue()) != null) {
            return psiType;
        }
        SpringBeanPointer referencedSpringBean = SpringConstructorArgResolveUtil.getReferencedSpringBean(arg);
        if (referencedSpringBean != null && (effectiveBeanType = referencedSpringBean.getEffectiveBeanType()) != null && effectiveBeanType.length > 0) {
            return PsiTypesUtil.getClassType((PsiClass)effectiveBeanType[0]);
        }
        return null;
    }

    @Nullable
    private static SpringBeanPointer getReferencedSpringBean(ConstructorArgDefinition arg) {
        if (arg instanceof ConstructorArg) {
            return SpringPropertyUtils.findReferencedBean((SpringInjection)((ConstructorArg)arg));
        }
        if (arg instanceof CNamespaceRefValue) {
            return arg.getRefValue();
        }
        return null;
    }

    private static ConstructorArg[] sortConstructorArgsByIndex(List<ConstructorArg> constructorArgs) {
        int i;
        ConstructorArg[] args = new ConstructorArg[constructorArgs.size()];
        Map<Integer, ConstructorArg> indexedConstructorArgs = SpringConstructorArgResolveUtil.getIndexedConstructorArgs(constructorArgs);
        if (indexedConstructorArgs.size() == 0) {
            return constructorArgs.toArray(new ConstructorArg[constructorArgs.size()]);
        }
        ArrayList<ConstructorArg> indexed = new ArrayList<ConstructorArg>();
        for (Integer index : indexedConstructorArgs.keySet()) {
            ConstructorArg arg;
            i = index;
            if (i < 0 || i >= args.length) continue;
            args[i] = arg = indexedConstructorArgs.get(index);
            indexed.add(arg);
        }
        for (ConstructorArg constructorArg : constructorArgs) {
            if (indexed.contains(constructorArg)) continue;
            for (i = 0; i < args.length; ++i) {
                if (args[i] != null) continue;
                args[i] = constructorArg;
            }
        }
        return args;
    }
}

