/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting.jam;

import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.jam.JamService;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.jam.reflect.JamStringAttributeMeta;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementRef;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PsiPackageReference;
import com.intellij.spring.model.highlighting.jam.AbstractSpringJavaConfigInspection;
import com.intellij.spring.model.jam.stereotype.SpringComponentScan;
import com.intellij.spring.model.utils.SpringCommonUtils;
import org.jetbrains.annotations.NotNull;

public class SpringComponentScanInspection
extends AbstractSpringJavaConfigInspection {
    protected void checkClass(PsiClass aClass, ProblemsHolder holder, @NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/model/highlighting/jam/SpringComponentScanInspection", "checkClass"));
        }
        if (!SpringCommonUtils.isConfiguration((PsiClass)aClass)) {
            return;
        }
        JamService jamService = JamService.getJamService((Project)module.getProject());
        SpringComponentScan springComponentScan = (SpringComponentScan)jamService.getJamElement(SpringComponentScan.class, (PsiElement)aClass);
        if (springComponentScan == null) {
            return;
        }
        PsiElementRef ref = PsiElementRef.real((PsiElement)springComponentScan.getAnnotation());
        for (JamStringAttributeMeta.Collection packageAttribute : springComponentScan.getPackageJamAttributes()) {
            for (JamStringAttributeElement stringAttributeElement : packageAttribute.getJam(ref)) {
                PsiLiteral literal = stringAttributeElement.getPsiLiteral();
                if (literal == null) continue;
                for (PsiReference reference : literal.getReferences()) {
                    if (!(reference instanceof PsiPackageReference) || ((PsiPackageReference)reference).multiResolve(false).length != 0) continue;
                    holder.registerProblem(reference);
                }
            }
        }
    }
}

