/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting.jam;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.refactoring.openapi.impl.JavaRenameRefactoringImpl;
import com.intellij.refactoring.rename.RenameDialog;
import com.intellij.refactoring.rename.RenameHandler;
import com.intellij.spring.model.BeanService;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.jam.javaConfig.SpringJavaExternalBean;
import com.intellij.spring.model.jam.javaConfig.SpringOldJavaConfigurationUtil;
import com.intellij.spring.model.utils.SpringBeanUtils;
import com.intellij.spring.model.xml.CustomBeanWrapper;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringExternalBeanReferencesRenameHandler
implements RenameHandler {
    public boolean isAvailableOnDataContext(DataContext dataContext) {
        return false;
    }

    public boolean isRenaming(DataContext dataContext) {
        DomSpringBean springBean = SpringExternalBeanReferencesRenameHandler.getTargetSpringBean(dataContext);
        if (springBean == null) {
            return false;
        }
        List list = SpringOldJavaConfigurationUtil.findExternalBeanReferences((CommonSpringBean)springBean);
        return list.size() > 0;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/model/highlighting/jam/SpringExternalBeanReferencesRenameHandler", "invoke"));
        }
        DomSpringBean springBean = SpringExternalBeanReferencesRenameHandler.getTargetSpringBean(dataContext);
        if (springBean != null) {
            ExternalBeanRenameDialog dialog = new ExternalBeanRenameDialog(springBean, editor);
            dialog.show();
        }
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/model/highlighting/jam/SpringExternalBeanReferencesRenameHandler", "invoke"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/spring/model/highlighting/jam/SpringExternalBeanReferencesRenameHandler", "invoke"));
        }
    }

    public static void doRename(DomSpringBean externalBean, String newName, boolean searchInComments) {
        PsiElement psiElement = BeanService.getInstance().createSpringBeanPointer((CommonSpringBean)externalBean).getPsiElement();
        if (psiElement == null) {
            return;
        }
        JavaRenameRefactoringImpl rename = new JavaRenameRefactoringImpl(psiElement.getProject(), psiElement, newName, searchInComments, false);
        HashSet<PsiElement> psiElements = new HashSet<PsiElement>();
        List list = SpringOldJavaConfigurationUtil.findExternalBeanReferences((CommonSpringBean)externalBean);
        for (SpringJavaExternalBean springBean : list) {
            psiElements.add(springBean.getIdentifyingPsiElement());
            for (SpringBeanPointer pointer : SpringOldJavaConfigurationUtil.findExternalBeans((PsiMethod)springBean.getPsiElement())) {
                if (pointer.isReferenceTo((CommonSpringBean)externalBean)) continue;
                ContainerUtil.addIfNotNull((Object)pointer.getPsiElement(), psiElements);
            }
            for (PsiElement element : psiElements) {
                rename.addElement(element, newName);
            }
        }
        rename.run();
    }

    @Nullable
    private static DomSpringBean getTargetSpringBean(DataContext dataContext) {
        DomElement element;
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (editor != null) {
            PsiElement targetPsiElement = TargetElementUtil.findTargetElement((Editor)editor, (int)1);
            CommonSpringBean value = SpringBeanUtils.getInstance().findBean(targetPsiElement);
            if (value instanceof DomSpringBean) {
                return (DomSpringBean)value;
            }
        }
        return (element = DomUtil.getContextElement((Editor)editor)) instanceof DomSpringBean && !(element instanceof CustomBeanWrapper) ? (DomSpringBean)element : null;
    }

    private static class ExternalBeanRenameDialog
    extends RenameDialog {
        private final DomSpringBean myExternalBean;

        protected ExternalBeanRenameDialog(DomSpringBean externalBean, Editor editor) {
            super(editor.getProject(), (PsiElement)externalBean.getXmlTag(), null, editor);
            this.myExternalBean = externalBean;
        }

        protected void doAction() {
            String newName = this.getNewName();
            boolean searchInComments = this.isSearchInComments();
            SpringExternalBeanReferencesRenameHandler.doRename(this.myExternalBean, newName, searchInComments);
            this.close(0);
        }
    }
}

