/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting.jam;

import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.jam.JamService;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.semantic.SemKey;
import com.intellij.spring.model.highlighting.jam.AbstractSpringJavaConfigInspection;
import com.intellij.spring.model.jam.javaConfig.JavaConfigConfiguration;
import com.intellij.spring.model.jam.javaConfig.SpringJavaConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SpringJavaConfigInspectionBase
extends AbstractSpringJavaConfigInspection {
    public static final Logger LOG = Logger.getInstance((String)"#com.intellij.spring.model.highlighting.jam.SpringJamInspectionBase");

    protected void checkClass(PsiClass aClass, ProblemsHolder holder, @NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/model/highlighting/jam/SpringJavaConfigInspectionBase", "checkClass"));
        }
        SpringJavaConfiguration configuration = this.getJavaConfiguration(aClass, module);
        if (configuration != null) {
            this.checkJavaConfiguration(configuration, module, holder);
        }
    }

    @Nullable
    protected SpringJavaConfiguration getJavaConfiguration(PsiClass aClass, Module module) {
        return SpringJavaConfigInspectionBase.getJavaConfiguration(aClass, module, JavaConfigConfiguration.META.getJamKey());
    }

    @Nullable
    private static <T extends SpringJavaConfiguration> T getJavaConfiguration(PsiClass aClass, Module module, SemKey<T> jamKey) {
        return (T)((SpringJavaConfiguration)JamService.getJamService((Project)module.getProject()).getJamElement(jamKey, (PsiElement)aClass));
    }

    protected abstract void checkJavaConfiguration(SpringJavaConfiguration var1, Module var2, ProblemsHolder var3);
}

