/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.jam;

import com.intellij.jam.JamService;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.spring.model.custom.ComponentScanExtender;
import com.intellij.spring.model.jam.SpringJamModel;
import com.intellij.spring.model.jam.stereotype.CustomSpringComponent;
import com.intellij.spring.model.jam.stereotype.SpringCdiNamed;
import com.intellij.spring.model.jam.stereotype.SpringComponent;
import com.intellij.spring.model.jam.stereotype.SpringConfiguration;
import com.intellij.spring.model.jam.stereotype.SpringController;
import com.intellij.spring.model.jam.stereotype.SpringManagedBean;
import com.intellij.spring.model.jam.stereotype.SpringRepository;
import com.intellij.spring.model.jam.stereotype.SpringService;
import com.intellij.spring.model.jam.stereotype.SpringStereotypeElement;
import com.intellij.spring.model.jam.utils.JamAnnotationTypeUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringJamModelImpl
extends SpringJamModel {
    private final Module myModule;
    private final JamService myJamService;

    public SpringJamModelImpl(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/model/jam/SpringJamModelImpl", "<init>"));
        }
        this.myModule = module;
        this.myJamService = JamService.getJamService((Project)this.myModule.getProject());
    }

    @NotNull
    public List<SpringStereotypeElement> getStereotypeComponents() {
        Project project = this.myModule.getProject();
        if (DumbService.isDumb((Project)project)) {
            List<SpringStereotypeElement> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/SpringJamModelImpl", "getStereotypeComponents"));
            }
            return list;
        }
        List list = (List)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)this.myModule, (CachedValueProvider)new CachedValueProvider<List<SpringStereotypeElement>>(){

            @Nullable
            public CachedValueProvider.Result<List<SpringStereotypeElement>> compute() {
                List<SpringStereotypeElement> components = SpringJamModelImpl.this.getStereotypeComponents(GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)SpringJamModelImpl.this.myModule));
                return CachedValueProvider.Result.create(components, (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/SpringJamModelImpl", "getStereotypeComponents"));
        }
        return list;
    }

    @NotNull
    public List<SpringStereotypeElement> getStereotypeComponents(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/spring/model/jam/SpringJamModelImpl", "getStereotypeComponents"));
        }
        ArrayList<SpringStereotypeElement> stereotypeElements = new ArrayList<SpringStereotypeElement>();
        stereotypeElements.addAll(this.getComponents(scope));
        stereotypeElements.addAll(this.getControllers(scope));
        stereotypeElements.addAll(this.getRepositories(scope));
        stereotypeElements.addAll(this.getServices(scope));
        stereotypeElements.addAll(this.getConfigurations(scope));
        stereotypeElements.addAll(this.getCdiNamed(scope));
        stereotypeElements.addAll(this.getManagedBeans(scope));
        stereotypeElements.addAll(this.getCustomStereotypeComponents(scope));
        stereotypeElements.addAll(this.getStereotypeComponentExtensions(scope));
        ArrayList<SpringStereotypeElement> arrayList = stereotypeElements;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/SpringJamModelImpl", "getStereotypeComponents"));
        }
        return arrayList;
    }

    private List<CustomSpringComponent> getCustomStereotypeComponents(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/spring/model/jam/SpringJamModelImpl", "getCustomStereotypeComponents"));
        }
        SmartList customSpringComponents = new SmartList();
        for (String anno : JamAnnotationTypeUtil.getInstance((Module)this.myModule).getUserDefinedCustomComponentAnnotations()) {
            customSpringComponents.addAll(this.myJamService.getJamClassElements(CustomSpringComponent.JAM_KEY, anno, scope));
        }
        return customSpringComponents;
    }

    private List<SpringStereotypeElement> getStereotypeComponentExtensions(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/spring/model/jam/SpringJamModelImpl", "getStereotypeComponentExtensions"));
        }
        SmartList stereotypeElements = new SmartList();
        for (ComponentScanExtender extender : (ComponentScanExtender[])Extensions.getExtensions((ExtensionPointName)ComponentScanExtender.EP_NAME)) {
            stereotypeElements.addAll(extender.getComponents(scope, this.myModule.getProject()));
        }
        return stereotypeElements;
    }

    @NotNull
    private List<SpringComponent> getComponents(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/spring/model/jam/SpringJamModelImpl", "getComponents"));
        }
        List list = this.myJamService.getJamClassElements((JamMemberMeta)SpringComponent.META, "org.springframework.stereotype.Component", scope);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/SpringJamModelImpl", "getComponents"));
        }
        return list;
    }

    @NotNull
    private List<SpringCdiNamed> getCdiNamed(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/spring/model/jam/SpringJamModelImpl", "getCdiNamed"));
        }
        List list = this.myJamService.getJamClassElements(SpringCdiNamed.META, "javax.inject.Named", scope);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/SpringJamModelImpl", "getCdiNamed"));
        }
        return list;
    }

    @NotNull
    private List<SpringController> getControllers(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/spring/model/jam/SpringJamModelImpl", "getControllers"));
        }
        List controllers = ContainerUtil.newSmartList();
        Collection controllerAnnotations = (Collection)SpringController.getControllerAnnotations().fun((Object)this.myModule);
        for (String anno : controllerAnnotations) {
            controllers.addAll(this.myJamService.getJamClassElements((JamMemberMeta)SpringController.META, anno, scope));
        }
        List list = controllers;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/SpringJamModelImpl", "getControllers"));
        }
        return list;
    }

    private List<SpringRepository> getRepositories(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/spring/model/jam/SpringJamModelImpl", "getRepositories"));
        }
        List repositories = ContainerUtil.newSmartList();
        Collection repositoryAnnotations = (Collection)SpringRepository.getRepositoryAnnotations().fun((Object)this.myModule);
        for (String anno : repositoryAnnotations) {
            repositories.addAll(this.myJamService.getJamClassElements(SpringRepository.META, anno, scope));
        }
        return repositories;
    }

    @NotNull
    private List<SpringService> getServices(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/spring/model/jam/SpringJamModelImpl", "getServices"));
        }
        List services = ContainerUtil.newSmartList();
        Collection serviceAnnotations = (Collection)SpringService.getServiceAnnotations().fun((Object)this.myModule);
        for (String anno : serviceAnnotations) {
            services.addAll(this.myJamService.getJamClassElements((JamMemberMeta)SpringService.META, anno, scope));
        }
        List list = services;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/SpringJamModelImpl", "getServices"));
        }
        return list;
    }

    @NotNull
    private List<SpringManagedBean> getManagedBeans(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/spring/model/jam/SpringJamModelImpl", "getManagedBeans"));
        }
        List list = this.myJamService.getJamClassElements(SpringManagedBean.META, "javax.annotation.ManagedBean", scope);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/SpringJamModelImpl", "getManagedBeans"));
        }
        return list;
    }

    @NotNull
    public List<SpringConfiguration> getConfigurations(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/spring/model/jam/SpringJamModelImpl", "getConfigurations"));
        }
        if (DumbService.isDumb((Project)this.myModule.getProject())) {
            List<SpringConfiguration> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/SpringJamModelImpl", "getConfigurations"));
            }
            return list;
        }
        List configurations = ContainerUtil.newSmartList();
        Collection configurationAnnotations = (Collection)SpringConfiguration.getAnnotations().fun((Object)this.myModule);
        for (String anno : configurationAnnotations) {
            configurations.addAll(this.myJamService.getJamClassElements((JamMemberMeta)SpringConfiguration.META, anno, scope));
        }
        List list = configurations;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/SpringJamModelImpl", "getConfigurations"));
        }
        return list;
    }
}

