/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.jam.utils.filters;

import com.intellij.spring.model.jam.utils.filters.SpringContextExcludeAnnotationFilter;
import com.intellij.spring.model.jam.utils.filters.SpringContextExcludeAspectJFilter;
import com.intellij.spring.model.jam.utils.filters.SpringContextExcludeAssignableFilter;
import com.intellij.spring.model.jam.utils.filters.SpringContextExcludeRegexpFilter;
import com.intellij.spring.model.jam.utils.filters.SpringContextFilter;
import com.intellij.spring.model.jam.utils.filters.SpringContextIncludeAnnotationFilter;
import com.intellij.spring.model.jam.utils.filters.SpringContextIncludeAspectJFilter;
import com.intellij.spring.model.jam.utils.filters.SpringContextIncludeAssignableFilter;
import com.intellij.spring.model.jam.utils.filters.SpringContextIncludeRegexFilter;
import com.intellij.spring.model.xml.context.Filter;
import com.intellij.spring.model.xml.context.Type;
import com.intellij.util.Function;
import com.intellij.util.containers.hash.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringContextExpressionFilterFactory {
    private static final Map<Type, Function<String, SpringContextFilter.Exclude>> excludeFilters = new HashMap();
    private static final Map<Type, Function<String, SpringContextFilter.Include>> includeFilters = new HashMap();

    private static void registerIncludeFilters() {
        includeFilters.put(Type.ANNOTATION, new Function<String, SpringContextFilter.Include>(){

            public SpringContextFilter.Include fun(String s) {
                return new SpringContextIncludeAnnotationFilter(s);
            }
        });
        includeFilters.put(Type.ASSIGNABLE, new Function<String, SpringContextFilter.Include>(){

            public SpringContextFilter.Include fun(String s) {
                return new SpringContextIncludeAssignableFilter(s);
            }
        });
        includeFilters.put(Type.REGEX, new Function<String, SpringContextFilter.Include>(){

            public SpringContextFilter.Include fun(String s) {
                return new SpringContextIncludeRegexFilter(s);
            }
        });
        includeFilters.put(Type.ASPECTJ, new Function<String, SpringContextFilter.Include>(){

            public SpringContextFilter.Include fun(String s) {
                return new SpringContextIncludeAspectJFilter(s);
            }
        });
    }

    private static void registerExcludeFilters() {
        excludeFilters.put(Type.ANNOTATION, new Function<String, SpringContextFilter.Exclude>(){

            public SpringContextFilter.Exclude fun(String s) {
                return new SpringContextExcludeAnnotationFilter(s);
            }
        });
        excludeFilters.put(Type.ASSIGNABLE, new Function<String, SpringContextFilter.Exclude>(){

            public SpringContextFilter.Exclude fun(String s) {
                return new SpringContextExcludeAssignableFilter(s);
            }
        });
        excludeFilters.put(Type.REGEX, new Function<String, SpringContextFilter.Exclude>(){

            public SpringContextFilter.Exclude fun(String s) {
                return new SpringContextExcludeRegexpFilter(s);
            }
        });
        excludeFilters.put(Type.ASPECTJ, new Function<String, SpringContextFilter.Exclude>(){

            public SpringContextFilter.Exclude fun(String s) {
                return new SpringContextExcludeAspectJFilter(s);
            }
        });
    }

    @NotNull
    public static SpringContextFilter.Exclude createExcludeFilter(@NotNull Filter filter) {
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/spring/model/jam/utils/filters/SpringContextExpressionFilterFactory", "createExcludeFilter"));
        }
        Type type = (Type)filter.getType().getValue();
        String expression = filter.getExpression().getStringValue();
        SpringContextFilter.Exclude exclude = SpringContextExpressionFilterFactory.createExcludeFilter(type, expression);
        if (exclude == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/utils/filters/SpringContextExpressionFilterFactory", "createExcludeFilter"));
        }
        return exclude;
    }

    @NotNull
    public static SpringContextFilter.Include createIncludeFilter(@NotNull Filter filter) {
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/spring/model/jam/utils/filters/SpringContextExpressionFilterFactory", "createIncludeFilter"));
        }
        Type type = (Type)filter.getType().getValue();
        String expression = filter.getExpression().getStringValue();
        SpringContextFilter.Include include = SpringContextExpressionFilterFactory.createIncludeFilter(type, expression);
        if (include == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/utils/filters/SpringContextExpressionFilterFactory", "createIncludeFilter"));
        }
        return include;
    }

    @NotNull
    public static SpringContextFilter.Exclude createExcludeFilter(@Nullable Type type, @Nullable String expression) {
        if (excludeFilters.containsKey(type)) {
            SpringContextFilter.Exclude exclude = (SpringContextFilter.Exclude)excludeFilters.get(type).fun((Object)expression);
            if (exclude == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/utils/filters/SpringContextExpressionFilterFactory", "createExcludeFilter"));
            }
            return exclude;
        }
        SpringContextFilter.Exclude exclude = SpringContextFilter.Exclude.EMPTY_EXCLUDE;
        if (exclude == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/utils/filters/SpringContextExpressionFilterFactory", "createExcludeFilter"));
        }
        return exclude;
    }

    @NotNull
    public static SpringContextFilter.Include createIncludeFilter(@Nullable Type type, @Nullable String expression) {
        if (includeFilters.containsKey(type)) {
            SpringContextFilter.Include include = (SpringContextFilter.Include)includeFilters.get(type).fun((Object)expression);
            if (include == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/utils/filters/SpringContextExpressionFilterFactory", "createIncludeFilter"));
            }
            return include;
        }
        SpringContextFilter.Include include = SpringContextFilter.Include.EMPTY_INCLUDE;
        if (include == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/utils/filters/SpringContextExpressionFilterFactory", "createIncludeFilter"));
        }
        return include;
    }

    static {
        SpringContextExpressionFilterFactory.registerExcludeFilters();
        SpringContextExpressionFilterFactory.registerIncludeFilters();
    }
}

