/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.jam.utils.filters;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.spring.model.jam.stereotype.CustomSpringComponent;
import com.intellij.spring.model.jam.stereotype.SpringStereotypeElement;
import com.intellij.spring.model.jam.utils.filters.SpringContextFilter;
import com.intellij.util.containers.hash.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringContextIncludeRegexFilter
extends SpringContextFilter.IncludeExpression {
    public SpringContextIncludeRegexFilter(@Nullable String expression) {
        super(expression);
    }

    @NotNull
    public Set<SpringStereotypeElement> includeStereotypes(@NotNull Module module, @NotNull Set<PsiPackage> packages) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/model/jam/utils/filters/SpringContextIncludeRegexFilter", "includeStereotypes"));
        }
        if (packages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packages", "com/intellij/spring/model/jam/utils/filters/SpringContextIncludeRegexFilter", "includeStereotypes"));
        }
        HashSet components = new HashSet();
        String regexp = this.getExpression();
        if (!StringUtil.isEmptyOrSpaces((String)regexp)) {
            try {
                Pattern pattern = Pattern.compile(regexp);
                for (PsiClass annotatedClass : SpringContextIncludeRegexFilter.findClassesByMask(module, pattern, packages)) {
                    components.add(new CustomSpringComponent(annotatedClass));
                }
            }
            catch (PatternSyntaxException patternSyntaxException) {
                // empty catch block
            }
        }
        HashSet hashSet = components;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/utils/filters/SpringContextIncludeRegexFilter", "includeStereotypes"));
        }
        return hashSet;
    }

    private static Set<PsiClass> findClassesByMask(@NotNull Module module, @NotNull Pattern pattern, @NotNull Set<PsiPackage> packages) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/model/jam/utils/filters/SpringContextIncludeRegexFilter", "findClassesByMask"));
        }
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/spring/model/jam/utils/filters/SpringContextIncludeRegexFilter", "findClassesByMask"));
        }
        if (packages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packages", "com/intellij/spring/model/jam/utils/filters/SpringContextIncludeRegexFilter", "findClassesByMask"));
        }
        HashSet classes = new HashSet();
        GlobalSearchScope searchScope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
        for (PsiPackage psiPackage : packages) {
            SpringContextIncludeRegexFilter.findClassesByMask(pattern, (Set<PsiClass>)classes, psiPackage, searchScope);
        }
        return classes;
    }

    private static void findClassesByMask(@NotNull Pattern pattern, @NotNull Set<PsiClass> classes, @NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope searchScope) {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/spring/model/jam/utils/filters/SpringContextIncludeRegexFilter", "findClassesByMask"));
        }
        if (classes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classes", "com/intellij/spring/model/jam/utils/filters/SpringContextIncludeRegexFilter", "findClassesByMask"));
        }
        if (psiPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiPackage", "com/intellij/spring/model/jam/utils/filters/SpringContextIncludeRegexFilter", "findClassesByMask"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/intellij/spring/model/jam/utils/filters/SpringContextIncludeRegexFilter", "findClassesByMask"));
        }
        for (PsiClass psiClass : psiPackage.getClasses(searchScope)) {
            if (!pattern.matcher(psiClass.getQualifiedName()).matches()) continue;
            classes.add(psiClass);
        }
        for (PsiClass psiClass : psiPackage.getSubPackages()) {
            SpringContextIncludeRegexFilter.findClassesByMask(pattern, classes, (PsiPackage)psiClass, searchScope);
        }
    }
}

