/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.utils;

import com.intellij.jam.JamService;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.PomTarget;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.pom.references.PomService;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiTarget;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringBeanPsiTarget;
import com.intellij.spring.model.custom.CustomComponentsDiscovererHelper;
import com.intellij.spring.model.jam.JamPsiMemberSpringBean;
import com.intellij.spring.model.utils.SpringBeanUtils;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.model.utils.SpringModelUtils;
import com.intellij.spring.model.xml.CustomBean;
import com.intellij.spring.model.xml.CustomBeanPsiElement;
import com.intellij.spring.model.xml.CustomBeanWrapper;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.spring.model.xml.DomSpringBeanContainer;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringBeanUtilsImpl
extends SpringBeanUtils {
    @Nullable
    public CommonSpringBean findBean(@Nullable PomTarget target) {
        if (target instanceof SpringBeanPsiTarget) {
            return ((SpringBeanPsiTarget)target).getSpringBean();
        }
        if (target instanceof PsiTarget) {
            return this.findBean(PomService.convertToPsi((PsiTarget)((PsiTarget)target)));
        }
        return null;
    }

    @Nullable
    public CommonSpringBean findBean(final @Nullable PsiElement identifyingPsiElement) {
        PomTarget target;
        if (identifyingPsiElement == null) {
            return null;
        }
        if (identifyingPsiElement instanceof CustomBeanPsiElement) {
            return ((CustomBeanPsiElement)identifyingPsiElement).getBean();
        }
        if (identifyingPsiElement instanceof PomTargetPsiElement && (target = ((PomTargetPsiElement)identifyingPsiElement).getTarget()) instanceof SpringBeanPsiTarget) {
            return ((SpringBeanPsiTarget)target).getSpringBean();
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)identifyingPsiElement);
        if (module == null || module.isDisposed()) {
            return null;
        }
        JamPsiMemberSpringBean bean = (JamPsiMemberSpringBean)JamService.getJamService((Project)identifyingPsiElement.getProject()).getJamElement(JamPsiMemberSpringBean.PSI_MEMBER_SPRING_BEAN_JAM_KEY, identifyingPsiElement);
        if (bean != null) {
            return bean;
        }
        Collection customComponentModels = CustomComponentsDiscovererHelper.getInstance((Module)module).getCustomModels();
        for (CommonSpringModel model : customComponentModels) {
            SpringBeanPointer found = (SpringBeanPointer)ContainerUtil.find((Iterable)model.getAllCommonBeans(), (Condition)new Condition<SpringBeanPointer>(){

                public boolean value(SpringBeanPointer pointer) {
                    return pointer.isValid() && identifyingPsiElement.equals(pointer.getSpringBean().getIdentifyingPsiElement());
                }
            });
            if (found == null) continue;
            return found.getSpringBean();
        }
        return null;
    }

    @Nullable
    public SpringBeanPointer findBean(@NotNull CommonSpringModel model, @NonNls @NotNull String beanName) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/spring/model/utils/SpringBeanUtilsImpl", "findBean"));
        }
        if (beanName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beanName", "com/intellij/spring/model/utils/SpringBeanUtilsImpl", "findBean"));
        }
        String beanReferenceName = beanName.startsWith("&") ? beanName.substring(1) : beanName;
        return SpringModelSearchers.findBean((CommonSpringModel)model, (String)beanReferenceName);
    }

    @NotNull
    public Set<String> findBeanNames(@NotNull CommonSpringBean bean) {
        if (bean == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bean", "com/intellij/spring/model/utils/SpringBeanUtilsImpl", "findBeanNames"));
        }
        String beanName = bean.getBeanName();
        if (beanName == null) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/utils/SpringBeanUtilsImpl", "findBeanNames"));
            }
            return set;
        }
        if (bean instanceof SpringBean) {
            Set set = SpringModelUtils.getInstance().getSpringModelByBean(bean).getAllBeanNames(beanName);
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/utils/SpringBeanUtilsImpl", "findBeanNames"));
            }
            return set;
        }
        HashSet names = new HashSet();
        names.add(beanName);
        for (String s : bean.getAliases()) {
            if (!StringUtil.isNotEmpty((String)s)) continue;
            names.add(s);
        }
        HashSet hashSet = names;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/utils/SpringBeanUtilsImpl", "findBeanNames"));
        }
        return hashSet;
    }

    public boolean processChildBeans(@NotNull DomElement parent, boolean includeParsedCustomBeanWrappers, @NotNull Processor<CommonSpringBean> processor) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/spring/model/utils/SpringBeanUtilsImpl", "processChildBeans"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/spring/model/utils/SpringBeanUtilsImpl", "processChildBeans"));
        }
        for (DomSpringBean bean : DomUtil.getChildrenOf((DomElement)parent, DomSpringBean.class)) {
            if (bean instanceof CustomBeanWrapper) {
                if (!(!includeParsedCustomBeanWrappers && ((CustomBeanWrapper)bean).isParsed() || processor.process((Object)bean))) {
                    return false;
                }
                List customBeans = ((CustomBeanWrapper)bean).getCustomBeans();
                for (CustomBean customBean : customBeans) {
                    if (processor.process((Object)customBean)) continue;
                    return false;
                }
                continue;
            }
            if (processor.process((Object)bean)) continue;
            return false;
        }
        for (DomSpringBeanContainer container : DomUtil.getChildrenOf((DomElement)parent, DomSpringBeanContainer.class)) {
            if (SpringBeanUtilsImpl.addContainerBeans(container, processor)) continue;
            return false;
        }
        return true;
    }

    private static boolean addContainerBeans(DomSpringBeanContainer container, Processor<CommonSpringBean> processor) {
        Collection children = container.getChildren();
        for (DomSpringBean child : children) {
            if (processor.process((Object)child)) continue;
            return false;
        }
        for (DomSpringBean child : children) {
            if (!(child instanceof DomSpringBeanContainer) || SpringBeanUtilsImpl.addContainerBeans((DomSpringBeanContainer)child, processor)) continue;
            return false;
        }
        return true;
    }
}

